/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RetryContext;
import com.microsoft.azure.storage.RetryInfo;
import com.microsoft.azure.storage.RetryPolicy;
import com.microsoft.azure.storage.RetryPolicyFactory;

public final class RetryLinearRetry
extends RetryPolicy
implements RetryPolicyFactory {
    public RetryLinearRetry() {
        this(30000, 3);
    }

    public RetryLinearRetry(int deltaBackoff, int maxAttempts) {
        super(deltaBackoff, maxAttempts);
    }

    @Override
    public RetryPolicy createInstance(OperationContext opContext) {
        return new RetryLinearRetry(this.deltaBackoffIntervalInMs, this.maximumAttempts);
    }

    @Override
    public RetryInfo evaluate(RetryContext retryContext, OperationContext operationContext) {
        boolean secondaryNotFound = this.evaluateLastAttemptAndSecondaryNotFound(retryContext);
        if (retryContext.getCurrentRetryCount() < this.maximumAttempts) {
            int statusCode = retryContext.getLastRequestResult().getStatusCode();
            if (!secondaryNotFound && statusCode >= 400 && statusCode < 500 || statusCode == 501 || statusCode == 505 || statusCode == 306) {
                return null;
            }
            long retryInterval = Math.max(Math.min(this.deltaBackoffIntervalInMs, 90000), 3000);
            return this.evaluateRetryInfo(retryContext, secondaryNotFound, retryInterval);
        }
        return null;
    }
}

