/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.AuthenticationScheme;
import com.microsoft.azure.storage.LocationMode;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RequestOptions;
import com.microsoft.azure.storage.RetryPolicyFactory;
import com.microsoft.azure.storage.ServiceProperties;
import com.microsoft.azure.storage.ServicePropertiesHandler;
import com.microsoft.azure.storage.ServicePropertiesSerializer;
import com.microsoft.azure.storage.ServiceStats;
import com.microsoft.azure.storage.ServiceStatsHandler;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsAnonymous;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.core.BaseRequest;
import com.microsoft.azure.storage.core.RequestLocationMode;
import com.microsoft.azure.storage.core.StorageRequest;
import com.microsoft.azure.storage.core.StreamMd5AndLength;
import com.microsoft.azure.storage.core.Utility;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import javax.xml.stream.XMLStreamException;

public abstract class ServiceClient {
    private StorageUri storageUri;
    protected StorageCredentials credentials;
    private boolean usePathStyleUris;
    protected AuthenticationScheme authenticationScheme = AuthenticationScheme.SHAREDKEYFULL;

    protected ServiceClient(StorageUri storageUri, StorageCredentials credentials) {
        Utility.assertNotNull("baseUri", storageUri);
        if (!storageUri.isAbsolute()) {
            throw new IllegalArgumentException(String.format("Address %s is a relative address. Only absolute addresses are permitted.", storageUri));
        }
        this.credentials = credentials == null ? StorageCredentialsAnonymous.ANONYMOUS : credentials;
        this.usePathStyleUris = Utility.determinePathStyleFromUri(storageUri.getPrimaryUri());
        this.storageUri = storageUri;
    }

    protected StorageRequest<ServiceClient, Void, ServiceProperties> downloadServicePropertiesImpl(final RequestOptions options, final boolean signAsTable) {
        StorageRequest<ServiceClient, Void, ServiceProperties> getRequest = new StorageRequest<ServiceClient, Void, ServiceProperties>(options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(ServiceClient client, Void parentObject, OperationContext context) throws Exception {
                return BaseRequest.getServiceProperties(client.getEndpoint(), options, null, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, ServiceClient client, OperationContext context) throws Exception {
                if (signAsTable) {
                    StorageRequest.signTableRequest(connection, client, -1L, null);
                } else {
                    StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, null);
                }
            }

            @Override
            public ServiceProperties preProcessResponse(Void parentObject, ServiceClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }

            @Override
            public ServiceProperties postProcessResponse(HttpURLConnection connection, Void parentObject, ServiceClient client, OperationContext context, ServiceProperties storageObject) throws Exception {
                return ServicePropertiesHandler.readServicePropertiesFromStream(connection.getInputStream());
            }
        };
        return getRequest;
    }

    protected StorageRequest<ServiceClient, Void, ServiceStats> getServiceStatsImpl(final RequestOptions options, final boolean signAsTable) {
        StorageRequest<ServiceClient, Void, ServiceStats> getRequest = new StorageRequest<ServiceClient, Void, ServiceStats>(options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.applyLocationModeToRequest();
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(ServiceClient client, Void parentObject, OperationContext context) throws Exception {
                return BaseRequest.getServiceStats(client.getStorageUri().getUri(this.getCurrentLocation()), options, null, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, ServiceClient client, OperationContext context) throws Exception {
                if (signAsTable) {
                    StorageRequest.signTableRequest(connection, client, -1L, null);
                } else {
                    StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, null);
                }
            }

            @Override
            public ServiceStats preProcessResponse(Void parentObject, ServiceClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }

            @Override
            public ServiceStats postProcessResponse(HttpURLConnection connection, Void parentObject, ServiceClient client, OperationContext context, ServiceStats storageObject) throws Exception {
                return ServiceStatsHandler.readServiceStatsFromStream(connection.getInputStream());
            }
        };
        return getRequest;
    }

    public final StorageCredentials getCredentials() {
        return this.credentials;
    }

    public final AuthenticationScheme getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public final URI getEndpoint() {
        return this.storageUri.getPrimaryUri();
    }

    public final StorageUri getStorageUri() {
        return this.storageUri;
    }

    protected boolean isUsePathStyleUris() {
        return this.usePathStyleUris;
    }

    protected final void setCredentials(StorageCredentials credentials) {
        this.credentials = credentials;
    }

    protected final void setStorageUri(StorageUri storageUri) {
        this.usePathStyleUris = Utility.determinePathStyleFromUri(storageUri.getPrimaryUri());
        this.storageUri = storageUri;
    }

    public final void setAuthenticationScheme(AuthenticationScheme scheme) {
        this.authenticationScheme = scheme;
    }

    protected StorageRequest<ServiceClient, Void, Void> uploadServicePropertiesImpl(ServiceProperties properties, final RequestOptions options, OperationContext opContext, final boolean signAsTable) throws StorageException {
        try {
            byte[] propertiesBytes = ServicePropertiesSerializer.serializeToByteArray(properties);
            final ByteArrayInputStream sendStream = new ByteArrayInputStream(propertiesBytes);
            final StreamMd5AndLength descriptor = Utility.analyzeStream(sendStream, -1L, -1L, true, true);
            StorageRequest<ServiceClient, Void, Void> putRequest = new StorageRequest<ServiceClient, Void, Void>(options, this.getStorageUri()){

                @Override
                public HttpURLConnection buildRequest(ServiceClient client, Void parentObject, OperationContext context) throws Exception {
                    this.setSendStream(sendStream);
                    this.setLength(descriptor.getLength());
                    return BaseRequest.setServiceProperties(client.getEndpoint(), options, null, context);
                }

                @Override
                public void setHeaders(HttpURLConnection connection, Void parentObject, OperationContext context) {
                    connection.setRequestProperty("Content-MD5", descriptor.getMd5());
                }

                @Override
                public void signRequest(HttpURLConnection connection, ServiceClient client, OperationContext context) throws Exception {
                    if (signAsTable) {
                        StorageRequest.signTableRequest(connection, client, descriptor.getLength(), null);
                    } else {
                        StorageRequest.signBlobQueueAndFileRequest(connection, client, descriptor.getLength(), null);
                    }
                }

                @Override
                public Void preProcessResponse(Void parentObject, ServiceClient client, OperationContext context) throws Exception {
                    if (this.getResult().getStatusCode() != 202) {
                        this.setNonExceptionedRetryableFailure(true);
                    }
                    return null;
                }

                @Override
                public void recoveryAction(OperationContext context) throws IOException {
                    sendStream.reset();
                    sendStream.mark(0x4000000);
                }
            };
            return putRequest;
        }
        catch (IllegalArgumentException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
        catch (XMLStreamException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
        catch (IOException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
    }

    @Deprecated
    public final LocationMode getLocationMode() {
        return this.getDefaultRequestOptions().getLocationMode();
    }

    @Deprecated
    public final RetryPolicyFactory getRetryPolicyFactory() {
        return this.getDefaultRequestOptions().getRetryPolicyFactory();
    }

    @Deprecated
    public final int getTimeoutInMs() {
        return this.getDefaultRequestOptions().getTimeoutIntervalInMs();
    }

    @Deprecated
    public Integer getMaximumExecutionTimeInMs() {
        return this.getDefaultRequestOptions().getMaximumExecutionTimeInMs();
    }

    @Deprecated
    public void setLocationMode(LocationMode locationMode) {
        this.getDefaultRequestOptions().setLocationMode(locationMode);
    }

    @Deprecated
    public void setRetryPolicyFactory(RetryPolicyFactory retryPolicyFactory) {
        this.getDefaultRequestOptions().setRetryPolicyFactory(retryPolicyFactory);
    }

    @Deprecated
    public final void setTimeoutInMs(int timeoutInMs) {
        this.getDefaultRequestOptions().setTimeoutIntervalInMs(timeoutInMs);
    }

    @Deprecated
    public void setMaximumExecutionTimeInMs(Integer maximumExecutionTimeInMs) {
        this.getDefaultRequestOptions().setMaximumExecutionTimeInMs(maximumExecutionTimeInMs);
    }

    public abstract RequestOptions getDefaultRequestOptions();
}

