/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.queue;

import com.microsoft.azure.storage.DoesServiceRequest;
import com.microsoft.azure.storage.LocationMode;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RequestOptions;
import com.microsoft.azure.storage.ResultContinuation;
import com.microsoft.azure.storage.ResultContinuationType;
import com.microsoft.azure.storage.ResultSegment;
import com.microsoft.azure.storage.RetryExponentialRetry;
import com.microsoft.azure.storage.ServiceClient;
import com.microsoft.azure.storage.ServiceProperties;
import com.microsoft.azure.storage.ServiceStats;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.core.ExecutionEngine;
import com.microsoft.azure.storage.core.LazySegmentedIterable;
import com.microsoft.azure.storage.core.ListResponse;
import com.microsoft.azure.storage.core.ListingContext;
import com.microsoft.azure.storage.core.SegmentedStorageRequest;
import com.microsoft.azure.storage.core.StorageRequest;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.queue.CloudQueue;
import com.microsoft.azure.storage.queue.QueueListHandler;
import com.microsoft.azure.storage.queue.QueueListingDetails;
import com.microsoft.azure.storage.queue.QueueRequest;
import com.microsoft.azure.storage.queue.QueueRequestOptions;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;

public final class CloudQueueClient
extends ServiceClient {
    private QueueRequestOptions defaultRequestOptions;

    public CloudQueueClient(URI baseUri, StorageCredentials credentials) {
        this(new StorageUri(baseUri, null), credentials);
    }

    public CloudQueueClient(StorageUri baseUri, StorageCredentials credentials) {
        super(baseUri, credentials);
        if (credentials == null) {
            throw new IllegalArgumentException("StorageCredentials cannot be null for the Queue service.");
        }
        this.defaultRequestOptions = new QueueRequestOptions();
        this.defaultRequestOptions.setLocationMode(LocationMode.PRIMARY_ONLY);
        this.defaultRequestOptions.setRetryPolicyFactory(new RetryExponentialRetry());
    }

    public CloudQueue getQueueReference(String queueName) throws URISyntaxException, StorageException {
        return new CloudQueue(queueName, this);
    }

    @DoesServiceRequest
    public Iterable<CloudQueue> listQueues() {
        return this.listQueues(null, QueueListingDetails.NONE, null, null);
    }

    @DoesServiceRequest
    public Iterable<CloudQueue> listQueues(String prefix) {
        return this.listQueues(prefix, QueueListingDetails.NONE, null, null);
    }

    @DoesServiceRequest
    public Iterable<CloudQueue> listQueues(String prefix, QueueListingDetails detailsIncluded, QueueRequestOptions options, OperationContext opContext) {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = QueueRequestOptions.applyDefaults(options, this);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        return new LazySegmentedIterable<CloudQueueClient, Object, CloudQueue>(this.listQueuesSegmentedImpl(prefix, detailsIncluded, -1, options, segmentedRequest), this, null, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public ResultSegment<CloudQueue> listQueuesSegmented() throws StorageException {
        return this.listQueuesSegmented(null, QueueListingDetails.NONE, 0, null, null, null);
    }

    @DoesServiceRequest
    public ResultSegment<CloudQueue> listQueuesSegmented(String prefix) throws StorageException {
        return this.listQueuesSegmented(prefix, QueueListingDetails.NONE, 0, null, null, null);
    }

    @DoesServiceRequest
    public ResultSegment<CloudQueue> listQueuesSegmented(String prefix, QueueListingDetails detailsIncluded, int maxResults, ResultContinuation continuationToken, QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = QueueRequestOptions.applyDefaults(options, this);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        segmentedRequest.setToken(continuationToken);
        return ExecutionEngine.executeWithRetry(this, null, this.listQueuesSegmentedImpl(prefix, detailsIncluded, maxResults, options, segmentedRequest), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudQueueClient, Void, ResultSegment<CloudQueue>> listQueuesSegmentedImpl(String prefix, final QueueListingDetails detailsIncluded, final int maxResults, final QueueRequestOptions options, final SegmentedStorageRequest segmentedRequest) {
        Utility.assertContinuationType(segmentedRequest.getToken(), ResultContinuationType.QUEUE);
        final ListingContext listingContext = new ListingContext(prefix, maxResults);
        StorageRequest<CloudQueueClient, Void, ResultSegment<CloudQueue>> getRequest = new StorageRequest<CloudQueueClient, Void, ResultSegment<CloudQueue>>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(Utility.getListingLocationMode(segmentedRequest.getToken()));
            }

            @Override
            public HttpURLConnection buildRequest(CloudQueueClient client, Void parentObject, OperationContext context) throws Exception {
                listingContext.setMarker(segmentedRequest.getToken() != null ? segmentedRequest.getToken().getNextMarker() : null);
                return QueueRequest.list(client.getStorageUri().getUri(this.getCurrentLocation()), options, context, listingContext, detailsIncluded);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudQueueClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, null);
            }

            @Override
            public ResultSegment<CloudQueue> preProcessResponse(Void parentObject, CloudQueueClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }

            @Override
            public ResultSegment<CloudQueue> postProcessResponse(HttpURLConnection connection, Void queue, CloudQueueClient client, OperationContext context, ResultSegment<CloudQueue> storageObject) throws Exception {
                ListResponse<CloudQueue> response = QueueListHandler.getQueues(connection.getInputStream(), client);
                ResultContinuation newToken = null;
                if (response.getNextMarker() != null) {
                    newToken = new ResultContinuation();
                    newToken.setNextMarker(response.getNextMarker());
                    newToken.setContinuationType(ResultContinuationType.QUEUE);
                    newToken.setTargetLocation(this.getResult().getTargetLocation());
                }
                ResultSegment<CloudQueue> resSegment = new ResultSegment<CloudQueue>(response.getResults(), maxResults, newToken);
                segmentedRequest.setToken(resSegment.getContinuationToken());
                return resSegment;
            }
        };
        return getRequest;
    }

    @DoesServiceRequest
    public ServiceStats getServiceStats() throws StorageException {
        return this.getServiceStats(null, null);
    }

    @DoesServiceRequest
    public ServiceStats getServiceStats(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = QueueRequestOptions.applyDefaults(options, this);
        return ExecutionEngine.executeWithRetry(this, null, this.getServiceStatsImpl(options, false), options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final ServiceProperties downloadServiceProperties() throws StorageException {
        return this.downloadServiceProperties(null, null);
    }

    @DoesServiceRequest
    public final ServiceProperties downloadServiceProperties(QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = QueueRequestOptions.applyDefaults(options, this);
        return ExecutionEngine.executeWithRetry(this, null, this.downloadServicePropertiesImpl(options, false), options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public void uploadServiceProperties(ServiceProperties properties) throws StorageException {
        this.uploadServiceProperties(properties, null, null);
    }

    @DoesServiceRequest
    public void uploadServiceProperties(ServiceProperties properties, QueueRequestOptions options, OperationContext opContext) throws StorageException {
        if (!Utility.isNullOrEmpty(properties.getDefaultServiceVersion())) {
            throw new IllegalArgumentException("DefaultServiceVersion can only be set for the Blob service.");
        }
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = QueueRequestOptions.applyDefaults(options, this);
        Utility.assertNotNull("properties", properties);
        ExecutionEngine.executeWithRetry(this, null, this.uploadServicePropertiesImpl(properties, options, opContext, false), options.getRetryPolicyFactory(), opContext);
    }

    @Override
    protected boolean isUsePathStyleUris() {
        return super.isUsePathStyleUris();
    }

    @Override
    public QueueRequestOptions getDefaultRequestOptions() {
        return this.defaultRequestOptions;
    }

    public void setDefaultRequestOptions(QueueRequestOptions defaultRequestOptions) {
        Utility.assertNotNull("defaultRequestOptions", defaultRequestOptions);
        this.defaultRequestOptions = defaultRequestOptions;
    }
}

