/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertyLoader {
    private static final String PROJECT_PROPERTY_FILE = "/META-INF/project.properties";
    private static final String TELEMETRY_CONFIG_FILE = "/telemetry.config";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getProperty(String file, String property) {
        try (InputStream inputStream = PropertyLoader.class.getResourceAsStream(file);){
            if (inputStream == null) return "unknown";
            Properties properties = new Properties();
            properties.load(inputStream);
            String string = properties.getProperty(property);
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "unknown";
    }

    public static String getProjectVersion() {
        return PropertyLoader.getProperty(PROJECT_PROPERTY_FILE, "project.version");
    }

    public static String getTelemetryInstrumentationKey() {
        return PropertyLoader.getProperty(TELEMETRY_CONFIG_FILE, "telemetry.instrumentationKey");
    }
}

