/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.aad;

import com.microsoft.azure.spring.autoconfigure.aad.AADAppRoleStatelessAuthenticationFilter;
import com.microsoft.azure.spring.autoconfigure.aad.AADAuthenticationFilter;
import com.microsoft.azure.spring.autoconfigure.aad.AADAuthenticationProperties;
import com.microsoft.azure.spring.autoconfigure.aad.ServiceEndpointsProperties;
import com.microsoft.azure.spring.autoconfigure.aad.UserPrincipalManager;
import com.microsoft.azure.telemetry.TelemetryData;
import com.microsoft.azure.telemetry.TelemetrySender;
import com.nimbusds.jose.jwk.source.DefaultJWKSetCache;
import com.nimbusds.jose.jwk.source.JWKSetCache;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.ResourceRetriever;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.util.ClassUtils;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnResource(resources={"classpath:aad.enable.config"})
@ConditionalOnProperty(prefix="azure.activedirectory", value={"client-id"})
@EnableConfigurationProperties(value={AADAuthenticationProperties.class, ServiceEndpointsProperties.class})
@PropertySource(value={"classpath:service-endpoints.properties"})
public class AADAuthenticationFilterAutoConfiguration {
    public static final String PROPERTY_PREFIX = "azure.activedirectory";
    private static final Logger LOG = LoggerFactory.getLogger(AADAuthenticationProperties.class);
    private final AADAuthenticationProperties aadAuthProps;
    private final ServiceEndpointsProperties serviceEndpointsProps;

    public AADAuthenticationFilterAutoConfiguration(AADAuthenticationProperties aadAuthFilterProps, ServiceEndpointsProperties serviceEndpointsProps) {
        this.aadAuthProps = aadAuthFilterProps;
        this.serviceEndpointsProps = serviceEndpointsProps;
    }

    @Bean
    @ConditionalOnMissingBean(value={AADAuthenticationFilter.class})
    @ConditionalOnProperty(prefix="azure.activedirectory", value={"client-id", "client-secret"})
    @ConditionalOnExpression(value="${azure.activedirectory.session-stateless:false} == false")
    public AADAuthenticationFilter azureADJwtTokenFilter() {
        LOG.info("AzureADJwtTokenFilter Constructor.");
        return new AADAuthenticationFilter(this.aadAuthProps, this.serviceEndpointsProps, this.getJWTResourceRetriever(), this.getJWKSetCache());
    }

    @Bean
    @ConditionalOnMissingBean(value={AADAppRoleStatelessAuthenticationFilter.class})
    @ConditionalOnExpression(value="${azure.activedirectory.session-stateless:false} == true")
    public AADAppRoleStatelessAuthenticationFilter azureADStatelessAuthFilter(ResourceRetriever resourceRetriever) {
        LOG.info("Creating AzureADStatelessAuthFilter bean.");
        boolean useExplicitAudienceCheck = true;
        return new AADAppRoleStatelessAuthenticationFilter(new UserPrincipalManager(this.serviceEndpointsProps, this.aadAuthProps, resourceRetriever, true));
    }

    @Bean
    @ConditionalOnMissingBean(value={ResourceRetriever.class})
    public ResourceRetriever getJWTResourceRetriever() {
        return new DefaultResourceRetriever(this.aadAuthProps.getJwtConnectTimeout(), this.aadAuthProps.getJwtReadTimeout(), this.aadAuthProps.getJwtSizeLimit());
    }

    @Bean
    @ConditionalOnMissingBean(value={JWKSetCache.class})
    public JWKSetCache getJWKSetCache() {
        return new DefaultJWKSetCache(this.aadAuthProps.getJwkSetCacheLifespan(), TimeUnit.MILLISECONDS);
    }

    @PostConstruct
    private void sendTelemetry() {
        if (this.aadAuthProps.isAllowTelemetry()) {
            HashMap<String, String> events = new HashMap<String, String>();
            TelemetrySender sender = new TelemetrySender();
            events.put("serviceName", TelemetryData.getClassPackageSimpleName(AADAuthenticationFilterAutoConfiguration.class));
            sender.send(ClassUtils.getUserClass(this.getClass()).getSimpleName(), events);
        }
    }
}

