/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.spring;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.identity.ClientCertificateCredentialBuilder;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.microsoft.azure.keyvault.spring.KeyVaultOperation;
import com.microsoft.azure.keyvault.spring.KeyVaultProperties;
import com.microsoft.azure.keyvault.spring.KeyVaultPropertySource;
import com.microsoft.azure.telemetry.TelemetryData;
import com.microsoft.azure.telemetry.TelemetrySender;
import com.microsoft.azure.utils.ApplicationId;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class KeyVaultEnvironmentPostProcessorHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyVaultEnvironmentPostProcessorHelper.class);
    private final ConfigurableEnvironment environment;

    KeyVaultEnvironmentPostProcessorHelper(ConfigurableEnvironment environment) {
        this.environment = environment;
        Assert.notNull((Object)environment, (String)"environment must not be null!");
        this.sendTelemetry();
    }

    public void addKeyVaultPropertySource(String normalizedName) {
        String vaultUri = this.getPropertyValue(normalizedName, KeyVaultProperties.Property.URI);
        Assert.notNull((Object)vaultUri, (String)"vaultUri must not be null!");
        Long refreshInterval = Optional.ofNullable(this.getPropertyValue(normalizedName, KeyVaultProperties.Property.REFRESH_INTERVAL)).map(Long::valueOf).orElse(1800000L);
        List secretKeys = (List)Binder.get((Environment)this.environment).bind(KeyVaultProperties.getPropertyName(normalizedName, KeyVaultProperties.Property.SECRET_KEYS), Bindable.listOf(String.class)).orElse(Collections.emptyList());
        TokenCredential tokenCredential = this.getCredentials(normalizedName);
        SecretClient secretClient = new SecretClientBuilder().vaultUrl(vaultUri).credential(tokenCredential).httpLogOptions(new HttpLogOptions().setApplicationId(ApplicationId.AZURE_SPRING_KEY_VAULT)).buildClient();
        try {
            MutablePropertySources sources = this.environment.getPropertySources();
            boolean caseSensitive = Boolean.parseBoolean(this.getPropertyValue(normalizedName, KeyVaultProperties.Property.CASE_SENSITIVE_KEYS));
            KeyVaultOperation keyVaultOperation = new KeyVaultOperation(secretClient, refreshInterval, secretKeys, caseSensitive);
            String propertySourceName = Optional.of(normalizedName).map(String::trim).filter(s -> !s.isEmpty()).orElse("azurekv");
            KeyVaultPropertySource keyVaultPropertySource = new KeyVaultPropertySource(propertySourceName, keyVaultOperation);
            if (sources.contains("systemEnvironment")) {
                sources.addAfter("systemEnvironment", (PropertySource)keyVaultPropertySource);
            } else {
                sources.addFirst((PropertySource)keyVaultPropertySource);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to configure KeyVault property source", ex);
        }
    }

    public TokenCredential getCredentials() {
        return this.getCredentials("");
    }

    public TokenCredential getCredentials(String normalizedName) {
        String clientId = this.getPropertyValue(normalizedName, KeyVaultProperties.Property.CLIENT_ID);
        String clientKey = this.getPropertyValue(normalizedName, KeyVaultProperties.Property.CLIENT_KEY);
        String tenantId = this.getPropertyValue(normalizedName, KeyVaultProperties.Property.TENANT_ID);
        String certificatePath = this.getPropertyValue(normalizedName, KeyVaultProperties.Property.CERTIFICATE_PATH);
        String certificatePassword = this.getPropertyValue(normalizedName, KeyVaultProperties.Property.CERTIFICATE_PASSWORD);
        if (clientId != null && tenantId != null && clientKey != null) {
            LOGGER.debug("Will use custom credentials");
            return ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(clientId)).clientSecret(clientKey).tenantId(tenantId)).build();
        }
        if (clientId != null && tenantId != null && certificatePath != null) {
            if (StringUtils.isEmpty((Object)certificatePassword)) {
                return ((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)new ClientCertificateCredentialBuilder().tenantId(tenantId)).clientId(clientId)).pemCertificate(certificatePath).build();
            }
            return ((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)new ClientCertificateCredentialBuilder().tenantId(tenantId)).clientId(clientId)).pfxCertificate(certificatePath, certificatePassword).build();
        }
        if (clientId != null) {
            LOGGER.debug("Will use MSI credentials with specified clientId");
            return new ManagedIdentityCredentialBuilder().clientId(clientId).build();
        }
        LOGGER.debug("Will use MSI credentials");
        return new ManagedIdentityCredentialBuilder().build();
    }

    private String getPropertyValue(KeyVaultProperties.Property property) {
        return Optional.of(property).map(KeyVaultProperties::getPropertyName).map(arg_0 -> ((ConfigurableEnvironment)this.environment).getProperty(arg_0)).orElse(null);
    }

    private String getPropertyValue(String normalizedName, KeyVaultProperties.Property property) {
        return Optional.of(KeyVaultProperties.getPropertyName(normalizedName, property)).map(arg_0 -> ((ConfigurableEnvironment)this.environment).getProperty(arg_0)).orElse(null);
    }

    private boolean allowTelemetry() {
        return Boolean.parseBoolean(this.getPropertyValue(KeyVaultProperties.Property.ALLOW_TELEMETRY));
    }

    private void sendTelemetry() {
        if (this.allowTelemetry()) {
            HashMap<String, String> events = new HashMap<String, String>();
            TelemetrySender sender = new TelemetrySender();
            events.put("serviceName", TelemetryData.getClassPackageSimpleName(KeyVaultEnvironmentPostProcessorHelper.class));
            sender.send(ClassUtils.getUserClass(this.getClass()).getSimpleName(), events);
        }
    }
}

