/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.aad;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.util.StringUtils;

public class AADOAuth2AuthorizationRequestResolver
implements OAuth2AuthorizationRequestResolver {
    private OAuth2AuthorizationRequestResolver defaultResolver;

    public AADOAuth2AuthorizationRequestResolver(ClientRegistrationRepository clientRegistrationRepository) {
        this.defaultResolver = new DefaultOAuth2AuthorizationRequestResolver(clientRegistrationRepository, "/oauth2/authorization");
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request) {
        return this.addClaims(request, this.defaultResolver.resolve(request));
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request, String clientRegistrationId) {
        return this.addClaims(request, this.defaultResolver.resolve(request, clientRegistrationId));
    }

    private OAuth2AuthorizationRequest addClaims(HttpServletRequest request, OAuth2AuthorizationRequest req) {
        if (req == null || request == null) {
            return req;
        }
        String conditionalAccessPolicyClaims = this.getConditionalAccessPolicyClaims(request);
        if (StringUtils.isEmpty((Object)conditionalAccessPolicyClaims)) {
            return req;
        }
        HashMap<String, String> extraParams = new HashMap<String, String>();
        if (req.getAdditionalParameters() != null) {
            extraParams.putAll(req.getAdditionalParameters());
        }
        extraParams.put("claims", conditionalAccessPolicyClaims);
        return OAuth2AuthorizationRequest.from((OAuth2AuthorizationRequest)req).additionalParameters(extraParams).build();
    }

    private String getConditionalAccessPolicyClaims(HttpServletRequest request) {
        String claims;
        String string = claims = request.getSession().getAttribute("CAP_Claims") == null ? "" : (String)request.getSession().getAttribute("CAP_Claims");
        if (!StringUtils.isEmpty((Object)claims)) {
            request.getSession().removeAttribute("CAP_Claims");
        }
        return claims;
    }
}

