/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.spring;

import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class KeyVaultOperation {
    private static final Logger log = LoggerFactory.getLogger(KeyVaultOperation.class);
    private final SecretClient keyVaultClient;
    private final String vaultUri;
    private volatile List<String> secretNames;
    private final boolean secretNamesAlreadyConfigured;
    private final long secretNamesRefreshIntervalInMs;
    private volatile long secretNamesLastUpdateTime;

    public KeyVaultOperation(SecretClient keyVaultClient, String vaultUri, long secretKeysRefreshIntervalInMs, List<String> secretNames) {
        this.keyVaultClient = keyVaultClient;
        this.vaultUri = StringUtils.trimTrailingCharacter((String)vaultUri.trim(), (char)'/');
        this.secretNames = Optional.ofNullable(secretNames).map(Collection::stream).orElseGet(Stream::empty).map(this::toKeyVaultSecretName).distinct().collect(Collectors.toList());
        this.secretNamesAlreadyConfigured = !this.secretNames.isEmpty();
        this.secretNamesRefreshIntervalInMs = secretKeysRefreshIntervalInMs;
        this.secretNamesLastUpdateTime = 0L;
    }

    public String[] getPropertyNames() {
        this.refreshSecretKeysIfNeeded();
        return (String[])Optional.ofNullable(this.secretNames).map(Collection::stream).orElseGet(Stream::empty).flatMap(p -> Stream.of(p, p.replaceAll("-", "."))).distinct().toArray(String[]::new);
    }

    private String toKeyVaultSecretName(@NonNull String property) {
        if (property.matches("[a-z0-9A-Z-]+")) {
            return property.toLowerCase(Locale.US);
        }
        if (property.matches("[A-Z0-9_]+")) {
            return property.toLowerCase(Locale.US).replaceAll("_", "-");
        }
        return property.toLowerCase(Locale.US).replaceAll("-", "").replaceAll("_", "").replaceAll("\\.", "-");
    }

    public String get(String property) {
        Assert.hasText((String)property, (String)"property should contain text.");
        this.refreshSecretKeysIfNeeded();
        return Optional.of(property).map(this::toKeyVaultSecretName).filter(this.secretNames::contains).map(this::getValueFromKeyVault).orElse(null);
    }

    private synchronized void refreshSecretKeysIfNeeded() {
        if (this.needRefreshSecretKeys()) {
            this.refreshKeyVaultSecretNames();
        }
    }

    private boolean needRefreshSecretKeys() {
        return !this.secretNamesAlreadyConfigured && System.currentTimeMillis() - this.secretNamesLastUpdateTime > this.secretNamesRefreshIntervalInMs;
    }

    private void refreshKeyVaultSecretNames() {
        this.secretNames = Optional.of(this.keyVaultClient).map(SecretClient::listPropertiesOfSecrets).map(secretProperties -> {
            ArrayList secretNameList = new ArrayList();
            secretProperties.forEach(s -> {
                String secretName = s.getName().replace(this.vaultUri + "/secrets/", "");
                secretNameList.add(secretName);
            });
            return secretNameList;
        }).map(Collection::stream).orElseGet(Stream::empty).map(this::toKeyVaultSecretName).distinct().collect(Collectors.toList());
        this.secretNamesLastUpdateTime = System.currentTimeMillis();
    }

    private String getValueFromKeyVault(String name) {
        return Optional.ofNullable(name).map(arg_0 -> ((SecretClient)this.keyVaultClient).getSecret(arg_0)).map(KeyVaultSecret::getValue).orElse(null);
    }
}

