/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.spring;

import com.microsoft.azure.keyvault.spring.KeyVaultEnvironmentPostProcessorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.ClassUtils;

public class KeyVaultEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(KeyVaultEnvironmentPostProcessor.class);
    public static final int DEFAULT_ORDER = -2147483637;
    private int order = -2147483637;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        KeyVaultEnvironmentPostProcessorHelper helper = new KeyVaultEnvironmentPostProcessorHelper(environment);
        if (this.isKeyVaultEnabled(environment, "")) {
            helper.addKeyVaultPropertySource("");
        }
        if (this.hasMultipleKeyVaultsEnabled(environment)) {
            String property = environment.getProperty("azure.keyvault.order", "");
            String[] keyVaultNames = property.split(",");
            for (int i = keyVaultNames.length - 1; i >= 0; --i) {
                if (!this.isKeyVaultEnabled(environment, keyVaultNames[i].trim() + ".")) continue;
                helper.addKeyVaultPropertySource(keyVaultNames[i].trim() + ".");
            }
        }
    }

    private boolean isKeyVaultEnabled(ConfigurableEnvironment environment, String normalizedName) {
        if (environment.getProperty("azure.keyvault." + normalizedName + "uri") == null) {
            return false;
        }
        return (Boolean)environment.getProperty("azure.keyvault." + normalizedName + "enabled", Boolean.class, (Object)true) != false && this.isKeyVaultClientAvailable();
    }

    private boolean hasMultipleKeyVaultsEnabled(ConfigurableEnvironment environment) {
        boolean result = false;
        if (environment.getProperty("azure.keyvault.order") != null) {
            result = true;
        }
        return result;
    }

    private boolean isKeyVaultClientAvailable() {
        return ClassUtils.isPresent((String)"com.azure.security.keyvault.secrets.SecretClient", (ClassLoader)KeyVaultEnvironmentPostProcessor.class.getClassLoader());
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

