/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.telemetry;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.spring.support.GetHashMac;
import com.microsoft.azure.telemetry.TelemetryEventData;
import com.microsoft.azure.utils.PropertyLoader;
import java.util.Map;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class TelemetrySender {
    private static final Logger log = LoggerFactory.getLogger(TelemetrySender.class);
    private static final String TELEMETRY_TARGET_URL = "https://dc.services.visualstudio.com/v2/track";
    private static final String PROJECT_INFO = "spring-boot-starter/" + PropertyLoader.getProjectVersion();
    private static final int RETRY_LIMIT = 3;
    private static final RestTemplate REST_TEMPLATE = new RestTemplate();
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final HttpHeaders HEADERS = new HttpHeaders();

    private ResponseEntity<String> executeRequest(TelemetryEventData eventData) {
        try {
            HttpEntity body = new HttpEntity((Object)MAPPER.writeValueAsString((Object)eventData), (MultiValueMap)HEADERS);
            return REST_TEMPLATE.exchange(TELEMETRY_TARGET_URL, HttpMethod.POST, body, String.class, new Object[0]);
        }
        catch (Exception ignore) {
            log.warn("Failed to exchange telemetry request, {}.", (Object)ignore.getMessage());
            return null;
        }
    }

    private void sendTelemetryData(@NonNull TelemetryEventData eventData) {
        if (eventData == null) {
            throw new NullPointerException("eventData is marked non-null but is null");
        }
        ResponseEntity<String> response = null;
        for (int i = 0; i < 3; ++i) {
            response = this.executeRequest(eventData);
            if (response == null || response.getStatusCode() != HttpStatus.OK) continue;
            return;
        }
        if (response != null && response.getStatusCode() != HttpStatus.OK) {
            log.warn("Failed to send telemetry data, response status code {}.", (Object)response.getStatusCode().toString());
        }
    }

    public void send(String name, @NonNull Map<String, String> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        Assert.hasText((String)name, (String)"Event name should contain text.");
        properties.putIfAbsent("installationId", GetHashMac.getHashMac());
        properties.putIfAbsent("version", PROJECT_INFO);
        this.sendTelemetryData(new TelemetryEventData(name, properties));
    }

    static {
        HEADERS.add("Content-Type", MimeTypeUtils.APPLICATION_JSON.toString());
    }
}

