/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.metrics;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.azure.spring.autoconfigure.metrics.AzureMonitorProperties;
import com.microsoft.azure.spring.autoconfigure.metrics.AzureMonitorPropertiesConfigAdapter;
import io.micrometer.azuremonitor.AzureMonitorConfig;
import io.micrometer.azuremonitor.AzureMonitorMeterRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.util.StringUtils;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={AzureMonitorMeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.azuremonitor", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={AzureMonitorProperties.class})
public class AzureMonitorMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public AzureMonitorConfig azureConfig(AzureMonitorProperties properties) {
        return new AzureMonitorPropertiesConfigAdapter(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public TelemetryConfiguration telemetryConfiguration(AzureMonitorConfig config) {
        TelemetryConfiguration telemetryConfiguration = TelemetryConfiguration.getActive();
        if (StringUtils.isEmpty((String)telemetryConfiguration.getInstrumentationKey())) {
            telemetryConfiguration.setInstrumentationKey(config.instrumentationKey());
        }
        return telemetryConfiguration;
    }

    @Bean
    @ConditionalOnMissingBean
    public AzureMonitorMeterRegistry azureMeterRegistry(AzureMonitorConfig config, TelemetryConfiguration configuration, Clock clock) {
        return AzureMonitorMeterRegistry.builder((AzureMonitorConfig)config).clock(clock).telemetryConfiguration(configuration).build();
    }
}

