/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.spring;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.azure.keyvault.models.SecretBundle;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class KeyVaultOperation {
    private static final Logger log = LoggerFactory.getLogger(KeyVaultOperation.class);
    private final long cacheRefreshIntervalInMs;
    private final String[] secretKeys;
    private final Object refreshLock = new Object();
    private final KeyVaultClient keyVaultClient;
    private final String vaultUri;
    private ArrayList<String> propertyNames = new ArrayList();
    private String[] propertyNamesArr;
    private final AtomicLong lastUpdateTime = new AtomicLong();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();

    public KeyVaultOperation(KeyVaultClient keyVaultClient, String vaultUri, long refreshInterval, String secretKeysConfig) {
        this.cacheRefreshIntervalInMs = refreshInterval;
        this.secretKeys = this.parseSecretKeys(secretKeysConfig);
        this.keyVaultClient = keyVaultClient;
        this.vaultUri = StringUtils.trimTrailingCharacter((String)vaultUri.trim(), (char)'/');
        this.fillSecretsList();
    }

    private String[] parseSecretKeys(String secretKeysConfig) {
        if (StringUtils.isEmpty((Object)secretKeysConfig)) {
            log.info("specific secret keys haven't set, so apply global list mode");
            return new String[0];
        }
        String[] split = secretKeysConfig.split(",");
        if (split.length == 0) {
            log.info("specific secret keys haven't set, so apply global list mode");
            return new String[0];
        }
        return split;
    }

    public String[] list() {
        try {
            this.rwLock.readLock().lock();
            String[] stringArray = this.propertyNamesArr;
            return stringArray;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private String getKeyvaultSecretName(@NonNull String property) {
        if (property.matches("[a-z0-9A-Z-]+")) {
            return property.toLowerCase(Locale.US);
        }
        if (property.matches("[A-Z0-9_]+")) {
            return property.toLowerCase(Locale.US).replaceAll("_", "-");
        }
        return property.toLowerCase(Locale.US).replaceAll("-", "").replaceAll("_", "").replaceAll("\\.", "-");
    }

    public String get(String property) {
        Assert.hasText((String)property, (String)"property should contain text.");
        String secretName = this.getKeyvaultSecretName(property);
        if (this.secretKeys == null || this.secretKeys.length == 0) {
            this.refreshPropertyNames();
        }
        if (this.propertyNames.contains(secretName)) {
            SecretBundle secretBundle = this.keyVaultClient.getSecret(this.vaultUri, secretName);
            return secretBundle == null ? null : secretBundle.value();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshPropertyNames() {
        if (System.currentTimeMillis() - this.lastUpdateTime.get() > this.cacheRefreshIntervalInMs) {
            Object object = this.refreshLock;
            synchronized (object) {
                if (System.currentTimeMillis() - this.lastUpdateTime.get() > this.cacheRefreshIntervalInMs) {
                    this.lastUpdateTime.set(System.currentTimeMillis());
                    this.fillSecretsList();
                }
            }
        }
    }

    private void fillSecretsList() {
        try {
            this.rwLock.writeLock().lock();
            if (this.secretKeys == null || this.secretKeys.length == 0) {
                this.propertyNames.clear();
                PagedList secrets = this.keyVaultClient.listSecrets(this.vaultUri);
                secrets.loadAll();
                secrets.forEach(s -> {
                    String secretName = s.id().replace(this.vaultUri + "/secrets/", "").toLowerCase(Locale.US);
                    if (!this.propertyNames.contains(secretName)) {
                        this.propertyNames.add(secretName);
                    }
                    if (!this.propertyNames.contains(secretName.replaceAll("-", "."))) {
                        this.propertyNames.add(secretName.replaceAll("-", "."));
                    }
                });
                this.lastUpdateTime.set(System.currentTimeMillis());
            } else {
                for (int i = 0; i < this.secretKeys.length; ++i) {
                    if (this.propertyNames.contains(this.secretKeys[i])) continue;
                    this.propertyNames.add(this.secretKeys[i]);
                }
            }
            this.propertyNamesArr = this.propertyNames.toArray(new String[this.propertyNames.size()]);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }
}

