/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.springcloud.config;

import com.microsoft.azure.maven.springcloud.config.AppDeploymentRawConfig;
import com.microsoft.azure.maven.springcloud.config.ClusterRawConfig;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudApp;
import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudCluster;
import java.util.Optional;
import javax.annotation.Nonnull;

public class AppRawConfig {
    private String appName;
    private String isPublic;
    private ClusterRawConfig cluster = new ClusterRawConfig();
    private AppDeploymentRawConfig deployment;

    public void saveSpringCloudApp(@Nonnull SpringCloudApp app) {
        this.cluster = Optional.ofNullable(this.cluster).orElseGet(ClusterRawConfig::new);
        this.cluster.saveSpringCluster((SpringCloudCluster)app.getParent());
        this.setAppName(app.getName());
        this.setIsPublic(String.valueOf(app.isPublicEndpointEnabled()));
        AppDeploymentRawConfig deploymentSettings = new AppDeploymentRawConfig();
        deploymentSettings.saveSpringCloudDeployment(app.getActiveDeployment());
        this.setDeployment(deploymentSettings);
    }

    public String getAppName() {
        return this.appName;
    }

    public String getIsPublic() {
        return this.isPublic;
    }

    public ClusterRawConfig getCluster() {
        return this.cluster;
    }

    public AppDeploymentRawConfig getDeployment() {
        return this.deployment;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setIsPublic(String isPublic) {
        this.isPublic = isPublic;
    }

    public void setCluster(ClusterRawConfig cluster) {
        this.cluster = cluster;
    }

    public void setDeployment(AppDeploymentRawConfig deployment) {
        this.deployment = deployment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppRawConfig)) {
            return false;
        }
        AppRawConfig other = (AppRawConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$appName = this.getAppName();
        String other$appName = other.getAppName();
        if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
            return false;
        }
        String this$isPublic = this.getIsPublic();
        String other$isPublic = other.getIsPublic();
        if (this$isPublic == null ? other$isPublic != null : !this$isPublic.equals(other$isPublic)) {
            return false;
        }
        ClusterRawConfig this$cluster = this.getCluster();
        ClusterRawConfig other$cluster = other.getCluster();
        if (this$cluster == null ? other$cluster != null : !((Object)this$cluster).equals(other$cluster)) {
            return false;
        }
        AppDeploymentRawConfig this$deployment = this.getDeployment();
        AppDeploymentRawConfig other$deployment = other.getDeployment();
        return !(this$deployment == null ? other$deployment != null : !((Object)this$deployment).equals(other$deployment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppRawConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appName = this.getAppName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        String $isPublic = this.getIsPublic();
        result = result * 59 + ($isPublic == null ? 43 : $isPublic.hashCode());
        ClusterRawConfig $cluster = this.getCluster();
        result = result * 59 + ($cluster == null ? 43 : ((Object)$cluster).hashCode());
        AppDeploymentRawConfig $deployment = this.getDeployment();
        result = result * 59 + ($deployment == null ? 43 : ((Object)$deployment).hashCode());
        return result;
    }

    public String toString() {
        return "AppRawConfig(appName=" + this.getAppName() + ", isPublic=" + this.getIsPublic() + ", cluster=" + this.getCluster() + ", deployment=" + this.getDeployment() + ")";
    }
}

