/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.springcloud.config;

import com.microsoft.azure.toolkit.lib.springcloud.SpringCloudDeployment;
import javax.annotation.Nonnull;

public class AppDeploymentRawConfig {
    private String cpu;
    private String memoryInGB;
    private String instanceCount;
    private String deploymentName;
    private String jvmOptions;
    private String runtimeVersion;

    public void saveSpringCloudDeployment(@Nonnull SpringCloudDeployment activeDeployment) {
        this.setCpu(String.valueOf(activeDeployment.getCpu()));
        this.setMemoryInGB(String.valueOf(activeDeployment.getMemoryInGB()));
        this.setInstanceCount(String.valueOf(activeDeployment.getInstances().size()));
        this.setDeploymentName(activeDeployment.getName());
        this.setJvmOptions(activeDeployment.getJvmOptions());
        this.setRuntimeVersion(activeDeployment.getRuntimeVersion());
    }

    public String getCpu() {
        return this.cpu;
    }

    public String getMemoryInGB() {
        return this.memoryInGB;
    }

    public String getInstanceCount() {
        return this.instanceCount;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public String getJvmOptions() {
        return this.jvmOptions;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public void setCpu(String cpu) {
        this.cpu = cpu;
    }

    public void setMemoryInGB(String memoryInGB) {
        this.memoryInGB = memoryInGB;
    }

    public void setInstanceCount(String instanceCount) {
        this.instanceCount = instanceCount;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public void setJvmOptions(String jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    public void setRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppDeploymentRawConfig)) {
            return false;
        }
        AppDeploymentRawConfig other = (AppDeploymentRawConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$cpu = this.getCpu();
        String other$cpu = other.getCpu();
        if (this$cpu == null ? other$cpu != null : !this$cpu.equals(other$cpu)) {
            return false;
        }
        String this$memoryInGB = this.getMemoryInGB();
        String other$memoryInGB = other.getMemoryInGB();
        if (this$memoryInGB == null ? other$memoryInGB != null : !this$memoryInGB.equals(other$memoryInGB)) {
            return false;
        }
        String this$instanceCount = this.getInstanceCount();
        String other$instanceCount = other.getInstanceCount();
        if (this$instanceCount == null ? other$instanceCount != null : !this$instanceCount.equals(other$instanceCount)) {
            return false;
        }
        String this$deploymentName = this.getDeploymentName();
        String other$deploymentName = other.getDeploymentName();
        if (this$deploymentName == null ? other$deploymentName != null : !this$deploymentName.equals(other$deploymentName)) {
            return false;
        }
        String this$jvmOptions = this.getJvmOptions();
        String other$jvmOptions = other.getJvmOptions();
        if (this$jvmOptions == null ? other$jvmOptions != null : !this$jvmOptions.equals(other$jvmOptions)) {
            return false;
        }
        String this$runtimeVersion = this.getRuntimeVersion();
        String other$runtimeVersion = other.getRuntimeVersion();
        return !(this$runtimeVersion == null ? other$runtimeVersion != null : !this$runtimeVersion.equals(other$runtimeVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppDeploymentRawConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cpu = this.getCpu();
        result = result * 59 + ($cpu == null ? 43 : $cpu.hashCode());
        String $memoryInGB = this.getMemoryInGB();
        result = result * 59 + ($memoryInGB == null ? 43 : $memoryInGB.hashCode());
        String $instanceCount = this.getInstanceCount();
        result = result * 59 + ($instanceCount == null ? 43 : $instanceCount.hashCode());
        String $deploymentName = this.getDeploymentName();
        result = result * 59 + ($deploymentName == null ? 43 : $deploymentName.hashCode());
        String $jvmOptions = this.getJvmOptions();
        result = result * 59 + ($jvmOptions == null ? 43 : $jvmOptions.hashCode());
        String $runtimeVersion = this.getRuntimeVersion();
        result = result * 59 + ($runtimeVersion == null ? 43 : $runtimeVersion.hashCode());
        return result;
    }

    public String toString() {
        return "AppDeploymentRawConfig(cpu=" + this.getCpu() + ", memoryInGB=" + this.getMemoryInGB() + ", instanceCount=" + this.getInstanceCount() + ", deploymentName=" + this.getDeploymentName() + ", jvmOptions=" + this.getJvmOptions() + ", runtimeVersion=" + this.getRuntimeVersion() + ")";
    }
}

