/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.sql.implementation.ElasticPoolDatabaseActivityInner;
import com.microsoft.azure.management.sql.implementation.PageImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ElasticPoolDatabaseActivitiesInner {
    private ElasticPoolDatabaseActivitiesService service;
    private SqlManagementClientImpl client;

    public ElasticPoolDatabaseActivitiesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (ElasticPoolDatabaseActivitiesService)retrofit.create(ElasticPoolDatabaseActivitiesService.class);
        this.client = client;
    }

    public List<ElasticPoolDatabaseActivityInner> listByElasticPool(String resourceGroupName, String serverName, String elasticPoolName) {
        return (List)((ServiceResponse)this.listByElasticPoolWithServiceResponseAsync(resourceGroupName, serverName, elasticPoolName).toBlocking().single()).body();
    }

    public ServiceFuture<List<ElasticPoolDatabaseActivityInner>> listByElasticPoolAsync(String resourceGroupName, String serverName, String elasticPoolName, ServiceCallback<List<ElasticPoolDatabaseActivityInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByElasticPoolWithServiceResponseAsync(resourceGroupName, serverName, elasticPoolName), serviceCallback);
    }

    public Observable<List<ElasticPoolDatabaseActivityInner>> listByElasticPoolAsync(String resourceGroupName, String serverName, String elasticPoolName) {
        return this.listByElasticPoolWithServiceResponseAsync(resourceGroupName, serverName, elasticPoolName).map((Func1)new Func1<ServiceResponse<List<ElasticPoolDatabaseActivityInner>>, List<ElasticPoolDatabaseActivityInner>>(){

            public List<ElasticPoolDatabaseActivityInner> call(ServiceResponse<List<ElasticPoolDatabaseActivityInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<ElasticPoolDatabaseActivityInner>>> listByElasticPoolWithServiceResponseAsync(String resourceGroupName, String serverName, String elasticPoolName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (elasticPoolName == null) {
            throw new IllegalArgumentException("Parameter elasticPoolName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.listByElasticPool(this.client.subscriptionId(), resourceGroupName, serverName, elasticPoolName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ElasticPoolDatabaseActivityInner>>>>(){

            public Observable<ServiceResponse<List<ElasticPoolDatabaseActivityInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ElasticPoolDatabaseActivitiesInner.this.listByElasticPoolDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ElasticPoolDatabaseActivityInner>> listByElasticPoolDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ElasticPoolDatabaseActivityInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ElasticPoolDatabaseActivitiesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ElasticPoolDatabaseActivities listByElasticPool"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}/elasticPoolDatabaseActivity")
        public Observable<Response<ResponseBody>> listByElasticPool(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="elasticPoolName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

