/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.ProxyResource;

/**
 * A TDE certificate that can be uploaded into a server.
 */
@JsonFlatten
public class TdeCertificateInner extends ProxyResource {
    /**
     * The base64 encoded certificate private blob.
     */
    @JsonProperty(value = "properties.privateBlob", required = true)
    private String privateBlob;

    /**
     * The certificate password.
     */
    @JsonProperty(value = "properties.certPassword")
    private String certPassword;

    /**
     * Get the base64 encoded certificate private blob.
     *
     * @return the privateBlob value
     */
    public String privateBlob() {
        return this.privateBlob;
    }

    /**
     * Set the base64 encoded certificate private blob.
     *
     * @param privateBlob the privateBlob value to set
     * @return the TdeCertificateInner object itself.
     */
    public TdeCertificateInner withPrivateBlob(String privateBlob) {
        this.privateBlob = privateBlob;
        return this;
    }

    /**
     * Get the certificate password.
     *
     * @return the certPassword value
     */
    public String certPassword() {
        return this.certPassword;
    }

    /**
     * Set the certificate password.
     *
     * @param certPassword the certPassword value to set
     * @return the TdeCertificateInner object itself.
     */
    public TdeCertificateInner withCertPassword(String certPassword) {
        this.certPassword = certPassword;
        return this;
    }

}
