/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in RestorableDroppedManagedDatabases.
 */
public class RestorableDroppedManagedDatabasesInner {
    /** The Retrofit service to perform REST calls. */
    private RestorableDroppedManagedDatabasesService service;
    /** The service client containing this operation class. */
    private SqlManagementClientImpl client;

    /**
     * Initializes an instance of RestorableDroppedManagedDatabasesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public RestorableDroppedManagedDatabasesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = retrofit.create(RestorableDroppedManagedDatabasesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for RestorableDroppedManagedDatabases to be
     * used by Retrofit to perform actually REST calls.
     */
    interface RestorableDroppedManagedDatabasesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.RestorableDroppedManagedDatabases listByInstance" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/restorableDroppedDatabases")
        Observable<Response<ResponseBody>> listByInstance(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.RestorableDroppedManagedDatabases get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/restorableDroppedDatabases/{restorableDroppedDatabaseId}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("restorableDroppedDatabaseId") String restorableDroppedDatabaseId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.RestorableDroppedManagedDatabases listByInstanceNext" })
        @GET
        Observable<Response<ResponseBody>> listByInstanceNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets a list of restorable dropped managed databases.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RestorableDroppedManagedDatabaseInner&gt; object if successful.
     */
    public PagedList<RestorableDroppedManagedDatabaseInner> listByInstance(final String resourceGroupName, final String managedInstanceName) {
        ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>> response = listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName).toBlocking().single();
        return new PagedList<RestorableDroppedManagedDatabaseInner>(response.body()) {
            @Override
            public Page<RestorableDroppedManagedDatabaseInner> nextPage(String nextPageLink) {
                return listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of restorable dropped managed databases.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RestorableDroppedManagedDatabaseInner>> listByInstanceAsync(final String resourceGroupName, final String managedInstanceName, final ListOperationCallback<RestorableDroppedManagedDatabaseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName),
            new Func1<String, Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>> call(String nextPageLink) {
                    return listByInstanceNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of restorable dropped managed databases.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RestorableDroppedManagedDatabaseInner&gt; object
     */
    public Observable<Page<RestorableDroppedManagedDatabaseInner>> listByInstanceAsync(final String resourceGroupName, final String managedInstanceName) {
        return listByInstanceWithServiceResponseAsync(resourceGroupName, managedInstanceName)
            .map(new Func1<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>, Page<RestorableDroppedManagedDatabaseInner>>() {
                @Override
                public Page<RestorableDroppedManagedDatabaseInner> call(ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of restorable dropped managed databases.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RestorableDroppedManagedDatabaseInner&gt; object
     */
    public Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>> listByInstanceWithServiceResponseAsync(final String resourceGroupName, final String managedInstanceName) {
        return listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName)
            .concatMap(new Func1<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>, Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>> call(ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByInstanceNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of restorable dropped managed databases.
     *
    ServiceResponse<PageImpl1<RestorableDroppedManagedDatabaseInner>> * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    ServiceResponse<PageImpl1<RestorableDroppedManagedDatabaseInner>> * @param managedInstanceName The name of the managed instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RestorableDroppedManagedDatabaseInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>> listByInstanceSinglePageAsync(final String resourceGroupName, final String managedInstanceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        return service.listByInstance(resourceGroupName, managedInstanceName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<RestorableDroppedManagedDatabaseInner>> result = listByInstanceDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<RestorableDroppedManagedDatabaseInner>> listByInstanceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<RestorableDroppedManagedDatabaseInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<RestorableDroppedManagedDatabaseInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a restorable dropped managed database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RestorableDroppedManagedDatabaseInner object if successful.
     */
    public RestorableDroppedManagedDatabaseInner get(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        return getWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId).toBlocking().single().body();
    }

    /**
     * Gets a restorable dropped managed database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RestorableDroppedManagedDatabaseInner> getAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, final ServiceCallback<RestorableDroppedManagedDatabaseInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId), serviceCallback);
    }

    /**
     * Gets a restorable dropped managed database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RestorableDroppedManagedDatabaseInner object
     */
    public Observable<RestorableDroppedManagedDatabaseInner> getAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        return getWithServiceResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId).map(new Func1<ServiceResponse<RestorableDroppedManagedDatabaseInner>, RestorableDroppedManagedDatabaseInner>() {
            @Override
            public RestorableDroppedManagedDatabaseInner call(ServiceResponse<RestorableDroppedManagedDatabaseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a restorable dropped managed database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param restorableDroppedDatabaseId the String value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RestorableDroppedManagedDatabaseInner object
     */
    public Observable<ServiceResponse<RestorableDroppedManagedDatabaseInner>> getWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (restorableDroppedDatabaseId == null) {
            throw new IllegalArgumentException("Parameter restorableDroppedDatabaseId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-03-01-preview";
        return service.get(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RestorableDroppedManagedDatabaseInner>>>() {
                @Override
                public Observable<ServiceResponse<RestorableDroppedManagedDatabaseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RestorableDroppedManagedDatabaseInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RestorableDroppedManagedDatabaseInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RestorableDroppedManagedDatabaseInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RestorableDroppedManagedDatabaseInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a list of restorable dropped managed databases.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RestorableDroppedManagedDatabaseInner&gt; object if successful.
     */
    public PagedList<RestorableDroppedManagedDatabaseInner> listByInstanceNext(final String nextPageLink) {
        ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>> response = listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RestorableDroppedManagedDatabaseInner>(response.body()) {
            @Override
            public Page<RestorableDroppedManagedDatabaseInner> nextPage(String nextPageLink) {
                return listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of restorable dropped managed databases.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RestorableDroppedManagedDatabaseInner>> listByInstanceNextAsync(final String nextPageLink, final ServiceFuture<List<RestorableDroppedManagedDatabaseInner>> serviceFuture, final ListOperationCallback<RestorableDroppedManagedDatabaseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByInstanceNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>> call(String nextPageLink) {
                    return listByInstanceNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of restorable dropped managed databases.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RestorableDroppedManagedDatabaseInner&gt; object
     */
    public Observable<Page<RestorableDroppedManagedDatabaseInner>> listByInstanceNextAsync(final String nextPageLink) {
        return listByInstanceNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>, Page<RestorableDroppedManagedDatabaseInner>>() {
                @Override
                public Page<RestorableDroppedManagedDatabaseInner> call(ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of restorable dropped managed databases.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RestorableDroppedManagedDatabaseInner&gt; object
     */
    public Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>> listByInstanceNextWithServiceResponseAsync(final String nextPageLink) {
        return listByInstanceNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>, Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>> call(ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByInstanceNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of restorable dropped managed databases.
     *
    ServiceResponse<PageImpl1<RestorableDroppedManagedDatabaseInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RestorableDroppedManagedDatabaseInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>> listByInstanceNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByInstanceNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<RestorableDroppedManagedDatabaseInner>> result = listByInstanceNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RestorableDroppedManagedDatabaseInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<RestorableDroppedManagedDatabaseInner>> listByInstanceNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<RestorableDroppedManagedDatabaseInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<RestorableDroppedManagedDatabaseInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
