/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in DatabaseVulnerabilityAssessmentScans.
 */
public class DatabaseVulnerabilityAssessmentScansInner {
    /** The Retrofit service to perform REST calls. */
    private DatabaseVulnerabilityAssessmentScansService service;
    /** The service client containing this operation class. */
    private SqlManagementClientImpl client;

    /**
     * Initializes an instance of DatabaseVulnerabilityAssessmentScansInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public DatabaseVulnerabilityAssessmentScansInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = retrofit.create(DatabaseVulnerabilityAssessmentScansService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for DatabaseVulnerabilityAssessmentScans to be
     * used by Retrofit to perform actually REST calls.
     */
    interface DatabaseVulnerabilityAssessmentScansService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessmentScans listByDatabase" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans")
        Observable<Response<ResponseBody>> listByDatabase(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("databaseName") String databaseName, @Path("vulnerabilityAssessmentName") String vulnerabilityAssessmentName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessmentScans get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("databaseName") String databaseName, @Path("vulnerabilityAssessmentName") String vulnerabilityAssessmentName, @Path("scanId") String scanId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessmentScans initiateScan" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/initiateScan")
        Observable<Response<ResponseBody>> initiateScan(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("databaseName") String databaseName, @Path("vulnerabilityAssessmentName") String vulnerabilityAssessmentName, @Path("scanId") String scanId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessmentScans beginInitiateScan" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/initiateScan")
        Observable<Response<ResponseBody>> beginInitiateScan(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("databaseName") String databaseName, @Path("vulnerabilityAssessmentName") String vulnerabilityAssessmentName, @Path("scanId") String scanId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessmentScans export" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/export")
        Observable<Response<ResponseBody>> export(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("databaseName") String databaseName, @Path("vulnerabilityAssessmentName") String vulnerabilityAssessmentName, @Path("scanId") String scanId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessmentScans listByDatabaseNext" })
        @GET
        Observable<Response<ResponseBody>> listByDatabaseNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists the vulnerability assessment scans of a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VulnerabilityAssessmentScanRecordInner&gt; object if successful.
     */
    public PagedList<VulnerabilityAssessmentScanRecordInner> listByDatabase(final String resourceGroupName, final String serverName, final String databaseName) {
        ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>> response = listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName).toBlocking().single();
        return new PagedList<VulnerabilityAssessmentScanRecordInner>(response.body()) {
            @Override
            public Page<VulnerabilityAssessmentScanRecordInner> nextPage(String nextPageLink) {
                return listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the vulnerability assessment scans of a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VulnerabilityAssessmentScanRecordInner>> listByDatabaseAsync(final String resourceGroupName, final String serverName, final String databaseName, final ListOperationCallback<VulnerabilityAssessmentScanRecordInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName),
            new Func1<String, Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>> call(String nextPageLink) {
                    return listByDatabaseNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the vulnerability assessment scans of a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VulnerabilityAssessmentScanRecordInner&gt; object
     */
    public Observable<Page<VulnerabilityAssessmentScanRecordInner>> listByDatabaseAsync(final String resourceGroupName, final String serverName, final String databaseName) {
        return listByDatabaseWithServiceResponseAsync(resourceGroupName, serverName, databaseName)
            .map(new Func1<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>, Page<VulnerabilityAssessmentScanRecordInner>>() {
                @Override
                public Page<VulnerabilityAssessmentScanRecordInner> call(ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the vulnerability assessment scans of a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VulnerabilityAssessmentScanRecordInner&gt; object
     */
    public Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>> listByDatabaseWithServiceResponseAsync(final String resourceGroupName, final String serverName, final String databaseName) {
        return listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName)
            .concatMap(new Func1<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>, Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>> call(ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByDatabaseNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the vulnerability assessment scans of a database.
     *
    ServiceResponse<PageImpl1<VulnerabilityAssessmentScanRecordInner>> * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    ServiceResponse<PageImpl1<VulnerabilityAssessmentScanRecordInner>> * @param serverName The name of the server.
    ServiceResponse<PageImpl1<VulnerabilityAssessmentScanRecordInner>> * @param databaseName The name of the database.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VulnerabilityAssessmentScanRecordInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>> listByDatabaseSinglePageAsync(final String resourceGroupName, final String serverName, final String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String vulnerabilityAssessmentName = "default";
        final String apiVersion = "2017-10-01-preview";
        return service.listByDatabase(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<VulnerabilityAssessmentScanRecordInner>> result = listByDatabaseDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<VulnerabilityAssessmentScanRecordInner>> listByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<VulnerabilityAssessmentScanRecordInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<VulnerabilityAssessmentScanRecordInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a vulnerability assessment scan record of a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VulnerabilityAssessmentScanRecordInner object if successful.
     */
    public VulnerabilityAssessmentScanRecordInner get(String resourceGroupName, String serverName, String databaseName, String scanId) {
        return getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId).toBlocking().single().body();
    }

    /**
     * Gets a vulnerability assessment scan record of a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VulnerabilityAssessmentScanRecordInner> getAsync(String resourceGroupName, String serverName, String databaseName, String scanId, final ServiceCallback<VulnerabilityAssessmentScanRecordInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId), serviceCallback);
    }

    /**
     * Gets a vulnerability assessment scan record of a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VulnerabilityAssessmentScanRecordInner object
     */
    public Observable<VulnerabilityAssessmentScanRecordInner> getAsync(String resourceGroupName, String serverName, String databaseName, String scanId) {
        return getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId).map(new Func1<ServiceResponse<VulnerabilityAssessmentScanRecordInner>, VulnerabilityAssessmentScanRecordInner>() {
            @Override
            public VulnerabilityAssessmentScanRecordInner call(ServiceResponse<VulnerabilityAssessmentScanRecordInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a vulnerability assessment scan record of a database.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VulnerabilityAssessmentScanRecordInner object
     */
    public Observable<ServiceResponse<VulnerabilityAssessmentScanRecordInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String scanId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (scanId == null) {
            throw new IllegalArgumentException("Parameter scanId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String vulnerabilityAssessmentName = "default";
        final String apiVersion = "2017-10-01-preview";
        return service.get(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VulnerabilityAssessmentScanRecordInner>>>() {
                @Override
                public Observable<ServiceResponse<VulnerabilityAssessmentScanRecordInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VulnerabilityAssessmentScanRecordInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VulnerabilityAssessmentScanRecordInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VulnerabilityAssessmentScanRecordInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VulnerabilityAssessmentScanRecordInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Executes a Vulnerability Assessment database scan.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void initiateScan(String resourceGroupName, String serverName, String databaseName, String scanId) {
        initiateScanWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId).toBlocking().last().body();
    }

    /**
     * Executes a Vulnerability Assessment database scan.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> initiateScanAsync(String resourceGroupName, String serverName, String databaseName, String scanId, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(initiateScanWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId), serviceCallback);
    }

    /**
     * Executes a Vulnerability Assessment database scan.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> initiateScanAsync(String resourceGroupName, String serverName, String databaseName, String scanId) {
        return initiateScanWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Executes a Vulnerability Assessment database scan.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> initiateScanWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String scanId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (scanId == null) {
            throw new IllegalArgumentException("Parameter scanId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String vulnerabilityAssessmentName = "default";
        final String apiVersion = "2017-10-01-preview";
        Observable<Response<ResponseBody>> observable = service.initiateScan(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Executes a Vulnerability Assessment database scan.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginInitiateScan(String resourceGroupName, String serverName, String databaseName, String scanId) {
        beginInitiateScanWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId).toBlocking().single().body();
    }

    /**
     * Executes a Vulnerability Assessment database scan.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginInitiateScanAsync(String resourceGroupName, String serverName, String databaseName, String scanId, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginInitiateScanWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId), serviceCallback);
    }

    /**
     * Executes a Vulnerability Assessment database scan.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginInitiateScanAsync(String resourceGroupName, String serverName, String databaseName, String scanId) {
        return beginInitiateScanWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Executes a Vulnerability Assessment database scan.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginInitiateScanWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String scanId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (scanId == null) {
            throw new IllegalArgumentException("Parameter scanId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String vulnerabilityAssessmentName = "default";
        final String apiVersion = "2017-10-01-preview";
        return service.beginInitiateScan(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginInitiateScanDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginInitiateScanDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Convert an existing scan result to a human readable format. If already exists nothing happens.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the scanned database.
     * @param scanId The vulnerability assessment scan Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DatabaseVulnerabilityAssessmentScansExportInner object if successful.
     */
    public DatabaseVulnerabilityAssessmentScansExportInner export(String resourceGroupName, String serverName, String databaseName, String scanId) {
        return exportWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId).toBlocking().single().body();
    }

    /**
     * Convert an existing scan result to a human readable format. If already exists nothing happens.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the scanned database.
     * @param scanId The vulnerability assessment scan Id.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DatabaseVulnerabilityAssessmentScansExportInner> exportAsync(String resourceGroupName, String serverName, String databaseName, String scanId, final ServiceCallback<DatabaseVulnerabilityAssessmentScansExportInner> serviceCallback) {
        return ServiceFuture.fromResponse(exportWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId), serviceCallback);
    }

    /**
     * Convert an existing scan result to a human readable format. If already exists nothing happens.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the scanned database.
     * @param scanId The vulnerability assessment scan Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseVulnerabilityAssessmentScansExportInner object
     */
    public Observable<DatabaseVulnerabilityAssessmentScansExportInner> exportAsync(String resourceGroupName, String serverName, String databaseName, String scanId) {
        return exportWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId).map(new Func1<ServiceResponse<DatabaseVulnerabilityAssessmentScansExportInner>, DatabaseVulnerabilityAssessmentScansExportInner>() {
            @Override
            public DatabaseVulnerabilityAssessmentScansExportInner call(ServiceResponse<DatabaseVulnerabilityAssessmentScansExportInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Convert an existing scan result to a human readable format. If already exists nothing happens.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the scanned database.
     * @param scanId The vulnerability assessment scan Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DatabaseVulnerabilityAssessmentScansExportInner object
     */
    public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentScansExportInner>> exportWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String scanId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (scanId == null) {
            throw new IllegalArgumentException("Parameter scanId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String vulnerabilityAssessmentName = "default";
        final String apiVersion = "2017-10-01-preview";
        return service.export(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseVulnerabilityAssessmentScansExportInner>>>() {
                @Override
                public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentScansExportInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DatabaseVulnerabilityAssessmentScansExportInner> clientResponse = exportDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DatabaseVulnerabilityAssessmentScansExportInner> exportDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DatabaseVulnerabilityAssessmentScansExportInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DatabaseVulnerabilityAssessmentScansExportInner>() { }.getType())
                .register(201, new TypeToken<DatabaseVulnerabilityAssessmentScansExportInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the vulnerability assessment scans of a database.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VulnerabilityAssessmentScanRecordInner&gt; object if successful.
     */
    public PagedList<VulnerabilityAssessmentScanRecordInner> listByDatabaseNext(final String nextPageLink) {
        ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>> response = listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VulnerabilityAssessmentScanRecordInner>(response.body()) {
            @Override
            public Page<VulnerabilityAssessmentScanRecordInner> nextPage(String nextPageLink) {
                return listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the vulnerability assessment scans of a database.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VulnerabilityAssessmentScanRecordInner>> listByDatabaseNextAsync(final String nextPageLink, final ServiceFuture<List<VulnerabilityAssessmentScanRecordInner>> serviceFuture, final ListOperationCallback<VulnerabilityAssessmentScanRecordInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByDatabaseNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>> call(String nextPageLink) {
                    return listByDatabaseNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the vulnerability assessment scans of a database.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VulnerabilityAssessmentScanRecordInner&gt; object
     */
    public Observable<Page<VulnerabilityAssessmentScanRecordInner>> listByDatabaseNextAsync(final String nextPageLink) {
        return listByDatabaseNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>, Page<VulnerabilityAssessmentScanRecordInner>>() {
                @Override
                public Page<VulnerabilityAssessmentScanRecordInner> call(ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the vulnerability assessment scans of a database.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VulnerabilityAssessmentScanRecordInner&gt; object
     */
    public Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>> listByDatabaseNextWithServiceResponseAsync(final String nextPageLink) {
        return listByDatabaseNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>, Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>> call(ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByDatabaseNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the vulnerability assessment scans of a database.
     *
    ServiceResponse<PageImpl1<VulnerabilityAssessmentScanRecordInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VulnerabilityAssessmentScanRecordInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>> listByDatabaseNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByDatabaseNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<VulnerabilityAssessmentScanRecordInner>> result = listByDatabaseNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<VulnerabilityAssessmentScanRecordInner>> listByDatabaseNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<VulnerabilityAssessmentScanRecordInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<VulnerabilityAssessmentScanRecordInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
