/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in ServerVulnerabilityAssessments.
 */
public class ServerVulnerabilityAssessmentsInner implements InnerSupportsDelete<Void> {
    /** The Retrofit service to perform REST calls. */
    private ServerVulnerabilityAssessmentsService service;
    /** The service client containing this operation class. */
    private SqlManagementClientImpl client;

    /**
     * Initializes an instance of ServerVulnerabilityAssessmentsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ServerVulnerabilityAssessmentsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = retrofit.create(ServerVulnerabilityAssessmentsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for ServerVulnerabilityAssessments to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ServerVulnerabilityAssessmentsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerVulnerabilityAssessments get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("vulnerabilityAssessmentName") String vulnerabilityAssessmentName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerVulnerabilityAssessments createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("vulnerabilityAssessmentName") String vulnerabilityAssessmentName, @Path("subscriptionId") String subscriptionId, @Body ServerVulnerabilityAssessmentInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerVulnerabilityAssessments delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("vulnerabilityAssessmentName") String vulnerabilityAssessmentName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerVulnerabilityAssessments listByServer" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/vulnerabilityAssessments")
        Observable<Response<ResponseBody>> listByServer(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerVulnerabilityAssessments listByServerNext" })
        @GET
        Observable<Response<ResponseBody>> listByServerNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets the server's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server for which the vulnerability assessment is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ServerVulnerabilityAssessmentInner object if successful.
     */
    public ServerVulnerabilityAssessmentInner get(String resourceGroupName, String serverName) {
        return getWithServiceResponseAsync(resourceGroupName, serverName).toBlocking().single().body();
    }

    /**
     * Gets the server's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server for which the vulnerability assessment is defined.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ServerVulnerabilityAssessmentInner> getAsync(String resourceGroupName, String serverName, final ServiceCallback<ServerVulnerabilityAssessmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, serverName), serviceCallback);
    }

    /**
     * Gets the server's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server for which the vulnerability assessment is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServerVulnerabilityAssessmentInner object
     */
    public Observable<ServerVulnerabilityAssessmentInner> getAsync(String resourceGroupName, String serverName) {
        return getWithServiceResponseAsync(resourceGroupName, serverName).map(new Func1<ServiceResponse<ServerVulnerabilityAssessmentInner>, ServerVulnerabilityAssessmentInner>() {
            @Override
            public ServerVulnerabilityAssessmentInner call(ServiceResponse<ServerVulnerabilityAssessmentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the server's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server for which the vulnerability assessment is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServerVulnerabilityAssessmentInner object
     */
    public Observable<ServiceResponse<ServerVulnerabilityAssessmentInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String vulnerabilityAssessmentName = "default";
        final String apiVersion = "2018-06-01-preview";
        return service.get(resourceGroupName, serverName, vulnerabilityAssessmentName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServerVulnerabilityAssessmentInner>>>() {
                @Override
                public Observable<ServiceResponse<ServerVulnerabilityAssessmentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ServerVulnerabilityAssessmentInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ServerVulnerabilityAssessmentInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ServerVulnerabilityAssessmentInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ServerVulnerabilityAssessmentInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates the server's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server for which the vulnerability assessment is defined.
     * @param parameters The requested resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ServerVulnerabilityAssessmentInner object if successful.
     */
    public ServerVulnerabilityAssessmentInner createOrUpdate(String resourceGroupName, String serverName, ServerVulnerabilityAssessmentInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates the server's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server for which the vulnerability assessment is defined.
     * @param parameters The requested resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ServerVulnerabilityAssessmentInner> createOrUpdateAsync(String resourceGroupName, String serverName, ServerVulnerabilityAssessmentInner parameters, final ServiceCallback<ServerVulnerabilityAssessmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters), serviceCallback);
    }

    /**
     * Creates or updates the server's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server for which the vulnerability assessment is defined.
     * @param parameters The requested resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServerVulnerabilityAssessmentInner object
     */
    public Observable<ServerVulnerabilityAssessmentInner> createOrUpdateAsync(String resourceGroupName, String serverName, ServerVulnerabilityAssessmentInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters).map(new Func1<ServiceResponse<ServerVulnerabilityAssessmentInner>, ServerVulnerabilityAssessmentInner>() {
            @Override
            public ServerVulnerabilityAssessmentInner call(ServiceResponse<ServerVulnerabilityAssessmentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates the server's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server for which the vulnerability assessment is defined.
     * @param parameters The requested resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ServerVulnerabilityAssessmentInner object
     */
    public Observable<ServiceResponse<ServerVulnerabilityAssessmentInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, ServerVulnerabilityAssessmentInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String vulnerabilityAssessmentName = "default";
        final String apiVersion = "2018-06-01-preview";
        return service.createOrUpdate(resourceGroupName, serverName, vulnerabilityAssessmentName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServerVulnerabilityAssessmentInner>>>() {
                @Override
                public Observable<ServiceResponse<ServerVulnerabilityAssessmentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ServerVulnerabilityAssessmentInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ServerVulnerabilityAssessmentInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ServerVulnerabilityAssessmentInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ServerVulnerabilityAssessmentInner>() { }.getType())
                .register(201, new TypeToken<ServerVulnerabilityAssessmentInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Removes the server's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server for which the vulnerability assessment is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String serverName) {
        deleteWithServiceResponseAsync(resourceGroupName, serverName).toBlocking().single().body();
    }

    /**
     * Removes the server's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server for which the vulnerability assessment is defined.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, serverName), serviceCallback);
    }

    /**
     * Removes the server's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server for which the vulnerability assessment is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String serverName) {
        return deleteWithServiceResponseAsync(resourceGroupName, serverName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Removes the server's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server for which the vulnerability assessment is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String vulnerabilityAssessmentName = "default";
        final String apiVersion = "2018-06-01-preview";
        return service.delete(resourceGroupName, serverName, vulnerabilityAssessmentName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the vulnerability assessment policies associated with a server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ServerVulnerabilityAssessmentInner&gt; object if successful.
     */
    public PagedList<ServerVulnerabilityAssessmentInner> listByServer(final String resourceGroupName, final String serverName) {
        ServiceResponse<Page<ServerVulnerabilityAssessmentInner>> response = listByServerSinglePageAsync(resourceGroupName, serverName).toBlocking().single();
        return new PagedList<ServerVulnerabilityAssessmentInner>(response.body()) {
            @Override
            public Page<ServerVulnerabilityAssessmentInner> nextPage(String nextPageLink) {
                return listByServerNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the vulnerability assessment policies associated with a server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ServerVulnerabilityAssessmentInner>> listByServerAsync(final String resourceGroupName, final String serverName, final ListOperationCallback<ServerVulnerabilityAssessmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByServerSinglePageAsync(resourceGroupName, serverName),
            new Func1<String, Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>> call(String nextPageLink) {
                    return listByServerNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the vulnerability assessment policies associated with a server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ServerVulnerabilityAssessmentInner&gt; object
     */
    public Observable<Page<ServerVulnerabilityAssessmentInner>> listByServerAsync(final String resourceGroupName, final String serverName) {
        return listByServerWithServiceResponseAsync(resourceGroupName, serverName)
            .map(new Func1<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>, Page<ServerVulnerabilityAssessmentInner>>() {
                @Override
                public Page<ServerVulnerabilityAssessmentInner> call(ServiceResponse<Page<ServerVulnerabilityAssessmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the vulnerability assessment policies associated with a server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ServerVulnerabilityAssessmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>> listByServerWithServiceResponseAsync(final String resourceGroupName, final String serverName) {
        return listByServerSinglePageAsync(resourceGroupName, serverName)
            .concatMap(new Func1<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>, Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>> call(ServiceResponse<Page<ServerVulnerabilityAssessmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByServerNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the vulnerability assessment policies associated with a server.
     *
    ServiceResponse<PageImpl1<ServerVulnerabilityAssessmentInner>> * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    ServiceResponse<PageImpl1<ServerVulnerabilityAssessmentInner>> * @param serverName The name of the server.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ServerVulnerabilityAssessmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>> listByServerSinglePageAsync(final String resourceGroupName, final String serverName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01-preview";
        return service.listByServer(resourceGroupName, serverName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<ServerVulnerabilityAssessmentInner>> result = listByServerDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<ServerVulnerabilityAssessmentInner>> listByServerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<ServerVulnerabilityAssessmentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<ServerVulnerabilityAssessmentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the vulnerability assessment policies associated with a server.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ServerVulnerabilityAssessmentInner&gt; object if successful.
     */
    public PagedList<ServerVulnerabilityAssessmentInner> listByServerNext(final String nextPageLink) {
        ServiceResponse<Page<ServerVulnerabilityAssessmentInner>> response = listByServerNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ServerVulnerabilityAssessmentInner>(response.body()) {
            @Override
            public Page<ServerVulnerabilityAssessmentInner> nextPage(String nextPageLink) {
                return listByServerNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the vulnerability assessment policies associated with a server.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ServerVulnerabilityAssessmentInner>> listByServerNextAsync(final String nextPageLink, final ServiceFuture<List<ServerVulnerabilityAssessmentInner>> serviceFuture, final ListOperationCallback<ServerVulnerabilityAssessmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByServerNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>> call(String nextPageLink) {
                    return listByServerNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the vulnerability assessment policies associated with a server.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ServerVulnerabilityAssessmentInner&gt; object
     */
    public Observable<Page<ServerVulnerabilityAssessmentInner>> listByServerNextAsync(final String nextPageLink) {
        return listByServerNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>, Page<ServerVulnerabilityAssessmentInner>>() {
                @Override
                public Page<ServerVulnerabilityAssessmentInner> call(ServiceResponse<Page<ServerVulnerabilityAssessmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the vulnerability assessment policies associated with a server.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ServerVulnerabilityAssessmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>> listByServerNextWithServiceResponseAsync(final String nextPageLink) {
        return listByServerNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>, Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>> call(ServiceResponse<Page<ServerVulnerabilityAssessmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByServerNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the vulnerability assessment policies associated with a server.
     *
    ServiceResponse<PageImpl1<ServerVulnerabilityAssessmentInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ServerVulnerabilityAssessmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>> listByServerNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByServerNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<ServerVulnerabilityAssessmentInner>> result = listByServerNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<ServerVulnerabilityAssessmentInner>> listByServerNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<ServerVulnerabilityAssessmentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<ServerVulnerabilityAssessmentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
