/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Partner server information for the failover group.
 */
public class PartnerInfo {
    /**
     * Resource identifier of the partner server.
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /**
     * Geo location of the partner server.
     */
    @JsonProperty(value = "location", access = JsonProperty.Access.WRITE_ONLY)
    private String location;

    /**
     * Replication role of the partner server. Possible values include:
     * 'Primary', 'Secondary'.
     */
    @JsonProperty(value = "replicationRole", access = JsonProperty.Access.WRITE_ONLY)
    private FailoverGroupReplicationRole replicationRole;

    /**
     * Get resource identifier of the partner server.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Set resource identifier of the partner server.
     *
     * @param id the id value to set
     * @return the PartnerInfo object itself.
     */
    public PartnerInfo withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get geo location of the partner server.
     *
     * @return the location value
     */
    public String location() {
        return this.location;
    }

    /**
     * Get replication role of the partner server. Possible values include: 'Primary', 'Secondary'.
     *
     * @return the replicationRole value
     */
    public FailoverGroupReplicationRole replicationRole() {
        return this.replicationRole;
    }

}
