/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.sql.SqlFailoverGroup;
import com.microsoft.azure.management.sql.SqlFailoverGroupOperations;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.implementation.FailoverGroupInner;
import com.microsoft.azure.management.sql.implementation.SqlChildrenOperationsImpl;
import com.microsoft.azure.management.sql.implementation.SqlFailoverGroupImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlFailoverGroupOperationsImpl
extends SqlChildrenOperationsImpl<SqlFailoverGroup>
implements SqlFailoverGroupOperations,
SqlFailoverGroupOperations.SqlFailoverGroupActionsDefinition {
    SqlFailoverGroupOperationsImpl(SqlServer parent, SqlServerManager sqlServerManager) {
        super(parent, sqlServerManager);
        Objects.requireNonNull(parent);
    }

    SqlFailoverGroupOperationsImpl(SqlServerManager sqlServerManager) {
        super(null, sqlServerManager);
    }

    @Override
    public SqlFailoverGroup getBySqlServer(String resourceGroupName, String sqlServerName, String name) {
        FailoverGroupInner failoverGroupInner = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).failoverGroups().get(resourceGroupName, sqlServerName, name);
        return failoverGroupInner != null ? new SqlFailoverGroupImpl(name, failoverGroupInner, this.sqlServerManager) : null;
    }

    @Override
    public Observable<SqlFailoverGroup> getBySqlServerAsync(String resourceGroupName, String sqlServerName, final String name) {
        final SqlFailoverGroupOperationsImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).failoverGroups().getAsync(resourceGroupName, sqlServerName, name).map((Func1)new Func1<FailoverGroupInner, SqlFailoverGroup>(){

            public SqlFailoverGroup call(FailoverGroupInner failoverGroupInner) {
                return new SqlFailoverGroupImpl(name, failoverGroupInner, self.sqlServerManager);
            }
        });
    }

    @Override
    public SqlFailoverGroup getBySqlServer(SqlServer sqlServer, String name) {
        Objects.requireNonNull(sqlServer);
        FailoverGroupInner failoverGroupInner = ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)sqlServer.manager())).inner())).failoverGroups().get(sqlServer.resourceGroupName(), sqlServer.name(), name);
        return failoverGroupInner != null ? new SqlFailoverGroupImpl(name, (SqlServerImpl)sqlServer, failoverGroupInner, (SqlServerManager)((Object)sqlServer.manager())) : null;
    }

    @Override
    public Observable<SqlFailoverGroup> getBySqlServerAsync(final SqlServer sqlServer, final String name) {
        Objects.requireNonNull(sqlServer);
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)sqlServer.manager())).inner())).failoverGroups().getAsync(sqlServer.resourceGroupName(), sqlServer.name(), name).map((Func1)new Func1<FailoverGroupInner, SqlFailoverGroup>(){

            public SqlFailoverGroup call(FailoverGroupInner failoverGroupInner) {
                return new SqlFailoverGroupImpl(name, (SqlServerImpl)sqlServer, failoverGroupInner, (SqlServerManager)((Object)sqlServer.manager()));
            }
        });
    }

    @Override
    public void deleteBySqlServer(String resourceGroupName, String sqlServerName, String name) {
        ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).failoverGroups().delete(resourceGroupName, sqlServerName, name);
    }

    @Override
    public Completable deleteBySqlServerAsync(String resourceGroupName, String sqlServerName, String name) {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).failoverGroups().deleteAsync(resourceGroupName, sqlServerName, name).toCompletable();
    }

    @Override
    public List<SqlFailoverGroup> listBySqlServer(String resourceGroupName, String sqlServerName) {
        ArrayList<SqlFailoverGroupImpl> failoverGroups = new ArrayList<SqlFailoverGroupImpl>();
        PagedList<FailoverGroupInner> failoverGroupInners = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).failoverGroups().listByServer(resourceGroupName, sqlServerName);
        if (failoverGroupInners != null) {
            for (FailoverGroupInner inner : failoverGroupInners) {
                failoverGroups.add(new SqlFailoverGroupImpl(inner.name(), inner, this.sqlServerManager));
            }
        }
        return Collections.unmodifiableList(failoverGroups);
    }

    @Override
    public Observable<SqlFailoverGroup> listBySqlServerAsync(String resourceGroupName, String sqlServerName) {
        final SqlFailoverGroupOperationsImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).failoverGroups().listByServerAsync(resourceGroupName, sqlServerName).flatMap((Func1)new Func1<Page<FailoverGroupInner>, Observable<FailoverGroupInner>>(){

            public Observable<FailoverGroupInner> call(Page<FailoverGroupInner> failoverGroupInnerPage) {
                return Observable.from((Iterable)failoverGroupInnerPage.items());
            }
        }).map((Func1)new Func1<FailoverGroupInner, SqlFailoverGroup>(){

            public SqlFailoverGroup call(FailoverGroupInner failoverGroupInner) {
                return new SqlFailoverGroupImpl(failoverGroupInner.name(), failoverGroupInner, self.sqlServerManager);
            }
        });
    }

    @Override
    public List<SqlFailoverGroup> listBySqlServer(SqlServer sqlServer) {
        ArrayList<SqlFailoverGroupImpl> failoverGroups = new ArrayList<SqlFailoverGroupImpl>();
        PagedList<FailoverGroupInner> failoverGroupInners = ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)sqlServer.manager())).inner())).failoverGroups().listByServer(sqlServer.resourceGroupName(), sqlServer.name());
        if (failoverGroupInners != null) {
            for (FailoverGroupInner inner : failoverGroupInners) {
                failoverGroups.add(new SqlFailoverGroupImpl(inner.name(), (SqlServerImpl)sqlServer, inner, this.sqlServerManager));
            }
        }
        return Collections.unmodifiableList(failoverGroups);
    }

    @Override
    public Observable<SqlFailoverGroup> listBySqlServerAsync(final SqlServer sqlServer) {
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)sqlServer.manager())).inner())).failoverGroups().listByServerAsync(sqlServer.resourceGroupName(), sqlServer.name()).flatMap((Func1)new Func1<Page<FailoverGroupInner>, Observable<FailoverGroupInner>>(){

            public Observable<FailoverGroupInner> call(Page<FailoverGroupInner> failoverGroupInnerPage) {
                return Observable.from((Iterable)failoverGroupInnerPage.items());
            }
        }).map((Func1)new Func1<FailoverGroupInner, SqlFailoverGroup>(){

            public SqlFailoverGroup call(FailoverGroupInner failoverGroupInner) {
                return new SqlFailoverGroupImpl(failoverGroupInner.name(), (SqlServerImpl)sqlServer, failoverGroupInner, (SqlServerManager)((Object)sqlServer.manager()));
            }
        });
    }

    @Override
    public SqlFailoverGroupImpl define(String name) {
        SqlFailoverGroupImpl result = new SqlFailoverGroupImpl(name, new FailoverGroupInner(), this.sqlServerManager);
        result.setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
        return this.sqlServer != null ? result.withExistingSqlServer(this.sqlServer) : result;
    }

    @Override
    public SqlFailoverGroup failover(String failoverGroupName) {
        Objects.requireNonNull(this.sqlServer);
        FailoverGroupInner failoverGroupInner = ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)this.sqlServer.manager())).inner())).failoverGroups().failover(this.sqlServer.resourceGroupName(), this.sqlServer.name(), failoverGroupName);
        return failoverGroupInner != null ? new SqlFailoverGroupImpl(failoverGroupInner.name(), (SqlServerImpl)this.sqlServer, failoverGroupInner, (SqlServerManager)((Object)this.sqlServer.manager())) : null;
    }

    @Override
    public Observable<SqlFailoverGroup> failoverAsync(String failoverGroupName) {
        Objects.requireNonNull(this.sqlServer);
        SqlFailoverGroupOperationsImpl self = this;
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)this.sqlServer.manager())).inner())).failoverGroups().failoverAsync(this.sqlServer.resourceGroupName(), this.sqlServer.name(), failoverGroupName).map((Func1)new Func1<FailoverGroupInner, SqlFailoverGroup>(){

            public SqlFailoverGroup call(FailoverGroupInner failoverGroupInner) {
                return new SqlFailoverGroupImpl(failoverGroupInner.name(), (SqlServerImpl)SqlFailoverGroupOperationsImpl.this.sqlServer, failoverGroupInner, (SqlServerManager)((Object)SqlFailoverGroupOperationsImpl.this.sqlServer.manager()));
            }
        });
    }

    @Override
    public SqlFailoverGroup forceFailoverAllowDataLoss(String failoverGroupName) {
        Objects.requireNonNull(this.sqlServer);
        FailoverGroupInner failoverGroupInner = ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)this.sqlServer.manager())).inner())).failoverGroups().forceFailoverAllowDataLoss(this.sqlServer.resourceGroupName(), this.sqlServer.name(), failoverGroupName);
        return failoverGroupInner != null ? new SqlFailoverGroupImpl(failoverGroupInner.name(), (SqlServerImpl)this.sqlServer, failoverGroupInner, (SqlServerManager)((Object)this.sqlServer.manager())) : null;
    }

    @Override
    public Observable<SqlFailoverGroup> forceFailoverAllowDataLossAsync(String failoverGroupName) {
        Objects.requireNonNull(this.sqlServer);
        SqlFailoverGroupOperationsImpl self = this;
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)this.sqlServer.manager())).inner())).failoverGroups().forceFailoverAllowDataLossAsync(this.sqlServer.resourceGroupName(), this.sqlServer.name(), failoverGroupName).map((Func1)new Func1<FailoverGroupInner, SqlFailoverGroup>(){

            public SqlFailoverGroup call(FailoverGroupInner failoverGroupInner) {
                return new SqlFailoverGroupImpl(failoverGroupInner.name(), (SqlServerImpl)SqlFailoverGroupOperationsImpl.this.sqlServer, failoverGroupInner, (SqlServerManager)((Object)SqlFailoverGroupOperationsImpl.this.sqlServer.manager()));
            }
        });
    }

    @Override
    public SqlFailoverGroup failover(String resourceGroupName, String serverName, String failoverGroupName) {
        FailoverGroupInner failoverGroupInner = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).failoverGroups().failover(resourceGroupName, serverName, failoverGroupName);
        return failoverGroupInner != null ? new SqlFailoverGroupImpl(failoverGroupInner.name(), failoverGroupInner, this.sqlServerManager) : null;
    }

    @Override
    public Observable<SqlFailoverGroup> failoverAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        final SqlFailoverGroupOperationsImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).failoverGroups().failoverAsync(resourceGroupName, serverName, failoverGroupName).map((Func1)new Func1<FailoverGroupInner, SqlFailoverGroup>(){

            public SqlFailoverGroup call(FailoverGroupInner failoverGroupInner) {
                return new SqlFailoverGroupImpl(failoverGroupInner.name(), failoverGroupInner, self.sqlServerManager);
            }
        });
    }

    @Override
    public SqlFailoverGroup forceFailoverAllowDataLoss(String resourceGroupName, String serverName, String failoverGroupName) {
        FailoverGroupInner failoverGroupInner = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).failoverGroups().forceFailoverAllowDataLoss(resourceGroupName, serverName, failoverGroupName);
        return failoverGroupInner != null ? new SqlFailoverGroupImpl(failoverGroupInner.name(), failoverGroupInner, this.sqlServerManager) : null;
    }

    @Override
    public Observable<SqlFailoverGroup> forceFailoverAllowDataLossAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        final SqlFailoverGroupOperationsImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).failoverGroups().forceFailoverAllowDataLossAsync(resourceGroupName, serverName, failoverGroupName).map((Func1)new Func1<FailoverGroupInner, SqlFailoverGroup>(){

            public SqlFailoverGroup call(FailoverGroupInner failoverGroupInner) {
                return new SqlFailoverGroupImpl(failoverGroupInner.name(), failoverGroupInner, self.sqlServerManager);
            }
        });
    }
}

