/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in InstanceFailoverGroups.
 */
public class InstanceFailoverGroupsInner {
    /** The Retrofit service to perform REST calls. */
    private InstanceFailoverGroupsService service;
    /** The service client containing this operation class. */
    private SqlManagementClientImpl client;

    /**
     * Initializes an instance of InstanceFailoverGroupsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public InstanceFailoverGroupsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = retrofit.create(InstanceFailoverGroupsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for InstanceFailoverGroups to be
     * used by Retrofit to perform actually REST calls.
     */
    interface InstanceFailoverGroupsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstanceFailoverGroups get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("locationName") String locationName, @Path("failoverGroupName") String failoverGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstanceFailoverGroups createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("locationName") String locationName, @Path("failoverGroupName") String failoverGroupName, @Path("subscriptionId") String subscriptionId, @Body InstanceFailoverGroupInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstanceFailoverGroups beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("locationName") String locationName, @Path("failoverGroupName") String failoverGroupName, @Path("subscriptionId") String subscriptionId, @Body InstanceFailoverGroupInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstanceFailoverGroups delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("locationName") String locationName, @Path("failoverGroupName") String failoverGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstanceFailoverGroups beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("locationName") String locationName, @Path("failoverGroupName") String failoverGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstanceFailoverGroups listByLocation" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups")
        Observable<Response<ResponseBody>> listByLocation(@Path("resourceGroupName") String resourceGroupName, @Path("locationName") String locationName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstanceFailoverGroups failover" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}/failover")
        Observable<Response<ResponseBody>> failover(@Path("resourceGroupName") String resourceGroupName, @Path("locationName") String locationName, @Path("failoverGroupName") String failoverGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstanceFailoverGroups beginFailover" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}/failover")
        Observable<Response<ResponseBody>> beginFailover(@Path("resourceGroupName") String resourceGroupName, @Path("locationName") String locationName, @Path("failoverGroupName") String failoverGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstanceFailoverGroups forceFailoverAllowDataLoss" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}/forceFailoverAllowDataLoss")
        Observable<Response<ResponseBody>> forceFailoverAllowDataLoss(@Path("resourceGroupName") String resourceGroupName, @Path("locationName") String locationName, @Path("failoverGroupName") String failoverGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstanceFailoverGroups beginForceFailoverAllowDataLoss" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/instanceFailoverGroups/{failoverGroupName}/forceFailoverAllowDataLoss")
        Observable<Response<ResponseBody>> beginForceFailoverAllowDataLoss(@Path("resourceGroupName") String resourceGroupName, @Path("locationName") String locationName, @Path("failoverGroupName") String failoverGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstanceFailoverGroups listByLocationNext" })
        @GET
        Observable<Response<ResponseBody>> listByLocationNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the InstanceFailoverGroupInner object if successful.
     */
    public InstanceFailoverGroupInner get(String resourceGroupName, String locationName, String failoverGroupName) {
        return getWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).toBlocking().single().body();
    }

    /**
     * Gets a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<InstanceFailoverGroupInner> getAsync(String resourceGroupName, String locationName, String failoverGroupName, final ServiceCallback<InstanceFailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName), serviceCallback);
    }

    /**
     * Gets a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InstanceFailoverGroupInner object
     */
    public Observable<InstanceFailoverGroupInner> getAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        return getWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).map(new Func1<ServiceResponse<InstanceFailoverGroupInner>, InstanceFailoverGroupInner>() {
            @Override
            public InstanceFailoverGroupInner call(ServiceResponse<InstanceFailoverGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InstanceFailoverGroupInner object
     */
    public Observable<ServiceResponse<InstanceFailoverGroupInner>> getWithServiceResponseAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01-preview";
        return service.get(resourceGroupName, locationName, failoverGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<InstanceFailoverGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<InstanceFailoverGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<InstanceFailoverGroupInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<InstanceFailoverGroupInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<InstanceFailoverGroupInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<InstanceFailoverGroupInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the InstanceFailoverGroupInner object if successful.
     */
    public InstanceFailoverGroupInner createOrUpdate(String resourceGroupName, String locationName, String failoverGroupName, InstanceFailoverGroupInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName, parameters).toBlocking().last().body();
    }

    /**
     * Creates or updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<InstanceFailoverGroupInner> createOrUpdateAsync(String resourceGroupName, String locationName, String failoverGroupName, InstanceFailoverGroupInner parameters, final ServiceCallback<InstanceFailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName, parameters), serviceCallback);
    }

    /**
     * Creates or updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<InstanceFailoverGroupInner> createOrUpdateAsync(String resourceGroupName, String locationName, String failoverGroupName, InstanceFailoverGroupInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName, parameters).map(new Func1<ServiceResponse<InstanceFailoverGroupInner>, InstanceFailoverGroupInner>() {
            @Override
            public InstanceFailoverGroupInner call(ServiceResponse<InstanceFailoverGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<InstanceFailoverGroupInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String locationName, String failoverGroupName, InstanceFailoverGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2017-10-01-preview";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, locationName, failoverGroupName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<InstanceFailoverGroupInner>() { }.getType());
    }

    /**
     * Creates or updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the InstanceFailoverGroupInner object if successful.
     */
    public InstanceFailoverGroupInner beginCreateOrUpdate(String resourceGroupName, String locationName, String failoverGroupName, InstanceFailoverGroupInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<InstanceFailoverGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String locationName, String failoverGroupName, InstanceFailoverGroupInner parameters, final ServiceCallback<InstanceFailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName, parameters), serviceCallback);
    }

    /**
     * Creates or updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InstanceFailoverGroupInner object
     */
    public Observable<InstanceFailoverGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String locationName, String failoverGroupName, InstanceFailoverGroupInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName, parameters).map(new Func1<ServiceResponse<InstanceFailoverGroupInner>, InstanceFailoverGroupInner>() {
            @Override
            public InstanceFailoverGroupInner call(ServiceResponse<InstanceFailoverGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InstanceFailoverGroupInner object
     */
    public Observable<ServiceResponse<InstanceFailoverGroupInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String locationName, String failoverGroupName, InstanceFailoverGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2017-10-01-preview";
        return service.beginCreateOrUpdate(resourceGroupName, locationName, failoverGroupName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<InstanceFailoverGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<InstanceFailoverGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<InstanceFailoverGroupInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<InstanceFailoverGroupInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<InstanceFailoverGroupInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<InstanceFailoverGroupInner>() { }.getType())
                .register(201, new TypeToken<InstanceFailoverGroupInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String locationName, String failoverGroupName) {
        deleteWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).toBlocking().last().body();
    }

    /**
     * Deletes a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String locationName, String failoverGroupName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName), serviceCallback);
    }

    /**
     * Deletes a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        return deleteWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01-preview";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, locationName, failoverGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String locationName, String failoverGroupName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).toBlocking().single().body();
    }

    /**
     * Deletes a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String locationName, String failoverGroupName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName), serviceCallback);
    }

    /**
     * Deletes a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01-preview";
        return service.beginDelete(resourceGroupName, locationName, failoverGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the failover groups in a location.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;InstanceFailoverGroupInner&gt; object if successful.
     */
    public PagedList<InstanceFailoverGroupInner> listByLocation(final String resourceGroupName, final String locationName) {
        ServiceResponse<Page<InstanceFailoverGroupInner>> response = listByLocationSinglePageAsync(resourceGroupName, locationName).toBlocking().single();
        return new PagedList<InstanceFailoverGroupInner>(response.body()) {
            @Override
            public Page<InstanceFailoverGroupInner> nextPage(String nextPageLink) {
                return listByLocationNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the failover groups in a location.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<InstanceFailoverGroupInner>> listByLocationAsync(final String resourceGroupName, final String locationName, final ListOperationCallback<InstanceFailoverGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByLocationSinglePageAsync(resourceGroupName, locationName),
            new Func1<String, Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>> call(String nextPageLink) {
                    return listByLocationNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the failover groups in a location.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;InstanceFailoverGroupInner&gt; object
     */
    public Observable<Page<InstanceFailoverGroupInner>> listByLocationAsync(final String resourceGroupName, final String locationName) {
        return listByLocationWithServiceResponseAsync(resourceGroupName, locationName)
            .map(new Func1<ServiceResponse<Page<InstanceFailoverGroupInner>>, Page<InstanceFailoverGroupInner>>() {
                @Override
                public Page<InstanceFailoverGroupInner> call(ServiceResponse<Page<InstanceFailoverGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the failover groups in a location.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;InstanceFailoverGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>> listByLocationWithServiceResponseAsync(final String resourceGroupName, final String locationName) {
        return listByLocationSinglePageAsync(resourceGroupName, locationName)
            .concatMap(new Func1<ServiceResponse<Page<InstanceFailoverGroupInner>>, Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>> call(ServiceResponse<Page<InstanceFailoverGroupInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByLocationNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the failover groups in a location.
     *
    ServiceResponse<PageImpl1<InstanceFailoverGroupInner>> * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    ServiceResponse<PageImpl1<InstanceFailoverGroupInner>> * @param locationName The name of the region where the resource is located.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;InstanceFailoverGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>> listByLocationSinglePageAsync(final String resourceGroupName, final String locationName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01-preview";
        return service.listByLocation(resourceGroupName, locationName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<InstanceFailoverGroupInner>> result = listByLocationDelegate(response);
                        return Observable.just(new ServiceResponse<Page<InstanceFailoverGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<InstanceFailoverGroupInner>> listByLocationDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<InstanceFailoverGroupInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<InstanceFailoverGroupInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Fails over from the current primary managed instance to this managed instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the InstanceFailoverGroupInner object if successful.
     */
    public InstanceFailoverGroupInner failover(String resourceGroupName, String locationName, String failoverGroupName) {
        return failoverWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).toBlocking().last().body();
    }

    /**
     * Fails over from the current primary managed instance to this managed instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<InstanceFailoverGroupInner> failoverAsync(String resourceGroupName, String locationName, String failoverGroupName, final ServiceCallback<InstanceFailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(failoverWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName), serviceCallback);
    }

    /**
     * Fails over from the current primary managed instance to this managed instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<InstanceFailoverGroupInner> failoverAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        return failoverWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).map(new Func1<ServiceResponse<InstanceFailoverGroupInner>, InstanceFailoverGroupInner>() {
            @Override
            public InstanceFailoverGroupInner call(ServiceResponse<InstanceFailoverGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Fails over from the current primary managed instance to this managed instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<InstanceFailoverGroupInner>> failoverWithServiceResponseAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01-preview";
        Observable<Response<ResponseBody>> observable = service.failover(resourceGroupName, locationName, failoverGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<InstanceFailoverGroupInner>() { }.getType());
    }

    /**
     * Fails over from the current primary managed instance to this managed instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the InstanceFailoverGroupInner object if successful.
     */
    public InstanceFailoverGroupInner beginFailover(String resourceGroupName, String locationName, String failoverGroupName) {
        return beginFailoverWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).toBlocking().single().body();
    }

    /**
     * Fails over from the current primary managed instance to this managed instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<InstanceFailoverGroupInner> beginFailoverAsync(String resourceGroupName, String locationName, String failoverGroupName, final ServiceCallback<InstanceFailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginFailoverWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName), serviceCallback);
    }

    /**
     * Fails over from the current primary managed instance to this managed instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InstanceFailoverGroupInner object
     */
    public Observable<InstanceFailoverGroupInner> beginFailoverAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        return beginFailoverWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).map(new Func1<ServiceResponse<InstanceFailoverGroupInner>, InstanceFailoverGroupInner>() {
            @Override
            public InstanceFailoverGroupInner call(ServiceResponse<InstanceFailoverGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Fails over from the current primary managed instance to this managed instance.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InstanceFailoverGroupInner object
     */
    public Observable<ServiceResponse<InstanceFailoverGroupInner>> beginFailoverWithServiceResponseAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01-preview";
        return service.beginFailover(resourceGroupName, locationName, failoverGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<InstanceFailoverGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<InstanceFailoverGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<InstanceFailoverGroupInner> clientResponse = beginFailoverDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<InstanceFailoverGroupInner> beginFailoverDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<InstanceFailoverGroupInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<InstanceFailoverGroupInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Fails over from the current primary managed instance to this managed instance. This operation might result in data loss.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the InstanceFailoverGroupInner object if successful.
     */
    public InstanceFailoverGroupInner forceFailoverAllowDataLoss(String resourceGroupName, String locationName, String failoverGroupName) {
        return forceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).toBlocking().last().body();
    }

    /**
     * Fails over from the current primary managed instance to this managed instance. This operation might result in data loss.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<InstanceFailoverGroupInner> forceFailoverAllowDataLossAsync(String resourceGroupName, String locationName, String failoverGroupName, final ServiceCallback<InstanceFailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(forceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName), serviceCallback);
    }

    /**
     * Fails over from the current primary managed instance to this managed instance. This operation might result in data loss.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<InstanceFailoverGroupInner> forceFailoverAllowDataLossAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        return forceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).map(new Func1<ServiceResponse<InstanceFailoverGroupInner>, InstanceFailoverGroupInner>() {
            @Override
            public InstanceFailoverGroupInner call(ServiceResponse<InstanceFailoverGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Fails over from the current primary managed instance to this managed instance. This operation might result in data loss.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<InstanceFailoverGroupInner>> forceFailoverAllowDataLossWithServiceResponseAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01-preview";
        Observable<Response<ResponseBody>> observable = service.forceFailoverAllowDataLoss(resourceGroupName, locationName, failoverGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<InstanceFailoverGroupInner>() { }.getType());
    }

    /**
     * Fails over from the current primary managed instance to this managed instance. This operation might result in data loss.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the InstanceFailoverGroupInner object if successful.
     */
    public InstanceFailoverGroupInner beginForceFailoverAllowDataLoss(String resourceGroupName, String locationName, String failoverGroupName) {
        return beginForceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).toBlocking().single().body();
    }

    /**
     * Fails over from the current primary managed instance to this managed instance. This operation might result in data loss.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<InstanceFailoverGroupInner> beginForceFailoverAllowDataLossAsync(String resourceGroupName, String locationName, String failoverGroupName, final ServiceCallback<InstanceFailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginForceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName), serviceCallback);
    }

    /**
     * Fails over from the current primary managed instance to this managed instance. This operation might result in data loss.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InstanceFailoverGroupInner object
     */
    public Observable<InstanceFailoverGroupInner> beginForceFailoverAllowDataLossAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        return beginForceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, locationName, failoverGroupName).map(new Func1<ServiceResponse<InstanceFailoverGroupInner>, InstanceFailoverGroupInner>() {
            @Override
            public InstanceFailoverGroupInner call(ServiceResponse<InstanceFailoverGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Fails over from the current primary managed instance to this managed instance. This operation might result in data loss.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param locationName The name of the region where the resource is located.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InstanceFailoverGroupInner object
     */
    public Observable<ServiceResponse<InstanceFailoverGroupInner>> beginForceFailoverAllowDataLossWithServiceResponseAsync(String resourceGroupName, String locationName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2017-10-01-preview";
        return service.beginForceFailoverAllowDataLoss(resourceGroupName, locationName, failoverGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<InstanceFailoverGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<InstanceFailoverGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<InstanceFailoverGroupInner> clientResponse = beginForceFailoverAllowDataLossDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<InstanceFailoverGroupInner> beginForceFailoverAllowDataLossDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<InstanceFailoverGroupInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<InstanceFailoverGroupInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the failover groups in a location.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;InstanceFailoverGroupInner&gt; object if successful.
     */
    public PagedList<InstanceFailoverGroupInner> listByLocationNext(final String nextPageLink) {
        ServiceResponse<Page<InstanceFailoverGroupInner>> response = listByLocationNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<InstanceFailoverGroupInner>(response.body()) {
            @Override
            public Page<InstanceFailoverGroupInner> nextPage(String nextPageLink) {
                return listByLocationNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the failover groups in a location.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<InstanceFailoverGroupInner>> listByLocationNextAsync(final String nextPageLink, final ServiceFuture<List<InstanceFailoverGroupInner>> serviceFuture, final ListOperationCallback<InstanceFailoverGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByLocationNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>> call(String nextPageLink) {
                    return listByLocationNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the failover groups in a location.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;InstanceFailoverGroupInner&gt; object
     */
    public Observable<Page<InstanceFailoverGroupInner>> listByLocationNextAsync(final String nextPageLink) {
        return listByLocationNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<InstanceFailoverGroupInner>>, Page<InstanceFailoverGroupInner>>() {
                @Override
                public Page<InstanceFailoverGroupInner> call(ServiceResponse<Page<InstanceFailoverGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the failover groups in a location.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;InstanceFailoverGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>> listByLocationNextWithServiceResponseAsync(final String nextPageLink) {
        return listByLocationNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<InstanceFailoverGroupInner>>, Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>> call(ServiceResponse<Page<InstanceFailoverGroupInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByLocationNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the failover groups in a location.
     *
    ServiceResponse<PageImpl1<InstanceFailoverGroupInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;InstanceFailoverGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>> listByLocationNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByLocationNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InstanceFailoverGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<InstanceFailoverGroupInner>> result = listByLocationNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<InstanceFailoverGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<InstanceFailoverGroupInner>> listByLocationNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<InstanceFailoverGroupInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<InstanceFailoverGroupInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
