/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.ServerVulnerabilityAssessmentInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ServerVulnerabilityAssessmentsInner
implements InnerSupportsDelete<Void> {
    private ServerVulnerabilityAssessmentsService service;
    private SqlManagementClientImpl client;

    public ServerVulnerabilityAssessmentsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (ServerVulnerabilityAssessmentsService)retrofit.create(ServerVulnerabilityAssessmentsService.class);
        this.client = client;
    }

    public ServerVulnerabilityAssessmentInner get(String resourceGroupName, String serverName) {
        return (ServerVulnerabilityAssessmentInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName).toBlocking().single()).body());
    }

    public ServiceFuture<ServerVulnerabilityAssessmentInner> getAsync(String resourceGroupName, String serverName, ServiceCallback<ServerVulnerabilityAssessmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName), serviceCallback);
    }

    public Observable<ServerVulnerabilityAssessmentInner> getAsync(String resourceGroupName, String serverName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<ServerVulnerabilityAssessmentInner>, ServerVulnerabilityAssessmentInner>(){

            public ServerVulnerabilityAssessmentInner call(ServiceResponse<ServerVulnerabilityAssessmentInner> response) {
                return (ServerVulnerabilityAssessmentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServerVulnerabilityAssessmentInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String vulnerabilityAssessmentName = "default";
        String apiVersion = "2018-06-01-preview";
        return this.service.get(resourceGroupName, serverName, "default", this.client.subscriptionId(), "2018-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServerVulnerabilityAssessmentInner>>>(){

            public Observable<ServiceResponse<ServerVulnerabilityAssessmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerVulnerabilityAssessmentsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServerVulnerabilityAssessmentInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServerVulnerabilityAssessmentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ServerVulnerabilityAssessmentInner createOrUpdate(String resourceGroupName, String serverName, ServerVulnerabilityAssessmentInner parameters) {
        return (ServerVulnerabilityAssessmentInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ServerVulnerabilityAssessmentInner> createOrUpdateAsync(String resourceGroupName, String serverName, ServerVulnerabilityAssessmentInner parameters, ServiceCallback<ServerVulnerabilityAssessmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters), serviceCallback);
    }

    public Observable<ServerVulnerabilityAssessmentInner> createOrUpdateAsync(String resourceGroupName, String serverName, ServerVulnerabilityAssessmentInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters).map((Func1)new Func1<ServiceResponse<ServerVulnerabilityAssessmentInner>, ServerVulnerabilityAssessmentInner>(){

            public ServerVulnerabilityAssessmentInner call(ServiceResponse<ServerVulnerabilityAssessmentInner> response) {
                return (ServerVulnerabilityAssessmentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServerVulnerabilityAssessmentInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, ServerVulnerabilityAssessmentInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String vulnerabilityAssessmentName = "default";
        String apiVersion = "2018-06-01-preview";
        return this.service.createOrUpdate(resourceGroupName, serverName, "default", this.client.subscriptionId(), parameters, "2018-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServerVulnerabilityAssessmentInner>>>(){

            public Observable<ServiceResponse<ServerVulnerabilityAssessmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerVulnerabilityAssessmentsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServerVulnerabilityAssessmentInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServerVulnerabilityAssessmentInner>(){}.getType()).register(201, new TypeToken<ServerVulnerabilityAssessmentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String serverName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serverName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serverName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serverName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String vulnerabilityAssessmentName = "default";
        String apiVersion = "2018-06-01-preview";
        return this.service.delete(resourceGroupName, serverName, "default", this.client.subscriptionId(), "2018-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerVulnerabilityAssessmentsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ServerVulnerabilityAssessmentInner> listByServer(String resourceGroupName, String serverName) {
        ServiceResponse response = (ServiceResponse)this.listByServerSinglePageAsync(resourceGroupName, serverName).toBlocking().single();
        return new PagedList<ServerVulnerabilityAssessmentInner>((Page)response.body()){

            public Page<ServerVulnerabilityAssessmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ServerVulnerabilityAssessmentsInner.this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ServerVulnerabilityAssessmentInner>> listByServerAsync(String resourceGroupName, String serverName, ListOperationCallback<ServerVulnerabilityAssessmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByServerSinglePageAsync(resourceGroupName, serverName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>> call(String nextPageLink) {
                return ServerVulnerabilityAssessmentsInner.this.listByServerNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ServerVulnerabilityAssessmentInner>> listByServerAsync(String resourceGroupName, String serverName) {
        return this.listByServerWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>, Page<ServerVulnerabilityAssessmentInner>>(){

            public Page<ServerVulnerabilityAssessmentInner> call(ServiceResponse<Page<ServerVulnerabilityAssessmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>> listByServerWithServiceResponseAsync(String resourceGroupName, String serverName) {
        return this.listByServerSinglePageAsync(resourceGroupName, serverName).concatMap((Func1)new Func1<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>, Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>> call(ServiceResponse<Page<ServerVulnerabilityAssessmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ServerVulnerabilityAssessmentsInner.this.listByServerNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>> listByServerSinglePageAsync(String resourceGroupName, String serverName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01-preview";
        return this.service.listByServer(resourceGroupName, serverName, this.client.subscriptionId(), "2018-06-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServerVulnerabilityAssessmentsInner.this.listByServerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ServerVulnerabilityAssessmentInner>> listByServerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ServerVulnerabilityAssessmentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ServerVulnerabilityAssessmentInner> listByServerNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ServerVulnerabilityAssessmentInner>((Page)response.body()){

            public Page<ServerVulnerabilityAssessmentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ServerVulnerabilityAssessmentsInner.this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ServerVulnerabilityAssessmentInner>> listByServerNextAsync(String nextPageLink, ServiceFuture<List<ServerVulnerabilityAssessmentInner>> serviceFuture, ListOperationCallback<ServerVulnerabilityAssessmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByServerNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>> call(String nextPageLink) {
                return ServerVulnerabilityAssessmentsInner.this.listByServerNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ServerVulnerabilityAssessmentInner>> listByServerNextAsync(String nextPageLink) {
        return this.listByServerNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>, Page<ServerVulnerabilityAssessmentInner>>(){

            public Page<ServerVulnerabilityAssessmentInner> call(ServiceResponse<Page<ServerVulnerabilityAssessmentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>> listByServerNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByServerNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>, Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>> call(ServiceResponse<Page<ServerVulnerabilityAssessmentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ServerVulnerabilityAssessmentsInner.this.listByServerNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>> listByServerNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByServerNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>>>(){

            public Observable<ServiceResponse<Page<ServerVulnerabilityAssessmentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServerVulnerabilityAssessmentsInner.this.listByServerNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ServerVulnerabilityAssessmentInner>> listByServerNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ServerVulnerabilityAssessmentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ServerVulnerabilityAssessmentsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerVulnerabilityAssessments get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="vulnerabilityAssessmentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerVulnerabilityAssessments createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="vulnerabilityAssessmentName") String var3, @Path(value="subscriptionId") String var4, @Body ServerVulnerabilityAssessmentInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerVulnerabilityAssessments delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="vulnerabilityAssessmentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerVulnerabilityAssessments listByServer"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/vulnerabilityAssessments")
        public Observable<Response<ResponseBody>> listByServer(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerVulnerabilityAssessments listByServerNext"})
        @GET
        public Observable<Response<ResponseBody>> listByServerNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

