/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.utils.ListToMapConverter;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.azure.management.sql.ElasticPoolEditions;
import com.microsoft.azure.management.sql.RecommendedElasticPool;
import com.microsoft.azure.management.sql.ServerMetric;
import com.microsoft.azure.management.sql.ServerVersion;
import com.microsoft.azure.management.sql.ServiceObjective;
import com.microsoft.azure.management.sql.SqlDatabase;
import com.microsoft.azure.management.sql.SqlElasticPool;
import com.microsoft.azure.management.sql.SqlFirewallRule;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.implementation.DatabasesImpl;
import com.microsoft.azure.management.sql.implementation.ElasticPoolsImpl;
import com.microsoft.azure.management.sql.implementation.FirewallRulesImpl;
import com.microsoft.azure.management.sql.implementation.RecommendedElasticPoolImpl;
import com.microsoft.azure.management.sql.implementation.RecommendedElasticPoolInner;
import com.microsoft.azure.management.sql.implementation.ServerInner;
import com.microsoft.azure.management.sql.implementation.ServerMetricImpl;
import com.microsoft.azure.management.sql.implementation.ServerMetricInner;
import com.microsoft.azure.management.sql.implementation.ServersInner;
import com.microsoft.azure.management.sql.implementation.ServiceObjectiveImpl;
import com.microsoft.azure.management.sql.implementation.ServiceObjectiveInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlServerImpl
extends GroupableResourceImpl<SqlServer, ServerInner, SqlServerImpl, SqlServerManager>
implements SqlServer,
SqlServer.Definition,
SqlServer.Update {
    private final Map<String, SqlElasticPool.DefinitionStages.WithCreate> elasticPoolCreatableMap;
    private final Map<String, SqlFirewallRule.DefinitionStages.WithCreate> firewallRuleCreatableMap;
    private final Map<String, SqlDatabase.DefinitionStages.WithAllDifferentOptions> databaseCreatableMap = new HashMap<String, SqlDatabase.DefinitionStages.WithAllDifferentOptions>();
    private FirewallRulesImpl firewallRulesImpl;
    private ElasticPoolsImpl elasticPoolsImpl;
    private DatabasesImpl databasesImpl;
    private final List<String> elasticPoolsToDelete;
    private final List<String> firewallRulesToDelete;
    private final List<String> databasesToDelete;

    protected SqlServerImpl(String name, ServerInner innerObject, SqlServerManager manager) {
        super(name, (Resource)innerObject, (ManagerBase)manager);
        this.elasticPoolCreatableMap = new HashMap<String, SqlElasticPool.DefinitionStages.WithCreate>();
        this.firewallRuleCreatableMap = new HashMap<String, SqlFirewallRule.DefinitionStages.WithCreate>();
        this.elasticPoolsToDelete = new ArrayList<String>();
        this.databasesToDelete = new ArrayList<String>();
        this.firewallRulesToDelete = new ArrayList<String>();
    }

    protected Observable<ServerInner> getInnerAsync() {
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).servers().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public Observable<SqlServer> createResourceAsync() {
        final SqlServerImpl self = this;
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).servers().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ServerInner)((Object)this.inner())).map((Func1)new Func1<ServerInner, SqlServer>(){

            public SqlServer call(ServerInner serverInner) {
                SqlServerImpl.this.setInner((Object)serverInner);
                SqlServerImpl.this.deleteChildResources();
                SqlServerImpl.this.createOrUpdateChildResources();
                return self;
            }
        });
    }

    @Override
    public String fullyQualifiedDomainName() {
        return ((ServerInner)((Object)this.inner())).fullyQualifiedDomainName();
    }

    @Override
    public ServerVersion version() {
        return ((ServerInner)((Object)this.inner())).version();
    }

    @Override
    public String administratorLogin() {
        return ((ServerInner)((Object)this.inner())).administratorLogin();
    }

    @Override
    public SqlServer.FirewallRules firewallRules() {
        if (this.firewallRulesImpl == null) {
            this.firewallRulesImpl = new FirewallRulesImpl((SqlServerManager)this.manager(), this.resourceGroupName(), this.name());
        }
        return this.firewallRulesImpl;
    }

    @Override
    public SqlServer.ElasticPools elasticPools() {
        if (this.elasticPoolsImpl == null) {
            this.elasticPoolsImpl = new ElasticPoolsImpl((SqlServerManager)this.manager(), (DatabasesImpl)this.databases(), this.resourceGroupName(), this.name(), this.region());
        }
        return this.elasticPoolsImpl;
    }

    @Override
    public SqlServer.Databases databases() {
        if (this.databasesImpl == null) {
            this.databasesImpl = new DatabasesImpl((SqlServerManager)this.manager(), this.resourceGroupName(), this.name(), this.region());
        }
        return this.databasesImpl;
    }

    @Override
    public List<ServerMetric> listUsages() {
        PagedListConverter<ServerMetricInner, ServerMetric> converter = new PagedListConverter<ServerMetricInner, ServerMetric>(){

            public ServerMetric typeConvert(ServerMetricInner serverMetricInner) {
                return new ServerMetricImpl(serverMetricInner);
            }
        };
        return converter.convert(ReadableWrappersImpl.convertToPagedList(((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).servers().listUsages(this.resourceGroupName(), this.name())));
    }

    @Override
    public List<ServiceObjective> listServiceObjectives() {
        final ServersInner innerCollection = ((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).servers();
        PagedListConverter<ServiceObjectiveInner, ServiceObjective> converter = new PagedListConverter<ServiceObjectiveInner, ServiceObjective>(){

            public ServiceObjective typeConvert(ServiceObjectiveInner serviceObjectiveInner) {
                return new ServiceObjectiveImpl(serviceObjectiveInner, innerCollection);
            }
        };
        return converter.convert(ReadableWrappersImpl.convertToPagedList(((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).servers().listServiceObjectives(this.resourceGroupName(), this.name())));
    }

    @Override
    public ServiceObjective getServiceObjective(String serviceObjectiveName) {
        return new ServiceObjectiveImpl(((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).servers().getServiceObjective(this.resourceGroupName(), this.name(), serviceObjectiveName), ((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).servers());
    }

    @Override
    public Map<String, RecommendedElasticPool> listRecommendedElasticPools() {
        final SqlServerImpl self = this;
        ListToMapConverter<RecommendedElasticPool, RecommendedElasticPoolInner> converter = new ListToMapConverter<RecommendedElasticPool, RecommendedElasticPoolInner>(){

            protected String name(RecommendedElasticPoolInner recommendedElasticPoolInner) {
                return recommendedElasticPoolInner.name();
            }

            protected RecommendedElasticPool impl(RecommendedElasticPoolInner recommendedElasticPoolInner) {
                return new RecommendedElasticPoolImpl(recommendedElasticPoolInner, (SqlServerManager)self.manager());
            }
        };
        return converter.convertToUnmodifiableMap(((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).recommendedElasticPools().list(this.resourceGroupName(), this.name()));
    }

    @Override
    public SqlServerImpl withAdministratorLogin(String administratorLogin) {
        ((ServerInner)((Object)this.inner())).withAdministratorLogin(administratorLogin);
        return this;
    }

    @Override
    public SqlServerImpl withAdministratorPassword(String administratorLoginPassword) {
        ((ServerInner)((Object)this.inner())).withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    @Override
    public SqlServerImpl withNewDatabase(String databaseName) {
        this.databaseCreatableMap.remove(databaseName);
        this.databaseCreatableMap.put(databaseName, this.databases().define(databaseName));
        return this;
    }

    @Override
    public SqlServerImpl withoutDatabase(String databaseName) {
        this.databasesToDelete.add(databaseName);
        return this;
    }

    @Override
    public SqlServerImpl withNewElasticPool(String elasticPoolName, ElasticPoolEditions elasticPoolEdition, String ... databaseNames) {
        if (this.elasticPoolCreatableMap.get(elasticPoolName) == null) {
            this.elasticPoolCreatableMap.put(elasticPoolName, this.elasticPools().define(elasticPoolName).withEdition(elasticPoolEdition));
        }
        if (databaseNames != null) {
            for (String databaseName : databaseNames) {
                this.withDatabaseInElasticPool(databaseName, elasticPoolName);
            }
        }
        return this;
    }

    @Override
    public SqlServerImpl withNewElasticPool(String elasticPoolName, ElasticPoolEditions elasticPoolEdition) {
        return this.withNewElasticPool(elasticPoolName, elasticPoolEdition, null);
    }

    @Override
    public SqlServerImpl withoutElasticPool(String elasticPoolName) {
        this.elasticPoolsToDelete.add(elasticPoolName);
        return this;
    }

    private void withDatabaseInElasticPool(String databaseName, String elasticPoolName) {
        this.databaseCreatableMap.remove(databaseName);
        this.databaseCreatableMap.put(databaseName, (SqlDatabase.DefinitionStages.WithAllDifferentOptions)((Object)this.databases().define(databaseName).withExistingElasticPool(elasticPoolName)));
    }

    @Override
    public SqlServerImpl withNewFirewallRule(String ipAddress) {
        return this.withNewFirewallRule(ipAddress, ipAddress);
    }

    @Override
    public SqlServerImpl withNewFirewallRule(String startIPAddress, String endIPAddress) {
        return this.withNewFirewallRule(startIPAddress, endIPAddress, SdkContext.randomResourceName((String)"firewall_", (int)15));
    }

    @Override
    public SqlServerImpl withNewFirewallRule(String startIPAddress, String endIPAddress, String firewallRuleName) {
        this.firewallRuleCreatableMap.remove(firewallRuleName);
        this.firewallRuleCreatableMap.put(firewallRuleName, this.firewallRules().define(firewallRuleName).withIPAddressRange(startIPAddress, endIPAddress));
        return this;
    }

    @Override
    public SqlServerImpl withoutFirewallRule(String firewallRuleName) {
        this.firewallRulesToDelete.add(firewallRuleName);
        return this;
    }

    private Observable<Indexable> createOrUpdateFirewallRulesAsync() {
        final SqlServerImpl self = this;
        if (this.firewallRuleCreatableMap.size() > 0) {
            return Utils.rootResource((Observable)this.firewallRulesImpl.sqlFirewallRules().createAsync(new ArrayList<SqlFirewallRule.DefinitionStages.WithCreate>(this.firewallRuleCreatableMap.values()))).map((Func1)new Func1<Indexable, Indexable>(){

                public Indexable call(Indexable indexable) {
                    self.firewallRuleCreatableMap.clear();
                    return indexable;
                }
            });
        }
        return Observable.empty();
    }

    private Observable<Indexable> createOrUpdateElasticPoolsAndDatabasesAsync() {
        if (this.elasticPoolCreatableMap.size() > 0) {
            this.elasticPoolsImpl.elasticPools().create(new ArrayList<SqlElasticPool.DefinitionStages.WithCreate>(this.elasticPoolCreatableMap.values()));
            this.elasticPoolCreatableMap.clear();
        }
        final SqlServerImpl self = this;
        if (this.databaseCreatableMap.size() > 0) {
            return Utils.rootResource((Observable)this.databasesImpl.databases().createAsync(new ArrayList<SqlDatabase.DefinitionStages.WithAllDifferentOptions>(this.databaseCreatableMap.values()))).map((Func1)new Func1<Indexable, Indexable>(){

                public Indexable call(Indexable indexable) {
                    self.databaseCreatableMap.clear();
                    return indexable;
                }
            });
        }
        return Observable.empty();
    }

    private void createOrUpdateChildResources() {
        Observable<Indexable> createFirewallRules = this.createOrUpdateFirewallRulesAsync();
        Observable<Indexable> createDatabases = this.createOrUpdateElasticPoolsAndDatabasesAsync();
        Observable.merge(createFirewallRules, createDatabases).defaultIfEmpty(null).toBlocking().last();
    }

    private void deleteChildResources() {
        Completable deleteFirewallRules = this.deleteFirewallRule();
        Completable deleteDatabasesAndElasticPools = this.deleteDatabasesAndElasticPools();
        Completable.merge((Completable[])new Completable[]{deleteFirewallRules, deleteDatabasesAndElasticPools}).await();
    }

    private Completable deleteDatabasesAndElasticPools() {
        ArrayList<Completable> deleteDBList = new ArrayList<Completable>();
        for (String databaseName : this.databasesToDelete) {
            deleteDBList.add(this.databases().deleteAsync(databaseName));
        }
        Completable deleteDBs = Completable.merge(deleteDBList);
        ArrayList<Completable> deleteElasticPoolList = new ArrayList<Completable>();
        for (String elasticPoolName : this.elasticPoolsToDelete) {
            deleteElasticPoolList.add(this.elasticPools().deleteAsync(elasticPoolName));
        }
        Completable deletePools = Completable.merge(deleteElasticPoolList);
        return Completable.concat((Completable[])new Completable[]{deleteDBs, deletePools});
    }

    private Completable deleteFirewallRule() {
        ArrayList<Completable> deleteTaskList = new ArrayList<Completable>();
        for (String firewallRuleName : this.firewallRulesToDelete) {
            deleteTaskList.add(this.firewallRules().deleteAsync(firewallRuleName));
        }
        return Completable.merge(deleteTaskList);
    }
}

