/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.sql.ElasticPoolEditions;
import com.microsoft.azure.management.sql.RecommendedElasticPool;
import com.microsoft.azure.management.sql.RecommendedElasticPoolMetric;
import com.microsoft.azure.management.sql.SqlDatabase;
import com.microsoft.azure.management.sql.implementation.DatabaseInner;
import com.microsoft.azure.management.sql.implementation.RecommendedElasticPoolInner;
import com.microsoft.azure.management.sql.implementation.RecommendedElasticPoolMetricImpl;
import com.microsoft.azure.management.sql.implementation.RecommendedElasticPoolMetricInner;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import rx.Observable;

@LangDefinition
class RecommendedElasticPoolImpl
extends RefreshableWrapperImpl<RecommendedElasticPoolInner, RecommendedElasticPool>
implements RecommendedElasticPool {
    private final ResourceId resourceId = ResourceId.fromString((String)((RecommendedElasticPoolInner)((Object)this.inner())).id());
    private final SqlServerManager manager;

    protected RecommendedElasticPoolImpl(RecommendedElasticPoolInner innerObject, SqlServerManager manager) {
        super((Object)innerObject);
        this.manager = manager;
    }

    protected Observable<RecommendedElasticPoolInner> getInnerAsync() {
        return ((SqlManagementClientImpl)((Object)this.manager().inner())).recommendedElasticPools().getAsync(this.resourceGroupName(), this.sqlServerName(), this.name());
    }

    public SqlServerManager manager() {
        return this.manager;
    }

    @Override
    public String sqlServerName() {
        return this.resourceId.parent().name();
    }

    @Override
    public ElasticPoolEditions databaseEdition() {
        return ((RecommendedElasticPoolInner)((Object)this.inner())).databaseEdition();
    }

    @Override
    public double dtu() {
        return ((RecommendedElasticPoolInner)((Object)this.inner())).dtu();
    }

    @Override
    public double databaseDtuMin() {
        return ((RecommendedElasticPoolInner)((Object)this.inner())).databaseDtuMin();
    }

    @Override
    public double databaseDtuMax() {
        return ((RecommendedElasticPoolInner)((Object)this.inner())).databaseDtuMax();
    }

    @Override
    public double storageMB() {
        return ((RecommendedElasticPoolInner)((Object)this.inner())).storageMB();
    }

    @Override
    public DateTime observationPeriodStart() {
        return ((RecommendedElasticPoolInner)((Object)this.inner())).observationPeriodStart();
    }

    @Override
    public DateTime observationPeriodEnd() {
        return ((RecommendedElasticPoolInner)((Object)this.inner())).observationPeriodEnd();
    }

    @Override
    public double maxObservedDtu() {
        return ((RecommendedElasticPoolInner)((Object)this.inner())).maxObservedDtu();
    }

    @Override
    public double maxObservedStorageMB() {
        return ((RecommendedElasticPoolInner)((Object)this.inner())).maxObservedStorageMB();
    }

    @Override
    public List<SqlDatabase> databases() {
        ArrayList<SqlDatabase> databases = new ArrayList<SqlDatabase>();
        for (DatabaseInner databaseInner : ((RecommendedElasticPoolInner)((Object)this.inner())).databases()) {
            databases.add(new SqlDatabaseImpl(databaseInner.name(), databaseInner, this.manager()));
        }
        return databases;
    }

    @Override
    public List<SqlDatabase> listDatabases() {
        final RecommendedElasticPoolImpl self = this;
        PagedListConverter<DatabaseInner, SqlDatabase> converter = new PagedListConverter<DatabaseInner, SqlDatabase>(){

            public SqlDatabase typeConvert(DatabaseInner databaseInner) {
                return new SqlDatabaseImpl(databaseInner.name(), databaseInner, self.manager());
            }
        };
        return converter.convert(ReadableWrappersImpl.convertToPagedList(((SqlManagementClientImpl)((Object)this.manager().inner())).recommendedElasticPools().listDatabases(this.resourceGroupName(), this.sqlServerName(), this.name())));
    }

    @Override
    public SqlDatabase getDatabase(String databaseName) {
        DatabaseInner databaseInner = ((SqlManagementClientImpl)((Object)this.manager().inner())).recommendedElasticPools().getDatabases(this.resourceGroupName(), this.sqlServerName(), this.name(), databaseName);
        return new SqlDatabaseImpl(databaseInner.name(), databaseInner, this.manager());
    }

    @Override
    public List<RecommendedElasticPoolMetric> listMetrics() {
        PagedListConverter<RecommendedElasticPoolMetricInner, RecommendedElasticPoolMetric> converter = new PagedListConverter<RecommendedElasticPoolMetricInner, RecommendedElasticPoolMetric>(){

            public RecommendedElasticPoolMetric typeConvert(RecommendedElasticPoolMetricInner recommendedElasticPoolMetricInner) {
                return new RecommendedElasticPoolMetricImpl(recommendedElasticPoolMetricInner);
            }
        };
        return converter.convert(ReadableWrappersImpl.convertToPagedList(((SqlManagementClientImpl)((Object)this.manager().inner())).recommendedElasticPools().listMetrics(this.resourceGroupName(), this.sqlServerName(), this.name())));
    }

    public String name() {
        return ((RecommendedElasticPoolInner)((Object)this.inner())).name();
    }

    public String id() {
        return ((RecommendedElasticPoolInner)((Object)this.inner())).id();
    }

    public String resourceGroupName() {
        return this.resourceId.resourceGroupName();
    }
}

