/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.sql.SqlElasticPool;
import com.microsoft.azure.management.sql.SqlElasticPools;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.implementation.DatabasesImpl;
import com.microsoft.azure.management.sql.implementation.SqlElasticPoolsImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.List;
import rx.Completable;

@LangDefinition
public class ElasticPoolsImpl
implements SqlServer.ElasticPools {
    private final String resourceGroupName;
    private final String sqlServerName;
    private final SqlElasticPools.SqlElasticPoolsCreatable elasticPools;
    private final Region region;

    ElasticPoolsImpl(SqlServerManager manager, DatabasesImpl databasesImpl, String resourceGroupName, String sqlServerName, Region region) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.region = region;
        this.elasticPools = new SqlElasticPoolsImpl(manager, databasesImpl);
    }

    protected SqlElasticPools elasticPools() {
        return this.elasticPools;
    }

    @Override
    public SqlElasticPool get(String elasticPoolName) {
        return this.elasticPools.getBySqlServer(this.resourceGroupName, this.sqlServerName, elasticPoolName);
    }

    @Override
    public SqlElasticPool.DefinitionStages.Blank define(String elasticPoolName) {
        return this.elasticPools.definedWithSqlServer(this.resourceGroupName, this.sqlServerName, elasticPoolName, this.region);
    }

    @Override
    public List<SqlElasticPool> list() {
        return this.elasticPools.listBySqlServer(this.resourceGroupName, this.sqlServerName);
    }

    @Override
    public void delete(String elasticPoolName) {
        this.elasticPools.deleteByParent(this.resourceGroupName, this.sqlServerName, elasticPoolName);
    }

    @Override
    public Completable deleteAsync(String elasticPoolName) {
        return this.elasticPools.deleteByParentAsync(this.resourceGroupName, this.sqlServerName, elasticPoolName);
    }
}

