/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.sql.ElasticPoolEditions;
import com.microsoft.azure.management.sql.RecommendedElasticPool;
import com.microsoft.azure.management.sql.ServerMetric;
import com.microsoft.azure.management.sql.ServerVersion;
import com.microsoft.azure.management.sql.ServiceObjective;
import com.microsoft.azure.management.sql.SqlDatabase;
import com.microsoft.azure.management.sql.SqlElasticPool;
import com.microsoft.azure.management.sql.SqlFirewallRule;
import com.microsoft.azure.management.sql.implementation.ServerInner;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.List;
import java.util.Map;
import rx.Completable;

@Fluent
public interface SqlServer
extends GroupableResource<SqlServerManager, ServerInner>,
Refreshable<SqlServer>,
Updatable<Update> {
    public String fullyQualifiedDomainName();

    public ServerVersion version();

    public String administratorLogin();

    public FirewallRules firewallRules();

    public ElasticPools elasticPools();

    public Databases databases();

    public List<ServerMetric> listUsages();

    public List<ServiceObjective> listServiceObjectives();

    public ServiceObjective getServiceObjective(String var1);

    public Map<String, RecommendedElasticPool> listRecommendedElasticPools();

    public static interface UpdateStages {

        public static interface WithFirewallRule {
            public Update withNewFirewallRule(String var1);

            public Update withNewFirewallRule(String var1, String var2);

            public Update withNewFirewallRule(String var1, String var2, String var3);

            public Update withoutFirewallRule(String var1);
        }

        public static interface WithDatabase {
            public Update withNewDatabase(String var1);

            public Update withoutDatabase(String var1);
        }

        public static interface WithElasticPool {
            public Update withNewElasticPool(String var1, ElasticPoolEditions var2, String ... var3);

            public Update withNewElasticPool(String var1, ElasticPoolEditions var2);

            public Update withoutElasticPool(String var1);
        }

        public static interface WithAdministratorPassword {
            public Update withAdministratorPassword(String var1);
        }
    }

    public static interface Update
    extends Appliable<SqlServer>,
    UpdateStages.WithAdministratorPassword,
    UpdateStages.WithElasticPool,
    UpdateStages.WithDatabase,
    UpdateStages.WithFirewallRule {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<SqlServer>,
        Resource.DefinitionWithTags<WithCreate>,
        WithElasticPool,
        WithDatabase,
        WithFirewallRule {
        }

        public static interface WithFirewallRule {
            public WithCreate withNewFirewallRule(String var1);

            public WithCreate withNewFirewallRule(String var1, String var2);

            public WithCreate withNewFirewallRule(String var1, String var2, String var3);
        }

        public static interface WithDatabase {
            public WithCreate withNewDatabase(String var1);
        }

        public static interface WithElasticPool {
            public WithCreate withNewElasticPool(String var1, ElasticPoolEditions var2, String ... var3);

            public WithCreate withNewElasticPool(String var1, ElasticPoolEditions var2);
        }

        public static interface WithAdministratorPassword {
            public WithCreate withAdministratorPassword(String var1);
        }

        public static interface WithAdministratorLogin {
            public WithAdministratorPassword withAdministratorLogin(String var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithAdministratorLogin> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithAdministratorLogin,
    DefinitionStages.WithAdministratorPassword,
    DefinitionStages.WithElasticPool,
    DefinitionStages.WithDatabase,
    DefinitionStages.WithFirewallRule,
    DefinitionStages.WithCreate {
    }

    public static interface Databases {
        public SqlDatabase get(String var1);

        public SqlDatabase.DefinitionStages.Blank define(String var1);

        public List<SqlDatabase> list();

        public void delete(String var1);

        public Completable deleteAsync(String var1);
    }

    public static interface ElasticPools {
        public SqlElasticPool get(String var1);

        public SqlElasticPool.DefinitionStages.Blank define(String var1);

        public List<SqlElasticPool> list();

        public void delete(String var1);

        public Completable deleteAsync(String var1);
    }

    public static interface FirewallRules {
        public SqlFirewallRule get(String var1);

        public SqlFirewallRule.DefinitionStages.Blank define(String var1);

        public List<SqlFirewallRule> list();

        public void delete(String var1);

        public Completable deleteAsync(String var1);
    }
}

