/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.resources.fluentcore.arm.models.IndependentChildResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.sql.ElasticPoolActivity;
import com.microsoft.azure.management.sql.ElasticPoolDatabaseActivity;
import com.microsoft.azure.management.sql.ElasticPoolEditions;
import com.microsoft.azure.management.sql.ElasticPoolState;
import com.microsoft.azure.management.sql.SqlDatabase;
import com.microsoft.azure.management.sql.implementation.ElasticPoolInner;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.List;
import org.joda.time.DateTime;

@Fluent
public interface SqlElasticPool
extends IndependentChildResource<SqlServerManager, ElasticPoolInner>,
Refreshable<SqlElasticPool>,
Updatable<Update> {
    public String sqlServerName();

    public DateTime creationDate();

    public ElasticPoolState state();

    public ElasticPoolEditions edition();

    public int dtu();

    public int databaseDtuMax();

    public int databaseDtuMin();

    public int storageMB();

    public List<ElasticPoolActivity> listActivities();

    public List<ElasticPoolDatabaseActivity> listDatabaseActivities();

    public List<SqlDatabase> listDatabases();

    public SqlDatabase getDatabase(String var1);

    public void delete();

    public static interface UpdateStages {

        public static interface WithDatabase {
            public Update withNewDatabase(String var1);

            public Update withExistingDatabase(String var1);

            public Update withExistingDatabase(SqlDatabase var1);
        }

        public static interface WithStorageCapacity {
            public Update withStorageCapacity(int var1);
        }

        public static interface WithDtu {
            public Update withDtu(int var1);
        }

        public static interface WithDatabaseDtuMax {
            public Update withDatabaseDtuMax(int var1);
        }

        public static interface WithDatabaseDtuMin {
            public Update withDatabaseDtuMin(int var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithDatabaseDtuMax,
    UpdateStages.WithDatabaseDtuMin,
    UpdateStages.WithDtu,
    UpdateStages.WithStorageCapacity,
    UpdateStages.WithDatabase,
    Appliable<SqlElasticPool> {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<SqlElasticPool>,
        Resource.DefinitionWithTags<WithCreate>,
        WithDatabaseDtuMin,
        WithDatabaseDtuMax,
        WithDtu,
        WithStorageCapacity,
        WithDatabase {
        }

        public static interface WithDatabase {
            public WithCreate withNewDatabase(String var1);

            public WithCreate withExistingDatabase(String var1);

            public WithCreate withExistingDatabase(SqlDatabase var1);
        }

        public static interface WithStorageCapacity {
            public WithCreate withStorageCapacity(int var1);
        }

        public static interface WithDtu {
            public WithCreate withDtu(int var1);
        }

        public static interface WithDatabaseDtuMax {
            public WithCreate withDatabaseDtuMax(int var1);
        }

        public static interface WithDatabaseDtuMin {
            public WithCreate withDatabaseDtuMin(int var1);
        }

        public static interface WithEdition {
            public WithCreate withEdition(ElasticPoolEditions var1);
        }

        public static interface Blank
        extends WithEdition {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithEdition,
    DefinitionStages.WithCreate {
    }
}

