/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.dag.FunctionalTaskItem;
import com.microsoft.azure.management.resources.fluentcore.dag.TaskGroup;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.sql.AuthenticationType;
import com.microsoft.azure.management.sql.CreateMode;
import com.microsoft.azure.management.sql.DatabaseEdition;
import com.microsoft.azure.management.sql.DatabaseMetric;
import com.microsoft.azure.management.sql.DatabaseUpdate;
import com.microsoft.azure.management.sql.ImportRequest;
import com.microsoft.azure.management.sql.ReplicationLink;
import com.microsoft.azure.management.sql.RestorePoint;
import com.microsoft.azure.management.sql.SampleName;
import com.microsoft.azure.management.sql.ServiceObjectiveName;
import com.microsoft.azure.management.sql.ServiceTierAdvisor;
import com.microsoft.azure.management.sql.SqlDatabase;
import com.microsoft.azure.management.sql.SqlDatabaseAutomaticTuning;
import com.microsoft.azure.management.sql.SqlDatabaseBasicStorage;
import com.microsoft.azure.management.sql.SqlDatabaseMetric;
import com.microsoft.azure.management.sql.SqlDatabaseMetricDefinition;
import com.microsoft.azure.management.sql.SqlDatabaseOperations;
import com.microsoft.azure.management.sql.SqlDatabasePremiumServiceObjective;
import com.microsoft.azure.management.sql.SqlDatabasePremiumStorage;
import com.microsoft.azure.management.sql.SqlDatabaseStandardServiceObjective;
import com.microsoft.azure.management.sql.SqlDatabaseStandardStorage;
import com.microsoft.azure.management.sql.SqlDatabaseThreatDetectionPolicy;
import com.microsoft.azure.management.sql.SqlDatabaseUsageMetric;
import com.microsoft.azure.management.sql.SqlElasticPool;
import com.microsoft.azure.management.sql.SqlRestorableDroppedDatabase;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.SqlSyncGroupOperations;
import com.microsoft.azure.management.sql.SqlWarehouse;
import com.microsoft.azure.management.sql.StorageKeyType;
import com.microsoft.azure.management.sql.TransparentDataEncryption;
import com.microsoft.azure.management.sql.implementation.DatabaseAutomaticTuningInner;
import com.microsoft.azure.management.sql.implementation.DatabaseInner;
import com.microsoft.azure.management.sql.implementation.DatabaseSecurityAlertPolicyInner;
import com.microsoft.azure.management.sql.implementation.DatabaseUsageInner;
import com.microsoft.azure.management.sql.implementation.ImportExportResponseInner;
import com.microsoft.azure.management.sql.implementation.MetricDefinitionInner;
import com.microsoft.azure.management.sql.implementation.MetricInner;
import com.microsoft.azure.management.sql.implementation.ReplicationLinkImpl;
import com.microsoft.azure.management.sql.implementation.ReplicationLinkInner;
import com.microsoft.azure.management.sql.implementation.RestorePointImpl;
import com.microsoft.azure.management.sql.implementation.RestorePointInner;
import com.microsoft.azure.management.sql.implementation.ServiceTierAdvisorImpl;
import com.microsoft.azure.management.sql.implementation.ServiceTierAdvisorInner;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseAutomaticTuningImpl;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseExportRequestImpl;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseImportRequestImpl;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseMetricDefinitionImpl;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseMetricImpl;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseThreatDetectionPolicyImpl;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseUsageMetricImpl;
import com.microsoft.azure.management.sql.implementation.SqlElasticPoolForDatabaseImpl;
import com.microsoft.azure.management.sql.implementation.SqlElasticPoolsAsExternalChildResourcesImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import com.microsoft.azure.management.sql.implementation.SqlSyncGroupOperationsImpl;
import com.microsoft.azure.management.sql.implementation.SqlWarehouseImpl;
import com.microsoft.azure.management.sql.implementation.TransparentDataEncryptionImpl;
import com.microsoft.azure.management.sql.implementation.TransparentDataEncryptionInner;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.azure.management.storage.StorageAccountKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.DateTime;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class SqlDatabaseImpl
extends ExternalChildResourceImpl<SqlDatabase, DatabaseInner, SqlServerImpl, SqlServer>
implements SqlDatabase,
SqlDatabase.SqlDatabaseDefinition<SqlServer.DefinitionStages.WithCreate>,
SqlDatabase.DefinitionStages.WithExistingDatabaseAfterElasticPool<SqlServer.DefinitionStages.WithCreate>,
SqlDatabase.DefinitionStages.WithStorageKeyAfterElasticPool<SqlServer.DefinitionStages.WithCreate>,
SqlDatabase.DefinitionStages.WithAuthenticationAfterElasticPool<SqlServer.DefinitionStages.WithCreate>,
SqlDatabase.DefinitionStages.WithRestorePointDatabaseAfterElasticPool<SqlServer.DefinitionStages.WithCreate>,
SqlDatabase.Update,
SqlDatabaseOperations.DefinitionStages.WithExistingDatabaseAfterElasticPool,
SqlDatabaseOperations.DefinitionStages.WithStorageKeyAfterElasticPool,
SqlDatabaseOperations.DefinitionStages.WithAuthenticationAfterElasticPool,
SqlDatabaseOperations.DefinitionStages.WithRestorePointDatabaseAfterElasticPool,
SqlDatabaseOperations.DefinitionStages.WithCreateAfterElasticPoolOptions,
SqlDatabaseOperations.SqlDatabaseOperationsDefinition {
    private SqlElasticPoolsAsExternalChildResourcesImpl sqlElasticPools;
    protected SqlServerManager sqlServerManager;
    protected String resourceGroupName;
    protected String sqlServerName;
    protected String sqlServerLocation;
    private boolean isPatchUpdate;
    private ImportRequest importRequestInner;
    private SqlSyncGroupOperationsImpl syncGroups;

    SqlDatabaseImpl(String name, SqlServerImpl parent, DatabaseInner innerObject, SqlServerManager sqlServerManager) {
        super(name, (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.name();
        this.sqlServerLocation = parent.regionName();
        this.sqlElasticPools = null;
        this.isPatchUpdate = false;
        this.importRequestInner = null;
    }

    SqlDatabaseImpl(String resourceGroupName, String sqlServerName, String sqlServerLocation, String name, DatabaseInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerLocation = sqlServerLocation;
        this.sqlElasticPools = new SqlElasticPoolsAsExternalChildResourcesImpl(this.sqlServerManager, "SqlElasticPool");
        this.isPatchUpdate = false;
        this.importRequestInner = null;
    }

    SqlDatabaseImpl(TaskGroup.HasTaskGroup parentSqlElasticPool, String name, DatabaseInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(parentSqlElasticPool);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.sqlElasticPools = new SqlElasticPoolsAsExternalChildResourcesImpl(this.sqlServerManager, "SqlElasticPool");
        this.isPatchUpdate = false;
        this.importRequestInner = null;
    }

    public String id() {
        return ((DatabaseInner)((Object)this.inner())).id();
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String collation() {
        return ((DatabaseInner)((Object)this.inner())).collation();
    }

    @Override
    public DateTime creationDate() {
        return ((DatabaseInner)((Object)this.inner())).creationDate();
    }

    @Override
    public UUID currentServiceObjectiveId() {
        return ((DatabaseInner)((Object)this.inner())).currentServiceObjectiveId();
    }

    @Override
    public String databaseId() {
        return ((DatabaseInner)((Object)this.inner())).databaseId().toString();
    }

    @Override
    public DateTime earliestRestoreDate() {
        return ((DatabaseInner)((Object)this.inner())).earliestRestoreDate();
    }

    @Override
    public DatabaseEdition edition() {
        return ((DatabaseInner)((Object)this.inner())).edition();
    }

    @Override
    public UUID requestedServiceObjectiveId() {
        return ((DatabaseInner)((Object)this.inner())).requestedServiceObjectiveId();
    }

    @Override
    public long maxSizeBytes() {
        return Long.valueOf(((DatabaseInner)((Object)this.inner())).maxSizeBytes());
    }

    @Override
    public ServiceObjectiveName requestedServiceObjectiveName() {
        return ((DatabaseInner)((Object)this.inner())).requestedServiceObjectiveName();
    }

    @Override
    public ServiceObjectiveName serviceLevelObjective() {
        return ((DatabaseInner)((Object)this.inner())).serviceLevelObjective();
    }

    @Override
    public String status() {
        return ((DatabaseInner)((Object)this.inner())).status();
    }

    @Override
    public String elasticPoolName() {
        return ((DatabaseInner)((Object)this.inner())).elasticPoolName();
    }

    @Override
    public String defaultSecondaryLocation() {
        return ((DatabaseInner)((Object)this.inner())).defaultSecondaryLocation();
    }

    @Override
    public boolean isDataWarehouse() {
        return ((DatabaseInner)((Object)this.inner())).edition().toString().equalsIgnoreCase(DatabaseEdition.DATA_WAREHOUSE.toString());
    }

    @Override
    public SqlWarehouse asWarehouse() {
        if (this.isDataWarehouse()) {
            if (this.parent() != null) {
                return new SqlWarehouseImpl(this.name(), (SqlServerImpl)this.parent(), (DatabaseInner)((Object)this.inner()), this.sqlServerManager);
            }
            return new SqlWarehouseImpl(this.resourceGroupName, this.sqlServerName, this.sqlServerLocation, this.name(), (DatabaseInner)((Object)this.inner()), this.sqlServerManager);
        }
        return null;
    }

    @Override
    public List<RestorePoint> listRestorePoints() {
        ArrayList<RestorePointImpl> restorePoints = new ArrayList<RestorePointImpl>();
        List<RestorePointInner> restorePointInners = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).restorePoints().listByDatabase(this.resourceGroupName, this.sqlServerName, this.name());
        if (restorePointInners != null) {
            for (RestorePointInner inner : restorePointInners) {
                restorePoints.add(new RestorePointImpl(this.resourceGroupName, this.sqlServerName, inner));
            }
        }
        return Collections.unmodifiableList(restorePoints);
    }

    @Override
    public Observable<RestorePoint> listRestorePointsAsync() {
        final SqlDatabaseImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).restorePoints().listByDatabaseAsync(this.resourceGroupName, this.sqlServerName, this.name()).flatMap((Func1)new Func1<List<RestorePointInner>, Observable<RestorePointInner>>(){

            public Observable<RestorePointInner> call(List<RestorePointInner> restorePointInners) {
                return Observable.from(restorePointInners);
            }
        }).map((Func1)new Func1<RestorePointInner, RestorePoint>(){

            public RestorePoint call(RestorePointInner restorePointInner) {
                return new RestorePointImpl(self.resourceGroupName, self.sqlServerName, restorePointInner);
            }
        });
    }

    @Override
    public Map<String, ReplicationLink> listReplicationLinks() {
        HashMap<String, ReplicationLinkImpl> replicationLinkMap = new HashMap<String, ReplicationLinkImpl>();
        List<ReplicationLinkInner> replicationLinkInners = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).replicationLinks().listByDatabase(this.resourceGroupName, this.sqlServerName, this.name());
        if (replicationLinkInners != null) {
            for (ReplicationLinkInner inner : replicationLinkInners) {
                replicationLinkMap.put(inner.name(), new ReplicationLinkImpl(this.resourceGroupName, this.sqlServerName, inner, this.sqlServerManager));
            }
        }
        return Collections.unmodifiableMap(replicationLinkMap);
    }

    @Override
    public Observable<ReplicationLink> listReplicationLinksAsync() {
        final SqlDatabaseImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).replicationLinks().listByDatabaseAsync(this.resourceGroupName, this.sqlServerName, this.name()).flatMap((Func1)new Func1<List<ReplicationLinkInner>, Observable<ReplicationLinkInner>>(){

            public Observable<ReplicationLinkInner> call(List<ReplicationLinkInner> replicationLinkInners) {
                return Observable.from(replicationLinkInners);
            }
        }).map((Func1)new Func1<ReplicationLinkInner, ReplicationLink>(){

            public ReplicationLink call(ReplicationLinkInner replicationLinkInner) {
                return new ReplicationLinkImpl(self.resourceGroupName, self.sqlServerName, replicationLinkInner, self.sqlServerManager);
            }
        });
    }

    @Override
    public SqlDatabaseExportRequestImpl exportTo(String storageUri) {
        return new SqlDatabaseExportRequestImpl(this, this.sqlServerManager).exportTo(storageUri);
    }

    @Override
    public SqlDatabaseExportRequestImpl exportTo(StorageAccount storageAccount, String containerName, String fileName) {
        Objects.requireNonNull(storageAccount);
        return new SqlDatabaseExportRequestImpl(this, this.sqlServerManager).exportTo(storageAccount, containerName, fileName);
    }

    @Override
    public SqlDatabaseExportRequestImpl exportTo(Creatable<StorageAccount> storageAccountCreatable, String containerName, String fileName) {
        Objects.requireNonNull(storageAccountCreatable);
        return new SqlDatabaseExportRequestImpl(this, this.sqlServerManager).exportTo((Creatable)storageAccountCreatable, containerName, fileName);
    }

    @Override
    public SqlDatabaseImportRequestImpl importBacpac(String storageUri) {
        return new SqlDatabaseImportRequestImpl(this, this.sqlServerManager).importFrom(storageUri);
    }

    @Override
    public SqlDatabaseImportRequestImpl importBacpac(StorageAccount storageAccount, String containerName, String fileName) {
        Objects.requireNonNull(storageAccount);
        return new SqlDatabaseImportRequestImpl(this, this.sqlServerManager).importFrom(storageAccount, containerName, fileName);
    }

    @Override
    public SqlDatabaseThreatDetectionPolicy.DefinitionStages.Blank defineThreatDetectionPolicy(String policyName) {
        return new SqlDatabaseThreatDetectionPolicyImpl(policyName, this, new DatabaseSecurityAlertPolicyInner(), this.sqlServerManager);
    }

    @Override
    public SqlDatabaseThreatDetectionPolicy getThreatDetectionPolicy() {
        DatabaseSecurityAlertPolicyInner policyInner = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databaseThreatDetectionPolicies().get(this.resourceGroupName, this.sqlServerName, this.name());
        return policyInner != null ? new SqlDatabaseThreatDetectionPolicyImpl(policyInner.name(), this, policyInner, this.sqlServerManager) : null;
    }

    @Override
    public SqlDatabaseAutomaticTuning getDatabaseAutomaticTuning() {
        DatabaseAutomaticTuningInner databaseAutomaticTuningInner = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databaseAutomaticTunings().get(this.resourceGroupName, this.sqlServerName, this.name());
        return databaseAutomaticTuningInner != null ? new SqlDatabaseAutomaticTuningImpl(this, databaseAutomaticTuningInner) : null;
    }

    @Override
    public List<SqlDatabaseUsageMetric> listUsageMetrics() {
        ArrayList<SqlDatabaseUsageMetricImpl> databaseUsageMetrics = new ArrayList<SqlDatabaseUsageMetricImpl>();
        List<DatabaseUsageInner> databaseUsageInners = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databaseUsages().listByDatabase(this.resourceGroupName, this.sqlServerName, this.name());
        if (databaseUsageInners != null) {
            for (DatabaseUsageInner inner : databaseUsageInners) {
                databaseUsageMetrics.add(new SqlDatabaseUsageMetricImpl(inner));
            }
        }
        return Collections.unmodifiableList(databaseUsageMetrics);
    }

    @Override
    public Observable<SqlDatabaseUsageMetric> listUsageMetricsAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databaseUsages().listByDatabaseAsync(this.resourceGroupName, this.sqlServerName, this.name()).flatMap((Func1)new Func1<List<DatabaseUsageInner>, Observable<DatabaseUsageInner>>(){

            public Observable<DatabaseUsageInner> call(List<DatabaseUsageInner> databaseUsageInners) {
                return Observable.from(databaseUsageInners);
            }
        }).map((Func1)new Func1<DatabaseUsageInner, SqlDatabaseUsageMetric>(){

            public SqlDatabaseUsageMetric call(DatabaseUsageInner databaseUsageInner) {
                return new SqlDatabaseUsageMetricImpl(databaseUsageInner);
            }
        });
    }

    @Override
    public SqlDatabase rename(String newDatabaseName) {
        ResourceId resourceId = ResourceId.fromString((String)this.id());
        String newId = resourceId.parent().id() + "/databases/" + newDatabaseName;
        ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databases().rename(this.resourceGroupName, this.sqlServerName, this.name(), newId);
        return (SqlDatabase)this.sqlServerManager.sqlServers().databases().getBySqlServer(this.resourceGroupName, this.sqlServerName, newDatabaseName);
    }

    @Override
    public Observable<SqlDatabase> renameAsync(final String newDatabaseName) {
        final SqlDatabaseImpl self = this;
        ResourceId resourceId = ResourceId.fromString((String)this.id());
        String newId = resourceId.parent().id() + "/databases/" + newDatabaseName;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databases().renameAsync(this.resourceGroupName, this.sqlServerName, self.name(), newId).flatMap((Func1)new Func1<Void, Observable<SqlDatabase>>(){

            public Observable<SqlDatabase> call(Void aVoid) {
                return self.sqlServerManager.sqlServers().databases().getBySqlServerAsync(self.resourceGroupName, self.sqlServerName, newDatabaseName);
            }
        });
    }

    @Override
    public List<DatabaseMetric> listUsages() {
        return Collections.unmodifiableList(new ArrayList());
    }

    @Override
    public List<SqlDatabaseMetric> listMetrics(String filter) {
        ArrayList<SqlDatabaseMetricImpl> sqlDatabaseMetrics = new ArrayList<SqlDatabaseMetricImpl>();
        List<MetricInner> metricInners = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databases().listMetrics(this.resourceGroupName, this.sqlServerName, this.name(), filter);
        if (metricInners != null) {
            for (MetricInner metricInner : metricInners) {
                sqlDatabaseMetrics.add(new SqlDatabaseMetricImpl(metricInner));
            }
        }
        return Collections.unmodifiableList(sqlDatabaseMetrics);
    }

    @Override
    public Observable<SqlDatabaseMetric> listMetricsAsync(String filter) {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databases().listMetricsAsync(this.resourceGroupName, this.sqlServerName, this.name(), filter).flatMap((Func1)new Func1<List<MetricInner>, Observable<MetricInner>>(){

            public Observable<MetricInner> call(List<MetricInner> metricInners) {
                return Observable.from(metricInners);
            }
        }).map((Func1)new Func1<MetricInner, SqlDatabaseMetric>(){

            public SqlDatabaseMetric call(MetricInner metricInner) {
                return new SqlDatabaseMetricImpl(metricInner);
            }
        });
    }

    @Override
    public List<SqlDatabaseMetricDefinition> listMetricDefinitions() {
        ArrayList<SqlDatabaseMetricDefinitionImpl> sqlDatabaseMetricDefinitions = new ArrayList<SqlDatabaseMetricDefinitionImpl>();
        List<MetricDefinitionInner> metricDefinitionInners = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databases().listMetricDefinitions(this.resourceGroupName, this.sqlServerName, this.name());
        if (metricDefinitionInners != null) {
            for (MetricDefinitionInner metricDefinitionInner : metricDefinitionInners) {
                sqlDatabaseMetricDefinitions.add(new SqlDatabaseMetricDefinitionImpl(metricDefinitionInner));
            }
        }
        return Collections.unmodifiableList(sqlDatabaseMetricDefinitions);
    }

    @Override
    public Observable<SqlDatabaseMetricDefinition> listMetricDefinitionsAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databases().listMetricDefinitionsAsync(this.resourceGroupName, this.sqlServerName, this.name()).flatMap((Func1)new Func1<List<MetricDefinitionInner>, Observable<MetricDefinitionInner>>(){

            public Observable<MetricDefinitionInner> call(List<MetricDefinitionInner> metricDefinitionInners) {
                return Observable.from(metricDefinitionInners);
            }
        }).map((Func1)new Func1<MetricDefinitionInner, SqlDatabaseMetricDefinition>(){

            public SqlDatabaseMetricDefinition call(MetricDefinitionInner metricDefinitionInner) {
                return new SqlDatabaseMetricDefinitionImpl(metricDefinitionInner);
            }
        });
    }

    @Override
    public TransparentDataEncryption getTransparentDataEncryption() {
        TransparentDataEncryptionInner transparentDataEncryptionInner = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).transparentDataEncryptions().get(this.resourceGroupName, this.sqlServerName, this.name());
        return new TransparentDataEncryptionImpl(this.resourceGroupName, this.sqlServerName, transparentDataEncryptionInner, this.sqlServerManager);
    }

    @Override
    public Observable<TransparentDataEncryption> getTransparentDataEncryptionAsync() {
        final SqlDatabaseImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).transparentDataEncryptions().getAsync(this.resourceGroupName, this.sqlServerName, this.name()).map((Func1)new Func1<TransparentDataEncryptionInner, TransparentDataEncryption>(){

            public TransparentDataEncryption call(TransparentDataEncryptionInner transparentDataEncryptionInner) {
                return new TransparentDataEncryptionImpl(self.resourceGroupName, self.sqlServerName, transparentDataEncryptionInner, self.sqlServerManager);
            }
        });
    }

    @Override
    public Map<String, ServiceTierAdvisor> listServiceTierAdvisors() {
        HashMap<String, ServiceTierAdvisorImpl> serviceTierAdvisorMap = new HashMap<String, ServiceTierAdvisorImpl>();
        List<ServiceTierAdvisorInner> serviceTierAdvisorInners = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).serviceTierAdvisors().listByDatabase(this.resourceGroupName, this.sqlServerName, this.name());
        if (serviceTierAdvisorInners != null) {
            for (ServiceTierAdvisorInner serviceTierAdvisorInner : serviceTierAdvisorInners) {
                serviceTierAdvisorMap.put(serviceTierAdvisorInner.name(), new ServiceTierAdvisorImpl(this.resourceGroupName, this.sqlServerName, serviceTierAdvisorInner, this.sqlServerManager));
            }
        }
        return Collections.unmodifiableMap(serviceTierAdvisorMap);
    }

    @Override
    public Observable<ServiceTierAdvisor> listServiceTierAdvisorsAsync() {
        final SqlDatabaseImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).serviceTierAdvisors().listByDatabaseAsync(this.resourceGroupName, this.sqlServerName, this.name()).flatMap((Func1)new Func1<List<ServiceTierAdvisorInner>, Observable<ServiceTierAdvisorInner>>(){

            public Observable<ServiceTierAdvisorInner> call(List<ServiceTierAdvisorInner> serviceTierAdvisorInners) {
                return Observable.from(serviceTierAdvisorInners);
            }
        }).map((Func1)new Func1<ServiceTierAdvisorInner, ServiceTierAdvisor>(){

            public ServiceTierAdvisor call(ServiceTierAdvisorInner serviceTierAdvisorInner) {
                return new ServiceTierAdvisorImpl(self.resourceGroupName, self.sqlServerName, serviceTierAdvisorInner, self.sqlServerManager);
            }
        });
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId((String)this.id());
    }

    @Override
    public String regionName() {
        return ((DatabaseInner)((Object)this.inner())).location();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public SqlSyncGroupOperations.SqlSyncGroupActionsDefinition syncGroups() {
        if (this.syncGroups == null) {
            this.syncGroups = new SqlSyncGroupOperationsImpl(this, this.sqlServerManager);
        }
        return this.syncGroups;
    }

    SqlDatabaseImpl withPatchUpdate() {
        this.isPatchUpdate = true;
        return this;
    }

    protected Observable<DatabaseInner> getInnerAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databases().getAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    void addParentDependency(TaskGroup.HasTaskGroup parentDependency) {
        this.addDependency(parentDependency);
    }

    public void beforeGroupCreateOrUpdate() {
        if (this.importRequestInner != null && this.elasticPoolName() != null) {
            final SqlDatabaseImpl self = this;
            final String epName = this.elasticPoolName();
            this.addPostRunDependent(new FunctionalTaskItem(){

                public Observable<Indexable> call(final FunctionalTaskItem.Context context) {
                    self.importRequestInner = null;
                    self.withExistingElasticPool(epName);
                    return self.createResourceAsync().flatMap((Func1)new Func1<SqlDatabase, Observable<Indexable>>(){

                        public Observable<Indexable> call(SqlDatabase sqlDatabase) {
                            return context.voidObservable();
                        }
                    });
                }
            });
        }
    }

    public Observable<SqlDatabase> createResourceAsync() {
        final SqlDatabaseImpl self = this;
        ((DatabaseInner)((Object)this.inner())).withLocation(this.sqlServerLocation);
        if (this.importRequestInner != null) {
            this.importRequestInner.withDatabaseName(this.name());
            if (this.importRequestInner.edition() == null) {
                this.importRequestInner.withEdition(((DatabaseInner)((Object)this.inner())).edition());
            }
            if (this.importRequestInner.serviceObjectiveName() == null) {
                this.importRequestInner.withServiceObjectiveName(((DatabaseInner)((Object)this.inner())).requestedServiceObjectiveName());
            }
            if (this.importRequestInner.maxSizeBytes() == null) {
                this.importRequestInner.withMaxSizeBytes(((DatabaseInner)((Object)this.inner())).maxSizeBytes());
            }
            return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databases().importMethodAsync(this.resourceGroupName, this.sqlServerName, this.importRequestInner).flatMap((Func1)new Func1<ImportExportResponseInner, Observable<SqlDatabase>>(){

                public Observable<SqlDatabase> call(ImportExportResponseInner importExportResponseInner) {
                    if (self.elasticPoolName() != null) {
                        self.importRequestInner = null;
                        return self.withExistingElasticPool(self.elasticPoolName()).withPatchUpdate().updateResourceAsync();
                    }
                    return self.refreshAsync();
                }
            });
        }
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databases().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, this.name(), (DatabaseInner)((Object)this.inner())).map((Func1)new Func1<DatabaseInner, SqlDatabase>(){

            public SqlDatabase call(DatabaseInner inner) {
                self.setInner((Object)inner);
                return self;
            }
        });
    }

    public Observable<SqlDatabase> updateResourceAsync() {
        if (this.isPatchUpdate) {
            final SqlDatabaseImpl self = this;
            DatabaseUpdate databaseUpdateInner = new DatabaseUpdate().withTags(((DatabaseInner)((Object)self.inner())).getTags()).withCollation(((DatabaseInner)((Object)self.inner())).collation()).withSourceDatabaseId(((DatabaseInner)((Object)self.inner())).sourceDatabaseId()).withCreateMode(((DatabaseInner)((Object)self.inner())).createMode()).withEdition(((DatabaseInner)((Object)self.inner())).edition()).withRequestedServiceObjectiveName(((DatabaseInner)((Object)this.inner())).requestedServiceObjectiveName()).withMaxSizeBytes(((DatabaseInner)((Object)this.inner())).maxSizeBytes()).withElasticPoolName(((DatabaseInner)((Object)this.inner())).elasticPoolName());
            return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databases().updateAsync(this.resourceGroupName, this.sqlServerName, this.name(), databaseUpdateInner).map((Func1)new Func1<DatabaseInner, SqlDatabase>(){

                public SqlDatabase call(DatabaseInner inner) {
                    self.setInner((Object)inner);
                    self.isPatchUpdate = false;
                    return self;
                }
            });
        }
        return this.createResourceAsync();
    }

    public SqlDatabaseImpl update() {
        super.prepareUpdate();
        return this;
    }

    public Completable afterPostRunAsync(boolean isGroupFaulted) {
        if (this.sqlElasticPools != null) {
            this.sqlElasticPools.clear();
        }
        this.importRequestInner = null;
        return Completable.complete();
    }

    public Observable<Void> deleteResourceAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databases().deleteAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    @Override
    public void delete() {
        ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databases().delete(this.resourceGroupName, this.sqlServerName, this.name());
    }

    @Override
    public Completable deleteAsync() {
        return this.deleteResourceAsync().toCompletable();
    }

    @Override
    public SqlDatabaseImpl withExistingSqlServer(String resourceGroupName, String sqlServerName, String sqlServerLocation) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerLocation = sqlServerLocation;
        return this;
    }

    @Override
    public SqlDatabaseImpl withExistingSqlServer(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        this.resourceGroupName = sqlServer.resourceGroupName();
        this.sqlServerName = sqlServer.name();
        this.sqlServerLocation = sqlServer.regionName();
        return this;
    }

    public SqlServerImpl attach() {
        return (SqlServerImpl)this.parent();
    }

    @Override
    public SqlDatabaseImpl withoutElasticPool() {
        ((DatabaseInner)((Object)this.inner())).withElasticPoolName(null);
        ((DatabaseInner)((Object)this.inner())).withRequestedServiceObjectiveId(null);
        ((DatabaseInner)((Object)this.inner())).withRequestedServiceObjectiveName(ServiceObjectiveName.S0);
        return this;
    }

    @Override
    public SqlDatabaseImpl withExistingElasticPool(String elasticPoolName) {
        ((DatabaseInner)((Object)this.inner())).withEdition(null);
        ((DatabaseInner)((Object)this.inner())).withRequestedServiceObjectiveId(null);
        ((DatabaseInner)((Object)this.inner())).withRequestedServiceObjectiveName(null);
        ((DatabaseInner)((Object)this.inner())).withElasticPoolName(elasticPoolName);
        return this;
    }

    @Override
    public SqlDatabaseImpl withExistingElasticPool(SqlElasticPool sqlElasticPool) {
        Objects.requireNonNull(sqlElasticPool);
        ((DatabaseInner)((Object)this.inner())).withEdition(null);
        ((DatabaseInner)((Object)this.inner())).withRequestedServiceObjectiveId(null);
        ((DatabaseInner)((Object)this.inner())).withRequestedServiceObjectiveName(null);
        ((DatabaseInner)((Object)this.inner())).withElasticPoolName(sqlElasticPool.name());
        return this;
    }

    @Override
    public SqlDatabaseImpl withNewElasticPool(Creatable<SqlElasticPool> sqlElasticPool) {
        Objects.requireNonNull(sqlElasticPool);
        ((DatabaseInner)((Object)this.inner())).withEdition(null);
        ((DatabaseInner)((Object)this.inner())).withRequestedServiceObjectiveId(null);
        ((DatabaseInner)((Object)this.inner())).withRequestedServiceObjectiveName(null);
        ((DatabaseInner)((Object)this.inner())).withElasticPoolName(sqlElasticPool.name());
        this.addDependency(sqlElasticPool);
        return this;
    }

    public SqlElasticPoolForDatabaseImpl defineElasticPool(String elasticPoolName) {
        if (this.sqlElasticPools == null) {
            this.sqlElasticPools = new SqlElasticPoolsAsExternalChildResourcesImpl(this.taskGroup(), this.sqlServerManager, "SqlElasticPool");
        }
        ((DatabaseInner)((Object)this.inner())).withEdition(null);
        ((DatabaseInner)((Object)this.inner())).withRequestedServiceObjectiveId(null);
        ((DatabaseInner)((Object)this.inner())).withRequestedServiceObjectiveName(null);
        ((DatabaseInner)((Object)this.inner())).withElasticPoolName(elasticPoolName);
        return new SqlElasticPoolForDatabaseImpl(this, this.sqlElasticPools.defineIndependentElasticPool(elasticPoolName).withExistingSqlServer(this.resourceGroupName, this.sqlServerName, this.sqlServerLocation));
    }

    @Override
    public SqlDatabaseImpl fromRestorableDroppedDatabase(SqlRestorableDroppedDatabase restorableDroppedDatabase) {
        Objects.requireNonNull(restorableDroppedDatabase);
        return this.withSourceDatabase(restorableDroppedDatabase.id()).withMode(CreateMode.RESTORE);
    }

    private void initializeImportRequestInner() {
        this.importRequestInner = new ImportRequest();
        if (this.elasticPoolName() != null) {
            this.importRequestInner.withEdition(DatabaseEdition.BASIC);
            this.importRequestInner.withServiceObjectiveName(ServiceObjectiveName.BASIC);
            this.importRequestInner.withMaxSizeBytes(Long.toString(SqlDatabaseBasicStorage.MAX_2_GB.capacity()));
        } else {
            this.withStandardEdition(SqlDatabaseStandardServiceObjective.S0);
        }
    }

    @Override
    public SqlDatabaseImpl importFrom(String storageUri) {
        this.initializeImportRequestInner();
        this.importRequestInner.withStorageUri(storageUri);
        return this;
    }

    @Override
    public SqlDatabaseImpl importFrom(final StorageAccount storageAccount, final String containerName, final String fileName) {
        final SqlDatabaseImpl self = this;
        Objects.requireNonNull(storageAccount);
        this.initializeImportRequestInner();
        this.addDependency(new FunctionalTaskItem(){

            public Observable<Indexable> call(final FunctionalTaskItem.Context context) {
                return storageAccount.getKeysAsync().flatMap((Func1)new Func1<List<StorageAccountKey>, Observable<StorageAccountKey>>(){

                    public Observable<StorageAccountKey> call(List<StorageAccountKey> storageAccountKeys) {
                        return Observable.from(storageAccountKeys).first();
                    }
                }).flatMap((Func1)new Func1<StorageAccountKey, Observable<Indexable>>(){

                    public Observable<Indexable> call(StorageAccountKey storageAccountKey) {
                        self.importRequestInner.withStorageUri(String.format("%s%s/%s", storageAccount.endPoints().primary().blob(), containerName, fileName));
                        self.importRequestInner.withStorageKeyType(StorageKeyType.STORAGE_ACCESS_KEY);
                        self.importRequestInner.withStorageKey(storageAccountKey.value());
                        return context.voidObservable();
                    }
                });
            }
        });
        return this;
    }

    @Override
    public SqlDatabaseImpl withStorageAccessKey(String storageAccessKey) {
        this.importRequestInner.withStorageKeyType(StorageKeyType.STORAGE_ACCESS_KEY);
        this.importRequestInner.withStorageKey(storageAccessKey);
        return this;
    }

    @Override
    public SqlDatabaseImpl withSharedAccessKey(String sharedAccessKey) {
        this.importRequestInner.withStorageKeyType(StorageKeyType.SHARED_ACCESS_KEY);
        this.importRequestInner.withStorageKey(sharedAccessKey);
        return this;
    }

    @Override
    public SqlDatabaseImpl withSqlAdministratorLoginAndPassword(String administratorLogin, String administratorPassword) {
        this.importRequestInner.withAuthenticationType(AuthenticationType.SQL);
        this.importRequestInner.withAdministratorLogin(administratorLogin);
        this.importRequestInner.withAdministratorLoginPassword(administratorPassword);
        return this;
    }

    @Override
    public SqlDatabaseImpl withActiveDirectoryLoginAndPassword(String administratorLogin, String administratorPassword) {
        this.importRequestInner.withAuthenticationType(AuthenticationType.ADPASSWORD);
        this.importRequestInner.withAdministratorLogin(administratorLogin);
        this.importRequestInner.withAdministratorLoginPassword(administratorPassword);
        return this;
    }

    @Override
    public SqlDatabaseImpl fromRestorePoint(RestorePoint restorePoint) {
        return this.fromRestorePoint(restorePoint, restorePoint.earliestRestoreDate());
    }

    @Override
    public SqlDatabaseImpl fromRestorePoint(RestorePoint restorePoint, DateTime restorePointDateTime) {
        Objects.requireNonNull(restorePoint);
        ((DatabaseInner)((Object)this.inner())).withRestorePointInTime(restorePointDateTime);
        return this.withSourceDatabase(restorePoint.databaseId()).withMode(CreateMode.POINT_IN_TIME_RESTORE);
    }

    @Override
    public SqlDatabaseImpl withSourceDatabase(String sourceDatabaseId) {
        ((DatabaseInner)((Object)this.inner())).withSourceDatabaseId(sourceDatabaseId);
        return this;
    }

    @Override
    public SqlDatabaseImpl withSourceDatabase(SqlDatabase sourceDatabase) {
        return this.withSourceDatabase(sourceDatabase.id());
    }

    @Override
    public SqlDatabaseImpl withMode(CreateMode createMode) {
        ((DatabaseInner)((Object)this.inner())).withCreateMode(createMode);
        return this;
    }

    @Override
    public SqlDatabaseImpl withCollation(String collation) {
        ((DatabaseInner)((Object)this.inner())).withCollation(collation);
        return this;
    }

    @Override
    public SqlDatabaseImpl withMaxSizeBytes(long maxSizeBytes) {
        ((DatabaseInner)((Object)this.inner())).withMaxSizeBytes(Long.toString(maxSizeBytes));
        return this;
    }

    @Override
    public SqlDatabaseImpl withEdition(DatabaseEdition edition) {
        ((DatabaseInner)((Object)this.inner())).withElasticPoolName(null);
        ((DatabaseInner)((Object)this.inner())).withRequestedServiceObjectiveId(null);
        ((DatabaseInner)((Object)this.inner())).withEdition(edition);
        return this;
    }

    @Override
    public SqlDatabaseImpl withBasicEdition() {
        return this.withBasicEdition(SqlDatabaseBasicStorage.MAX_2_GB);
    }

    @Override
    public SqlDatabaseImpl withBasicEdition(SqlDatabaseBasicStorage maxStorageCapacity) {
        ((DatabaseInner)((Object)this.inner())).withEdition(DatabaseEdition.BASIC);
        this.withServiceObjective(ServiceObjectiveName.BASIC);
        ((DatabaseInner)((Object)this.inner())).withMaxSizeBytes(Long.toString(maxStorageCapacity.capacity()));
        return this;
    }

    @Override
    public SqlDatabaseImpl withStandardEdition(SqlDatabaseStandardServiceObjective serviceObjective) {
        return this.withStandardEdition(serviceObjective, SqlDatabaseStandardStorage.MAX_250_GB);
    }

    @Override
    public SqlDatabaseImpl withStandardEdition(SqlDatabaseStandardServiceObjective serviceObjective, SqlDatabaseStandardStorage maxStorageCapacity) {
        ((DatabaseInner)((Object)this.inner())).withEdition(DatabaseEdition.STANDARD);
        this.withServiceObjective(ServiceObjectiveName.fromString(serviceObjective.toString()));
        ((DatabaseInner)((Object)this.inner())).withMaxSizeBytes(Long.toString(maxStorageCapacity.capacity()));
        return this;
    }

    @Override
    public SqlDatabaseImpl withPremiumEdition(SqlDatabasePremiumServiceObjective serviceObjective) {
        return this.withPremiumEdition(serviceObjective, SqlDatabasePremiumStorage.MAX_500_GB);
    }

    @Override
    public SqlDatabaseImpl withPremiumEdition(SqlDatabasePremiumServiceObjective serviceObjective, SqlDatabasePremiumStorage maxStorageCapacity) {
        ((DatabaseInner)((Object)this.inner())).withEdition(DatabaseEdition.PREMIUM);
        this.withServiceObjective(ServiceObjectiveName.fromString(serviceObjective.toString()));
        ((DatabaseInner)((Object)this.inner())).withMaxSizeBytes(Long.toString(maxStorageCapacity.capacity()));
        return this;
    }

    @Override
    public SqlDatabaseImpl withServiceObjective(ServiceObjectiveName serviceLevelObjective) {
        ((DatabaseInner)((Object)this.inner())).withElasticPoolName(null);
        ((DatabaseInner)((Object)this.inner())).withRequestedServiceObjectiveId(null);
        ((DatabaseInner)((Object)this.inner())).withRequestedServiceObjectiveName(serviceLevelObjective);
        return this;
    }

    public SqlDatabaseImpl withTags(Map<String, String> tags) {
        ((DatabaseInner)((Object)this.inner())).withTags(new HashMap<String, String>(tags));
        return this;
    }

    public SqlDatabaseImpl withTag(String key, String value) {
        if (((DatabaseInner)((Object)this.inner())).getTags() == null) {
            ((DatabaseInner)((Object)this.inner())).withTags(new HashMap());
        }
        ((DatabaseInner)((Object)this.inner())).getTags().put(key, value);
        return this;
    }

    public SqlDatabaseImpl withoutTag(String key) {
        if (((DatabaseInner)((Object)this.inner())).getTags() != null) {
            ((DatabaseInner)((Object)this.inner())).getTags().remove(key);
        }
        return this;
    }

    @Override
    public SqlDatabaseImpl fromSample(SampleName sampleName) {
        ((DatabaseInner)((Object)this.inner())).withSampleName(sampleName);
        return this;
    }
}

