/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.JobAgentUpdate;
import com.microsoft.azure.management.sql.implementation.JobAgentInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class JobAgentsInner {
    private JobAgentsService service;
    private SqlManagementClientImpl client;

    public JobAgentsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (JobAgentsService)retrofit.create(JobAgentsService.class);
        this.client = client;
    }

    public PagedList<JobAgentInner> listByServer(String resourceGroupName, String serverName) {
        ServiceResponse response = (ServiceResponse)this.listByServerSinglePageAsync(resourceGroupName, serverName).toBlocking().single();
        return new PagedList<JobAgentInner>((Page)response.body()){

            public Page<JobAgentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobAgentsInner.this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobAgentInner>> listByServerAsync(String resourceGroupName, String serverName, ListOperationCallback<JobAgentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByServerSinglePageAsync(resourceGroupName, serverName), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobAgentInner>>>>(){

            public Observable<ServiceResponse<Page<JobAgentInner>>> call(String nextPageLink) {
                return JobAgentsInner.this.listByServerNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobAgentInner>> listByServerAsync(String resourceGroupName, String serverName) {
        return this.listByServerWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<Page<JobAgentInner>>, Page<JobAgentInner>>(){

            public Page<JobAgentInner> call(ServiceResponse<Page<JobAgentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobAgentInner>>> listByServerWithServiceResponseAsync(String resourceGroupName, String serverName) {
        return this.listByServerSinglePageAsync(resourceGroupName, serverName).concatMap((Func1)new Func1<ServiceResponse<Page<JobAgentInner>>, Observable<ServiceResponse<Page<JobAgentInner>>>>(){

            public Observable<ServiceResponse<Page<JobAgentInner>>> call(ServiceResponse<Page<JobAgentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobAgentsInner.this.listByServerNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobAgentInner>>> listByServerSinglePageAsync(String resourceGroupName, String serverName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.listByServer(resourceGroupName, serverName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobAgentInner>>>>(){

            public Observable<ServiceResponse<Page<JobAgentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobAgentsInner.this.listByServerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<JobAgentInner>> listByServerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<JobAgentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public JobAgentInner get(String resourceGroupName, String serverName, String jobAgentName) {
        return (JobAgentInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName).toBlocking().single()).body());
    }

    public ServiceFuture<JobAgentInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, ServiceCallback<JobAgentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName), serviceCallback);
    }

    public Observable<JobAgentInner> getAsync(String resourceGroupName, String serverName, String jobAgentName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName).map((Func1)new Func1<ServiceResponse<JobAgentInner>, JobAgentInner>(){

            public JobAgentInner call(ServiceResponse<JobAgentInner> response) {
                return (JobAgentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<JobAgentInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.get(resourceGroupName, serverName, jobAgentName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobAgentInner>>>(){

            public Observable<ServiceResponse<JobAgentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobAgentsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobAgentInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobAgentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public JobAgentInner createOrUpdate(String resourceGroupName, String serverName, String jobAgentName, JobAgentInner parameters) {
        return (JobAgentInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<JobAgentInner> createOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, JobAgentInner parameters, ServiceCallback<JobAgentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, parameters), serviceCallback);
    }

    public Observable<JobAgentInner> createOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, JobAgentInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, parameters).map((Func1)new Func1<ServiceResponse<JobAgentInner>, JobAgentInner>(){

            public JobAgentInner call(ServiceResponse<JobAgentInner> response) {
                return (JobAgentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<JobAgentInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, JobAgentInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2017-03-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, serverName, jobAgentName, this.client.subscriptionId(), parameters, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<JobAgentInner>(){}.getType());
    }

    public JobAgentInner beginCreateOrUpdate(String resourceGroupName, String serverName, String jobAgentName, JobAgentInner parameters) {
        return (JobAgentInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<JobAgentInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, JobAgentInner parameters, ServiceCallback<JobAgentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, parameters), serviceCallback);
    }

    public Observable<JobAgentInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, JobAgentInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, parameters).map((Func1)new Func1<ServiceResponse<JobAgentInner>, JobAgentInner>(){

            public JobAgentInner call(ServiceResponse<JobAgentInner> response) {
                return (JobAgentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<JobAgentInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, JobAgentInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2017-03-01-preview";
        return this.service.beginCreateOrUpdate(resourceGroupName, serverName, jobAgentName, this.client.subscriptionId(), parameters, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobAgentInner>>>(){

            public Observable<ServiceResponse<JobAgentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobAgentsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobAgentInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobAgentInner>(){}.getType()).register(201, new TypeToken<JobAgentInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String serverName, String jobAgentName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String jobAgentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String jobAgentName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, serverName, jobAgentName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String serverName, String jobAgentName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String serverName, String jobAgentName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String serverName, String jobAgentName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.beginDelete(resourceGroupName, serverName, jobAgentName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobAgentsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public JobAgentInner update(String resourceGroupName, String serverName, String jobAgentName) {
        return (JobAgentInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName).toBlocking().last()).body());
    }

    public ServiceFuture<JobAgentInner> updateAsync(String resourceGroupName, String serverName, String jobAgentName, ServiceCallback<JobAgentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName), serviceCallback);
    }

    public Observable<JobAgentInner> updateAsync(String resourceGroupName, String serverName, String jobAgentName) {
        return this.updateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName).map((Func1)new Func1<ServiceResponse<JobAgentInner>, JobAgentInner>(){

            public JobAgentInner call(ServiceResponse<JobAgentInner> response) {
                return (JobAgentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<JobAgentInner>> updateWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        Object tags = null;
        JobAgentUpdate parameters = new JobAgentUpdate();
        parameters.withTags(null);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, serverName, jobAgentName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<JobAgentInner>(){}.getType());
    }

    public JobAgentInner update(String resourceGroupName, String serverName, String jobAgentName, Map<String, String> tags) {
        return (JobAgentInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, tags).toBlocking().last()).body());
    }

    public ServiceFuture<JobAgentInner> updateAsync(String resourceGroupName, String serverName, String jobAgentName, Map<String, String> tags, ServiceCallback<JobAgentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, tags), serviceCallback);
    }

    public Observable<JobAgentInner> updateAsync(String resourceGroupName, String serverName, String jobAgentName, Map<String, String> tags) {
        return this.updateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, tags).map((Func1)new Func1<ServiceResponse<JobAgentInner>, JobAgentInner>(){

            public JobAgentInner call(ServiceResponse<JobAgentInner> response) {
                return (JobAgentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<JobAgentInner>> updateWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2017-03-01-preview";
        JobAgentUpdate parameters = new JobAgentUpdate();
        parameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, serverName, jobAgentName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<JobAgentInner>(){}.getType());
    }

    public JobAgentInner beginUpdate(String resourceGroupName, String serverName, String jobAgentName) {
        return (JobAgentInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName).toBlocking().single()).body());
    }

    public ServiceFuture<JobAgentInner> beginUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, ServiceCallback<JobAgentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName), serviceCallback);
    }

    public Observable<JobAgentInner> beginUpdateAsync(String resourceGroupName, String serverName, String jobAgentName) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName).map((Func1)new Func1<ServiceResponse<JobAgentInner>, JobAgentInner>(){

            public JobAgentInner call(ServiceResponse<JobAgentInner> response) {
                return (JobAgentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<JobAgentInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        Object tags = null;
        JobAgentUpdate parameters = new JobAgentUpdate();
        parameters.withTags(null);
        return this.service.beginUpdate(resourceGroupName, serverName, jobAgentName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobAgentInner>>>(){

            public Observable<ServiceResponse<JobAgentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobAgentsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public JobAgentInner beginUpdate(String resourceGroupName, String serverName, String jobAgentName, Map<String, String> tags) {
        return (JobAgentInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<JobAgentInner> beginUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, Map<String, String> tags, ServiceCallback<JobAgentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, tags), serviceCallback);
    }

    public Observable<JobAgentInner> beginUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, Map<String, String> tags) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, tags).map((Func1)new Func1<ServiceResponse<JobAgentInner>, JobAgentInner>(){

            public JobAgentInner call(ServiceResponse<JobAgentInner> response) {
                return (JobAgentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<JobAgentInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2017-03-01-preview";
        JobAgentUpdate parameters = new JobAgentUpdate();
        parameters.withTags(tags);
        return this.service.beginUpdate(resourceGroupName, serverName, jobAgentName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobAgentInner>>>(){

            public Observable<ServiceResponse<JobAgentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobAgentsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobAgentInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobAgentInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<JobAgentInner> listByServerNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobAgentInner>((Page)response.body()){

            public Page<JobAgentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobAgentsInner.this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobAgentInner>> listByServerNextAsync(String nextPageLink, ServiceFuture<List<JobAgentInner>> serviceFuture, ListOperationCallback<JobAgentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByServerNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobAgentInner>>>>(){

            public Observable<ServiceResponse<Page<JobAgentInner>>> call(String nextPageLink) {
                return JobAgentsInner.this.listByServerNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobAgentInner>> listByServerNextAsync(String nextPageLink) {
        return this.listByServerNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<JobAgentInner>>, Page<JobAgentInner>>(){

            public Page<JobAgentInner> call(ServiceResponse<Page<JobAgentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobAgentInner>>> listByServerNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByServerNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<JobAgentInner>>, Observable<ServiceResponse<Page<JobAgentInner>>>>(){

            public Observable<ServiceResponse<Page<JobAgentInner>>> call(ServiceResponse<Page<JobAgentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobAgentsInner.this.listByServerNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobAgentInner>>> listByServerNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByServerNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobAgentInner>>>>(){

            public Observable<ServiceResponse<Page<JobAgentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobAgentsInner.this.listByServerNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<JobAgentInner>> listByServerNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<JobAgentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface JobAgentsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobAgents listByServer"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents")
        public Observable<Response<ResponseBody>> listByServer(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobAgents get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobAgents createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="subscriptionId") String var4, @Body JobAgentInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobAgents beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="subscriptionId") String var4, @Body JobAgentInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobAgents delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobAgents beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobAgents update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body JobAgentUpdate var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobAgents beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body JobAgentUpdate var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobAgents listByServerNext"})
        @GET
        public Observable<Response<ResponseBody>> listByServerNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

