/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.models.IndependentChild;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.IndependentChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.azure.management.sql.ElasticPoolActivity;
import com.microsoft.azure.management.sql.ElasticPoolDatabaseActivity;
import com.microsoft.azure.management.sql.ElasticPoolEditions;
import com.microsoft.azure.management.sql.ElasticPoolState;
import com.microsoft.azure.management.sql.SqlDatabase;
import com.microsoft.azure.management.sql.SqlElasticPool;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.implementation.DatabaseInner;
import com.microsoft.azure.management.sql.implementation.DatabasesImpl;
import com.microsoft.azure.management.sql.implementation.ElasticPoolActivityImpl;
import com.microsoft.azure.management.sql.implementation.ElasticPoolActivityInner;
import com.microsoft.azure.management.sql.implementation.ElasticPoolDatabaseActivityImpl;
import com.microsoft.azure.management.sql.implementation.ElasticPoolDatabaseActivityInner;
import com.microsoft.azure.management.sql.implementation.ElasticPoolInner;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class SqlElasticPoolImpl
extends IndependentChildResourceImpl<SqlElasticPool, SqlServer, ElasticPoolInner, SqlElasticPoolImpl, SqlServerManager>
implements SqlElasticPool,
SqlElasticPool.Definition,
SqlElasticPool.Update,
IndependentChild.DefinitionStages.WithParentResource<SqlElasticPool, SqlServer> {
    private final DatabasesImpl databasesImpl;
    private final Map<String, SqlDatabaseImpl> databaseCreatableMap;

    protected SqlElasticPoolImpl(String name, ElasticPoolInner innerObject, DatabasesImpl databasesImpl, SqlServerManager manager) {
        super(name, (Resource)innerObject, (Object)manager);
        this.databasesImpl = databasesImpl;
        this.databaseCreatableMap = new HashMap<String, SqlDatabaseImpl>();
    }

    @Override
    public String sqlServerName() {
        return this.parentName;
    }

    @Override
    public DateTime creationDate() {
        return ((ElasticPoolInner)((Object)this.inner())).creationDate();
    }

    @Override
    public ElasticPoolState state() {
        return ((ElasticPoolInner)((Object)this.inner())).state();
    }

    @Override
    public ElasticPoolEditions edition() {
        return ((ElasticPoolInner)((Object)this.inner())).edition();
    }

    @Override
    public int dtu() {
        return Utils.toPrimitiveInt((Integer)((ElasticPoolInner)((Object)this.inner())).dtu());
    }

    @Override
    public int databaseDtuMax() {
        return Utils.toPrimitiveInt((Integer)((ElasticPoolInner)((Object)this.inner())).databaseDtuMax());
    }

    @Override
    public int databaseDtuMin() {
        return Utils.toPrimitiveInt((Integer)((ElasticPoolInner)((Object)this.inner())).databaseDtuMin());
    }

    @Override
    public int storageMB() {
        return Utils.toPrimitiveInt((Integer)((ElasticPoolInner)((Object)this.inner())).storageMB());
    }

    @Override
    public List<ElasticPoolActivity> listActivities() {
        PagedListConverter<ElasticPoolActivityInner, ElasticPoolActivity> converter = new PagedListConverter<ElasticPoolActivityInner, ElasticPoolActivity>(){

            public ElasticPoolActivity typeConvert(ElasticPoolActivityInner elasticPoolActivityInner) {
                return new ElasticPoolActivityImpl(elasticPoolActivityInner);
            }
        };
        return converter.convert(ReadableWrappersImpl.convertToPagedList(((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)this.manager())).inner())).elasticPools().listActivity(this.resourceGroupName(), this.sqlServerName(), this.name())));
    }

    @Override
    public List<ElasticPoolDatabaseActivity> listDatabaseActivities() {
        PagedListConverter<ElasticPoolDatabaseActivityInner, ElasticPoolDatabaseActivity> converter = new PagedListConverter<ElasticPoolDatabaseActivityInner, ElasticPoolDatabaseActivity>(){

            public ElasticPoolDatabaseActivity typeConvert(ElasticPoolDatabaseActivityInner elasticPoolDatabaseActivityInner) {
                return new ElasticPoolDatabaseActivityImpl(elasticPoolDatabaseActivityInner);
            }
        };
        return converter.convert(ReadableWrappersImpl.convertToPagedList(((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)this.manager())).inner())).elasticPools().listDatabaseActivity(this.resourceGroupName(), this.sqlServerName(), this.name())));
    }

    @Override
    public List<SqlDatabase> listDatabases() {
        final SqlElasticPoolImpl self = this;
        PagedListConverter<DatabaseInner, SqlDatabase> converter = new PagedListConverter<DatabaseInner, SqlDatabase>(){

            public SqlDatabase typeConvert(DatabaseInner databaseInner) {
                return new SqlDatabaseImpl(databaseInner.name(), databaseInner, (SqlServerManager)((Object)self.manager()));
            }
        };
        return converter.convert(ReadableWrappersImpl.convertToPagedList(((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)this.manager())).inner())).elasticPools().listDatabases(this.resourceGroupName(), this.sqlServerName(), this.name())));
    }

    @Override
    public SqlDatabase getDatabase(String databaseName) {
        DatabaseInner database = ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)this.manager())).inner())).elasticPools().getDatabase(this.resourceGroupName(), this.sqlServerName(), this.name(), databaseName);
        return new SqlDatabaseImpl(database.name(), database, (SqlServerManager)((Object)this.manager()));
    }

    @Override
    public void delete() {
        ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)this.manager())).inner())).elasticPools().delete(this.resourceGroupName(), this.sqlServerName(), this.name());
    }

    protected Observable<ElasticPoolInner> getInnerAsync() {
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)this.manager())).inner())).elasticPools().getAsync(this.resourceGroupName(), this.sqlServerName(), this.name());
    }

    protected Observable<SqlElasticPool> createChildResourceAsync() {
        final SqlElasticPoolImpl self = this;
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)this.manager())).inner())).elasticPools().createOrUpdateAsync(this.resourceGroupName(), this.sqlServerName(), this.name(), (ElasticPoolInner)((Object)this.inner())).map((Func1)new Func1<ElasticPoolInner, SqlElasticPool>(){

            public SqlElasticPool call(ElasticPoolInner elasticPoolInner) {
                SqlElasticPoolImpl.this.setInner((Object)elasticPoolInner);
                SqlElasticPoolImpl.this.createOrUpdateDatabase();
                return self;
            }
        });
    }

    @Override
    public SqlElasticPoolImpl withEdition(ElasticPoolEditions edition) {
        ((ElasticPoolInner)((Object)this.inner())).withEdition(edition);
        return this;
    }

    @Override
    public SqlElasticPoolImpl withDatabaseDtuMin(int databaseDtuMin) {
        ((ElasticPoolInner)((Object)this.inner())).withDatabaseDtuMin(databaseDtuMin);
        return this;
    }

    @Override
    public SqlElasticPoolImpl withDatabaseDtuMax(int databaseDtuMax) {
        ((ElasticPoolInner)((Object)this.inner())).withDatabaseDtuMax(databaseDtuMax);
        return this;
    }

    @Override
    public SqlElasticPoolImpl withDtu(int dtu) {
        ((ElasticPoolInner)((Object)this.inner())).withDtu(dtu);
        return this;
    }

    @Override
    public SqlElasticPoolImpl withStorageCapacity(int storageMB) {
        ((ElasticPoolInner)((Object)this.inner())).withStorageMB(storageMB);
        return this;
    }

    @Override
    public SqlElasticPoolImpl withNewDatabase(String databaseName) {
        this.databaseCreatableMap.put(databaseName, (SqlDatabaseImpl)this.databasesImpl.define(databaseName).withExistingElasticPool(this.name()));
        return this;
    }

    @Override
    public SqlElasticPoolImpl withExistingDatabase(String databaseName) {
        this.databaseCreatableMap.put(databaseName, (SqlDatabaseImpl)((SqlDatabase.Update)this.databasesImpl.get(databaseName).update()).withExistingElasticPool(this.name()));
        return this;
    }

    @Override
    public SqlElasticPoolImpl withExistingDatabase(SqlDatabase database) {
        this.databaseCreatableMap.put(database.name(), (SqlDatabaseImpl)((SqlDatabase.Update)database.update()).withExistingElasticPool(this.name()));
        return this;
    }

    private void createOrUpdateDatabase() {
        if (this.databaseCreatableMap.size() > 0) {
            this.databasesImpl.databases().create(new ArrayList<SqlDatabaseImpl>(this.databaseCreatableMap.values()));
            this.databaseCreatableMap.clear();
        }
    }
}

