/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for CreateMode.
 */
public final class CreateMode {
    /** Static value Copy for CreateMode. */
    public static final CreateMode COPY = new CreateMode("Copy");

    /** Static value Default for CreateMode. */
    public static final CreateMode DEFAULT = new CreateMode("Default");

    /** Static value NonReadableSecondary for CreateMode. */
    public static final CreateMode NON_READABLE_SECONDARY = new CreateMode("NonReadableSecondary");

    /** Static value OnlineSecondary for CreateMode. */
    public static final CreateMode ONLINE_SECONDARY = new CreateMode("OnlineSecondary");

    /** Static value PointInTimeRestore for CreateMode. */
    public static final CreateMode POINT_IN_TIME_RESTORE = new CreateMode("PointInTimeRestore");

    /** Static value Recovery for CreateMode. */
    public static final CreateMode RECOVERY = new CreateMode("Recovery");

    /** Static value Restore for CreateMode. */
    public static final CreateMode RESTORE = new CreateMode("Restore");

    private String value;

    /**
     * Creates a custom value for CreateMode.
     * @param value the custom value
     */
    public CreateMode(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CreateMode)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        CreateMode rhs = (CreateMode) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
