/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.NetworkWatcher;
import com.microsoft.azure.management.network.Topology;
import com.microsoft.azure.management.network.TopologyResource;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.NetworkWatcherImpl;
import com.microsoft.azure.management.network.implementation.TopologyInner;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.joda.time.DateTime;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class TopologyImpl
extends RefreshableWrapperImpl<TopologyInner, Topology>
implements Topology {
    private Map<String, TopologyResource> resources;
    private final NetworkWatcherImpl parent;
    private final String groupName;

    TopologyImpl(NetworkWatcherImpl parent, TopologyInner innerObject, String groupName) {
        super((Object)innerObject);
        this.parent = parent;
        this.groupName = groupName;
        this.initializeResourcesFromInner();
    }

    @Override
    public String id() {
        return ((TopologyInner)this.inner()).id();
    }

    @Override
    public String resourceGroupName() {
        return this.groupName;
    }

    @Override
    public DateTime createdTime() {
        return ((TopologyInner)this.inner()).createdDateTime();
    }

    @Override
    public DateTime lastModifiedTime() {
        return ((TopologyInner)this.inner()).lastModified();
    }

    @Override
    public Map<String, TopologyResource> resources() {
        return Collections.unmodifiableMap(this.resources);
    }

    private void initializeResourcesFromInner() {
        this.resources = new TreeMap<String, TopologyResource>();
        List<TopologyResource> topologyResources = ((TopologyInner)this.inner()).resources();
        if (topologyResources != null) {
            for (TopologyResource resource : topologyResources) {
                this.resources.put(resource.id(), resource);
            }
        }
    }

    public NetworkWatcher parent() {
        return this.parent;
    }

    public Observable<Topology> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<Topology, Topology>(){

            public Topology call(Topology topology) {
                TopologyImpl impl = (TopologyImpl)topology;
                impl.initializeResourcesFromInner();
                return impl;
            }
        });
    }

    protected Observable<TopologyInner> getInnerAsync() {
        return ((NetworkManagementClientImpl)((Object)((NetworkManager)((Object)this.parent().manager())).inner())).networkWatchers().getTopologyAsync(this.parent().resourceGroupName(), this.parent().name(), this.groupName);
    }
}

