/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ApplicationGateway;
import com.microsoft.azure.management.network.ApplicationGatewayBackend;
import com.microsoft.azure.management.network.ApplicationGatewayBackendAddress;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayBackendAddressPoolInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayImpl;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceIPConfigurationInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@LangDefinition
class ApplicationGatewayBackendImpl
extends ChildResourceImpl<ApplicationGatewayBackendAddressPoolInner, ApplicationGatewayImpl, ApplicationGateway>
implements ApplicationGatewayBackend,
ApplicationGatewayBackend.Definition<ApplicationGateway.DefinitionStages.WithCreate>,
ApplicationGatewayBackend.UpdateDefinition<ApplicationGateway.Update>,
ApplicationGatewayBackend.Update {
    ApplicationGatewayBackendImpl(ApplicationGatewayBackendAddressPoolInner inner, ApplicationGatewayImpl parent) {
        super((Object)inner, (Object)parent);
    }

    private List<ApplicationGatewayBackendAddress> ensureAddresses() {
        List<ApplicationGatewayBackendAddress> addresses = ((ApplicationGatewayBackendAddressPoolInner)((Object)this.inner())).backendAddresses();
        if (addresses == null) {
            addresses = new ArrayList<ApplicationGatewayBackendAddress>();
            ((ApplicationGatewayBackendAddressPoolInner)((Object)this.inner())).withBackendAddresses(addresses);
        }
        return addresses;
    }

    public String name() {
        return ((ApplicationGatewayBackendAddressPoolInner)((Object)this.inner())).name();
    }

    @Override
    public Map<String, String> backendNicIPConfigurationNames() {
        TreeMap<String, String> ipConfigNames = new TreeMap<String, String>();
        if (((ApplicationGatewayBackendAddressPoolInner)((Object)this.inner())).backendIPConfigurations() != null) {
            for (NetworkInterfaceIPConfigurationInner inner : ((ApplicationGatewayBackendAddressPoolInner)((Object)this.inner())).backendIPConfigurations()) {
                String nicId = ResourceUtils.parentResourceIdFromResourceId((String)inner.id());
                String ipConfigName = ResourceUtils.nameFromResourceId((String)inner.id());
                ipConfigNames.put(nicId, ipConfigName);
            }
        }
        return Collections.unmodifiableMap(ipConfigNames);
    }

    @Override
    public Collection<ApplicationGatewayBackendAddress> addresses() {
        ArrayList<ApplicationGatewayBackendAddress> addresses = new ArrayList<ApplicationGatewayBackendAddress>();
        if (((ApplicationGatewayBackendAddressPoolInner)((Object)this.inner())).backendAddresses() != null) {
            for (ApplicationGatewayBackendAddress address : ((ApplicationGatewayBackendAddressPoolInner)((Object)this.inner())).backendAddresses()) {
                addresses.add(address);
            }
        }
        return Collections.unmodifiableCollection(addresses);
    }

    public ApplicationGatewayImpl attach() {
        ((ApplicationGatewayImpl)this.parent()).withBackend(this);
        return (ApplicationGatewayImpl)this.parent();
    }

    @Override
    public ApplicationGatewayBackendImpl withIPAddress(String ipAddress) {
        if (ipAddress == null) {
            return this;
        }
        ApplicationGatewayBackendAddress address = new ApplicationGatewayBackendAddress().withIPAddress(ipAddress);
        List<ApplicationGatewayBackendAddress> addresses = this.ensureAddresses();
        for (ApplicationGatewayBackendAddress a : addresses) {
            if (!ipAddress.equalsIgnoreCase(a.ipAddress())) continue;
            return this;
        }
        addresses.add(address);
        return this;
    }

    @Override
    public ApplicationGatewayBackendImpl withFqdn(String fqdn) {
        if (fqdn == null) {
            return this;
        }
        ApplicationGatewayBackendAddress address = new ApplicationGatewayBackendAddress().withFqdn(fqdn);
        this.ensureAddresses().add(address);
        return this;
    }

    @Override
    public ApplicationGatewayBackendImpl withoutIPAddress(String ipAddress) {
        if (ipAddress == null) {
            return this;
        }
        if (((ApplicationGatewayBackendAddressPoolInner)((Object)this.inner())).backendAddresses() == null) {
            return this;
        }
        List<ApplicationGatewayBackendAddress> addresses = this.ensureAddresses();
        for (int i = 0; i < addresses.size(); ++i) {
            String curIPAddress = addresses.get(i).ipAddress();
            if (curIPAddress == null || !curIPAddress.equalsIgnoreCase(ipAddress)) continue;
            addresses.remove(i);
            break;
        }
        return this;
    }

    @Override
    public ApplicationGatewayBackendImpl withoutAddress(ApplicationGatewayBackendAddress address) {
        this.ensureAddresses().remove(address);
        return this;
    }

    @Override
    public ApplicationGatewayBackendImpl withoutFqdn(String fqdn) {
        if (fqdn == null) {
            return this;
        }
        List<ApplicationGatewayBackendAddress> addresses = this.ensureAddresses();
        for (int i = 0; i < addresses.size(); ++i) {
            String curFqdn = addresses.get(i).fqdn();
            if (curFqdn == null || !curFqdn.equalsIgnoreCase(fqdn)) continue;
            addresses.remove(i);
            break;
        }
        return this;
    }

    @Override
    public boolean containsIPAddress(String ipAddress) {
        if (ipAddress != null) {
            for (ApplicationGatewayBackendAddress address : ((ApplicationGatewayBackendAddressPoolInner)((Object)this.inner())).backendAddresses()) {
                if (!ipAddress.equalsIgnoreCase(address.ipAddress())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsFqdn(String fqdn) {
        if (fqdn != null) {
            for (ApplicationGatewayBackendAddress address : ((ApplicationGatewayBackendAddressPoolInner)((Object)this.inner())).backendAddresses()) {
                if (!fqdn.equalsIgnoreCase(address.fqdn())) continue;
                return true;
            }
        }
        return false;
    }
}

