/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import java.util.List;
import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.network.ApplicationGatewaySslPolicyName;
import com.microsoft.azure.management.network.ApplicationGatewaySslCipherSuite;
import com.microsoft.azure.management.network.ApplicationGatewaySslProtocol;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.Resource;

/**
 * Response for ApplicationGatewayAvailableSslOptions API service call.
 */
@JsonFlatten
public class ApplicationGatewayAvailableSslOptionsInner extends Resource {
    /**
     * List of available Ssl predefined policy.
     */
    @JsonProperty(value = "properties.predefinedPolicies")
    private List<SubResource> predefinedPolicies;

    /**
     * Name of the Ssl predefined policy applied by default to application
     * gateway. Possible values include: 'AppGwSslPolicy20150501',
     * 'AppGwSslPolicy20170401', 'AppGwSslPolicy20170401S'.
     */
    @JsonProperty(value = "properties.defaultPolicy")
    private ApplicationGatewaySslPolicyName defaultPolicy;

    /**
     * List of available Ssl cipher suites.
     */
    @JsonProperty(value = "properties.availableCipherSuites")
    private List<ApplicationGatewaySslCipherSuite> availableCipherSuites;

    /**
     * List of available Ssl protocols.
     */
    @JsonProperty(value = "properties.availableProtocols")
    private List<ApplicationGatewaySslProtocol> availableProtocols;

    /**
     * Get the predefinedPolicies value.
     *
     * @return the predefinedPolicies value
     */
    public List<SubResource> predefinedPolicies() {
        return this.predefinedPolicies;
    }

    /**
     * Set the predefinedPolicies value.
     *
     * @param predefinedPolicies the predefinedPolicies value to set
     * @return the ApplicationGatewayAvailableSslOptionsInner object itself.
     */
    public ApplicationGatewayAvailableSslOptionsInner withPredefinedPolicies(List<SubResource> predefinedPolicies) {
        this.predefinedPolicies = predefinedPolicies;
        return this;
    }

    /**
     * Get the defaultPolicy value.
     *
     * @return the defaultPolicy value
     */
    public ApplicationGatewaySslPolicyName defaultPolicy() {
        return this.defaultPolicy;
    }

    /**
     * Set the defaultPolicy value.
     *
     * @param defaultPolicy the defaultPolicy value to set
     * @return the ApplicationGatewayAvailableSslOptionsInner object itself.
     */
    public ApplicationGatewayAvailableSslOptionsInner withDefaultPolicy(ApplicationGatewaySslPolicyName defaultPolicy) {
        this.defaultPolicy = defaultPolicy;
        return this;
    }

    /**
     * Get the availableCipherSuites value.
     *
     * @return the availableCipherSuites value
     */
    public List<ApplicationGatewaySslCipherSuite> availableCipherSuites() {
        return this.availableCipherSuites;
    }

    /**
     * Set the availableCipherSuites value.
     *
     * @param availableCipherSuites the availableCipherSuites value to set
     * @return the ApplicationGatewayAvailableSslOptionsInner object itself.
     */
    public ApplicationGatewayAvailableSslOptionsInner withAvailableCipherSuites(List<ApplicationGatewaySslCipherSuite> availableCipherSuites) {
        this.availableCipherSuites = availableCipherSuites;
        return this;
    }

    /**
     * Get the availableProtocols value.
     *
     * @return the availableProtocols value
     */
    public List<ApplicationGatewaySslProtocol> availableProtocols() {
        return this.availableProtocols;
    }

    /**
     * Set the availableProtocols value.
     *
     * @param availableProtocols the availableProtocols value to set
     * @return the ApplicationGatewayAvailableSslOptionsInner object itself.
     */
    public ApplicationGatewayAvailableSslOptionsInner withAvailableProtocols(List<ApplicationGatewaySslProtocol> availableProtocols) {
        this.availableProtocols = availableProtocols;
        return this;
    }

}
