/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for IssueType.
 */
public final class IssueType {
    /** Static value Unknown for IssueType. */
    public static final IssueType UNKNOWN = new IssueType("Unknown");

    /** Static value AgentStopped for IssueType. */
    public static final IssueType AGENT_STOPPED = new IssueType("AgentStopped");

    /** Static value GuestFirewall for IssueType. */
    public static final IssueType GUEST_FIREWALL = new IssueType("GuestFirewall");

    /** Static value DnsResolution for IssueType. */
    public static final IssueType DNS_RESOLUTION = new IssueType("DnsResolution");

    /** Static value SocketBind for IssueType. */
    public static final IssueType SOCKET_BIND = new IssueType("SocketBind");

    /** Static value NetworkSecurityRule for IssueType. */
    public static final IssueType NETWORK_SECURITY_RULE = new IssueType("NetworkSecurityRule");

    /** Static value UserDefinedRoute for IssueType. */
    public static final IssueType USER_DEFINED_ROUTE = new IssueType("UserDefinedRoute");

    /** Static value PortThrottled for IssueType. */
    public static final IssueType PORT_THROTTLED = new IssueType("PortThrottled");

    /** Static value Platform for IssueType. */
    public static final IssueType PLATFORM = new IssueType("Platform");

    private String value;

    /**
     * Creates a custom value for IssueType.
     * @param value the custom value
     */
    public IssueType(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IssueType)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        IssueType rhs = (IssueType) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
