/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for IkeIntegrity.
 */
public final class IkeIntegrity {
    /** Static value MD5 for IkeIntegrity. */
    public static final IkeIntegrity MD5 = new IkeIntegrity("MD5");

    /** Static value SHA1 for IkeIntegrity. */
    public static final IkeIntegrity SHA1 = new IkeIntegrity("SHA1");

    /** Static value SHA256 for IkeIntegrity. */
    public static final IkeIntegrity SHA256 = new IkeIntegrity("SHA256");

    /** Static value SHA384 for IkeIntegrity. */
    public static final IkeIntegrity SHA384 = new IkeIntegrity("SHA384");

    private String value;

    /**
     * Creates a custom value for IkeIntegrity.
     * @param value the custom value
     */
    public IkeIntegrity(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IkeIntegrity)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        IkeIntegrity rhs = (IkeIntegrity) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
