/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for IkeEncryption.
 */
public final class IkeEncryption {
    /** Static value DES for IkeEncryption. */
    public static final IkeEncryption DES = new IkeEncryption("DES");

    /** Static value DES3 for IkeEncryption. */
    public static final IkeEncryption DES3 = new IkeEncryption("DES3");

    /** Static value AES128 for IkeEncryption. */
    public static final IkeEncryption AES128 = new IkeEncryption("AES128");

    /** Static value AES192 for IkeEncryption. */
    public static final IkeEncryption AES192 = new IkeEncryption("AES192");

    /** Static value AES256 for IkeEncryption. */
    public static final IkeEncryption AES256 = new IkeEncryption("AES256");

    private String value;

    /**
     * Creates a custom value for IkeEncryption.
     * @param value the custom value
     */
    public IkeEncryption(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IkeEncryption)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        IkeEncryption rhs = (IkeEncryption) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
