/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for ExpressRouteCircuitPeeringState.
 */
public final class ExpressRouteCircuitPeeringState {
    /** Static value Disabled for ExpressRouteCircuitPeeringState. */
    public static final ExpressRouteCircuitPeeringState DISABLED = new ExpressRouteCircuitPeeringState("Disabled");

    /** Static value Enabled for ExpressRouteCircuitPeeringState. */
    public static final ExpressRouteCircuitPeeringState ENABLED = new ExpressRouteCircuitPeeringState("Enabled");

    private String value;

    /**
     * Creates a custom value for ExpressRouteCircuitPeeringState.
     * @param value the custom value
     */
    public ExpressRouteCircuitPeeringState(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ExpressRouteCircuitPeeringState)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ExpressRouteCircuitPeeringState rhs = (ExpressRouteCircuitPeeringState) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
