/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for EffectiveSecurityRuleProtocol.
 */
public final class EffectiveSecurityRuleProtocol {
    /** Static value Tcp for EffectiveSecurityRuleProtocol. */
    public static final EffectiveSecurityRuleProtocol TCP = new EffectiveSecurityRuleProtocol("Tcp");

    /** Static value Udp for EffectiveSecurityRuleProtocol. */
    public static final EffectiveSecurityRuleProtocol UDP = new EffectiveSecurityRuleProtocol("Udp");

    /** Static value All for EffectiveSecurityRuleProtocol. */
    public static final EffectiveSecurityRuleProtocol ALL = new EffectiveSecurityRuleProtocol("All");

    private String value;

    /**
     * Creates a custom value for EffectiveSecurityRuleProtocol.
     * @param value the custom value
     */
    public EffectiveSecurityRuleProtocol(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof EffectiveSecurityRuleProtocol)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        EffectiveSecurityRuleProtocol rhs = (EffectiveSecurityRuleProtocol) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
