/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for DhGroup.
 */
public final class DhGroup {
    /** Static value None for DhGroup. */
    public static final DhGroup NONE = new DhGroup("None");

    /** Static value DHGroup1 for DhGroup. */
    public static final DhGroup DHGROUP1 = new DhGroup("DHGroup1");

    /** Static value DHGroup2 for DhGroup. */
    public static final DhGroup DHGROUP2 = new DhGroup("DHGroup2");

    /** Static value DHGroup14 for DhGroup. */
    public static final DhGroup DHGROUP14 = new DhGroup("DHGroup14");

    /** Static value DHGroup2048 for DhGroup. */
    public static final DhGroup DHGROUP2048 = new DhGroup("DHGroup2048");

    /** Static value ECP256 for DhGroup. */
    public static final DhGroup ECP256 = new DhGroup("ECP256");

    /** Static value ECP384 for DhGroup. */
    public static final DhGroup ECP384 = new DhGroup("ECP384");

    /** Static value DHGroup24 for DhGroup. */
    public static final DhGroup DHGROUP24 = new DhGroup("DHGroup24");

    private String value;

    /**
     * Creates a custom value for DhGroup.
     * @param value the custom value
     */
    public DhGroup(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DhGroup)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        DhGroup rhs = (DhGroup) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
