/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.VpnSiteLinkConnectionInner;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class VpnLinkConnectionsInner {
    private VpnLinkConnectionsService service;
    private NetworkManagementClientImpl client;

    public VpnLinkConnectionsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (VpnLinkConnectionsService)retrofit.create(VpnLinkConnectionsService.class);
        this.client = client;
    }

    public PagedList<VpnSiteLinkConnectionInner> listByVpnConnection(String resourceGroupName, String gatewayName, String connectionName) {
        ServiceResponse response = (ServiceResponse)this.listByVpnConnectionSinglePageAsync(resourceGroupName, gatewayName, connectionName).toBlocking().single();
        return new PagedList<VpnSiteLinkConnectionInner>((Page)response.body()){

            public Page<VpnSiteLinkConnectionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VpnLinkConnectionsInner.this.listByVpnConnectionNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VpnSiteLinkConnectionInner>> listByVpnConnectionAsync(String resourceGroupName, String gatewayName, String connectionName, ListOperationCallback<VpnSiteLinkConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByVpnConnectionSinglePageAsync(resourceGroupName, gatewayName, connectionName), (Func1)new Func1<String, Observable<ServiceResponse<Page<VpnSiteLinkConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteLinkConnectionInner>>> call(String nextPageLink) {
                return VpnLinkConnectionsInner.this.listByVpnConnectionNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VpnSiteLinkConnectionInner>> listByVpnConnectionAsync(String resourceGroupName, String gatewayName, String connectionName) {
        return this.listByVpnConnectionWithServiceResponseAsync(resourceGroupName, gatewayName, connectionName).map((Func1)new Func1<ServiceResponse<Page<VpnSiteLinkConnectionInner>>, Page<VpnSiteLinkConnectionInner>>(){

            public Page<VpnSiteLinkConnectionInner> call(ServiceResponse<Page<VpnSiteLinkConnectionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnSiteLinkConnectionInner>>> listByVpnConnectionWithServiceResponseAsync(String resourceGroupName, String gatewayName, String connectionName) {
        return this.listByVpnConnectionSinglePageAsync(resourceGroupName, gatewayName, connectionName).concatMap((Func1)new Func1<ServiceResponse<Page<VpnSiteLinkConnectionInner>>, Observable<ServiceResponse<Page<VpnSiteLinkConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteLinkConnectionInner>>> call(ServiceResponse<Page<VpnSiteLinkConnectionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VpnLinkConnectionsInner.this.listByVpnConnectionNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnSiteLinkConnectionInner>>> listByVpnConnectionSinglePageAsync(String resourceGroupName, String gatewayName, String connectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (gatewayName == null) {
            throw new IllegalArgumentException("Parameter gatewayName is required and cannot be null.");
        }
        if (connectionName == null) {
            throw new IllegalArgumentException("Parameter connectionName is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.listByVpnConnection(this.client.subscriptionId(), resourceGroupName, gatewayName, connectionName, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnSiteLinkConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteLinkConnectionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VpnLinkConnectionsInner.this.listByVpnConnectionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VpnSiteLinkConnectionInner>> listByVpnConnectionDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VpnSiteLinkConnectionInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<VpnSiteLinkConnectionInner> listByVpnConnectionNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByVpnConnectionNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VpnSiteLinkConnectionInner>((Page)response.body()){

            public Page<VpnSiteLinkConnectionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VpnLinkConnectionsInner.this.listByVpnConnectionNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VpnSiteLinkConnectionInner>> listByVpnConnectionNextAsync(String nextPageLink, ServiceFuture<List<VpnSiteLinkConnectionInner>> serviceFuture, ListOperationCallback<VpnSiteLinkConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByVpnConnectionNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VpnSiteLinkConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteLinkConnectionInner>>> call(String nextPageLink) {
                return VpnLinkConnectionsInner.this.listByVpnConnectionNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VpnSiteLinkConnectionInner>> listByVpnConnectionNextAsync(String nextPageLink) {
        return this.listByVpnConnectionNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VpnSiteLinkConnectionInner>>, Page<VpnSiteLinkConnectionInner>>(){

            public Page<VpnSiteLinkConnectionInner> call(ServiceResponse<Page<VpnSiteLinkConnectionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnSiteLinkConnectionInner>>> listByVpnConnectionNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByVpnConnectionNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VpnSiteLinkConnectionInner>>, Observable<ServiceResponse<Page<VpnSiteLinkConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteLinkConnectionInner>>> call(ServiceResponse<Page<VpnSiteLinkConnectionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VpnLinkConnectionsInner.this.listByVpnConnectionNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnSiteLinkConnectionInner>>> listByVpnConnectionNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByVpnConnectionNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnSiteLinkConnectionInner>>>>(){

            public Observable<ServiceResponse<Page<VpnSiteLinkConnectionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VpnLinkConnectionsInner.this.listByVpnConnectionNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VpnSiteLinkConnectionInner>> listByVpnConnectionNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VpnSiteLinkConnectionInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    static interface VpnLinkConnectionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnLinkConnections listByVpnConnection"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnGateways/{gatewayName}/vpnConnections/{connectionName}/vpnLinkConnections")
        public Observable<Response<ResponseBody>> listByVpnConnection(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="gatewayName") String var3, @Path(value="connectionName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnLinkConnections listByVpnConnectionNext"})
        @GET
        public Observable<Response<ResponseBody>> listByVpnConnectionNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

