/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.VirtualNetworkTapInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class VirtualNetworkTapsInner
implements InnerSupportsGet<VirtualNetworkTapInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<VirtualNetworkTapInner> {
    private VirtualNetworkTapsService service;
    private NetworkManagementClientImpl client;

    public VirtualNetworkTapsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (VirtualNetworkTapsService)retrofit.create(VirtualNetworkTapsService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String tapName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, tapName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String tapName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, tapName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String tapName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, tapName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String tapName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (tapName == null) {
            throw new IllegalArgumentException("Parameter tapName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, tapName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String tapName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, tapName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String tapName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, tapName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String tapName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, tapName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String tapName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (tapName == null) {
            throw new IllegalArgumentException("Parameter tapName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.beginDelete(resourceGroupName, tapName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkTapsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VirtualNetworkTapInner getByResourceGroup(String resourceGroupName, String tapName) {
        return (VirtualNetworkTapInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, tapName).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualNetworkTapInner> getByResourceGroupAsync(String resourceGroupName, String tapName, ServiceCallback<VirtualNetworkTapInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, tapName), serviceCallback);
    }

    public Observable<VirtualNetworkTapInner> getByResourceGroupAsync(String resourceGroupName, String tapName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, tapName).map((Func1)new Func1<ServiceResponse<VirtualNetworkTapInner>, VirtualNetworkTapInner>(){

            public VirtualNetworkTapInner call(ServiceResponse<VirtualNetworkTapInner> response) {
                return (VirtualNetworkTapInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualNetworkTapInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String tapName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (tapName == null) {
            throw new IllegalArgumentException("Parameter tapName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.getByResourceGroup(resourceGroupName, tapName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualNetworkTapInner>>>(){

            public Observable<ServiceResponse<VirtualNetworkTapInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkTapsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualNetworkTapInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualNetworkTapInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VirtualNetworkTapInner createOrUpdate(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters) {
        return (VirtualNetworkTapInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, tapName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<VirtualNetworkTapInner> createOrUpdateAsync(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters, ServiceCallback<VirtualNetworkTapInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, tapName, parameters), serviceCallback);
    }

    public Observable<VirtualNetworkTapInner> createOrUpdateAsync(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, tapName, parameters).map((Func1)new Func1<ServiceResponse<VirtualNetworkTapInner>, VirtualNetworkTapInner>(){

            public VirtualNetworkTapInner call(ServiceResponse<VirtualNetworkTapInner> response) {
                return (VirtualNetworkTapInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualNetworkTapInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (tapName == null) {
            throw new IllegalArgumentException("Parameter tapName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, tapName, this.client.subscriptionId(), parameters, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualNetworkTapInner>(){}.getType());
    }

    public VirtualNetworkTapInner beginCreateOrUpdate(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters) {
        return (VirtualNetworkTapInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, tapName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualNetworkTapInner> beginCreateOrUpdateAsync(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters, ServiceCallback<VirtualNetworkTapInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, tapName, parameters), serviceCallback);
    }

    public Observable<VirtualNetworkTapInner> beginCreateOrUpdateAsync(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, tapName, parameters).map((Func1)new Func1<ServiceResponse<VirtualNetworkTapInner>, VirtualNetworkTapInner>(){

            public VirtualNetworkTapInner call(ServiceResponse<VirtualNetworkTapInner> response) {
                return (VirtualNetworkTapInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualNetworkTapInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (tapName == null) {
            throw new IllegalArgumentException("Parameter tapName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-06-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, tapName, this.client.subscriptionId(), parameters, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualNetworkTapInner>>>(){

            public Observable<ServiceResponse<VirtualNetworkTapInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkTapsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualNetworkTapInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualNetworkTapInner>(){}.getType()).register(201, new TypeToken<VirtualNetworkTapInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VirtualNetworkTapInner updateTags(String resourceGroupName, String tapName) {
        return (VirtualNetworkTapInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, tapName).toBlocking().last()).body());
    }

    public ServiceFuture<VirtualNetworkTapInner> updateTagsAsync(String resourceGroupName, String tapName, ServiceCallback<VirtualNetworkTapInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, tapName), serviceCallback);
    }

    public Observable<VirtualNetworkTapInner> updateTagsAsync(String resourceGroupName, String tapName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, tapName).map((Func1)new Func1<ServiceResponse<VirtualNetworkTapInner>, VirtualNetworkTapInner>(){

            public VirtualNetworkTapInner call(ServiceResponse<VirtualNetworkTapInner> response) {
                return (VirtualNetworkTapInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualNetworkTapInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String tapName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (tapName == null) {
            throw new IllegalArgumentException("Parameter tapName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Object tags = null;
        TagsObject tapParameters = new TagsObject();
        tapParameters.withTags(null);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(resourceGroupName, tapName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), tapParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualNetworkTapInner>(){}.getType());
    }

    public VirtualNetworkTapInner updateTags(String resourceGroupName, String tapName, Map<String, String> tags) {
        return (VirtualNetworkTapInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, tapName, tags).toBlocking().last()).body());
    }

    public ServiceFuture<VirtualNetworkTapInner> updateTagsAsync(String resourceGroupName, String tapName, Map<String, String> tags, ServiceCallback<VirtualNetworkTapInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, tapName, tags), serviceCallback);
    }

    public Observable<VirtualNetworkTapInner> updateTagsAsync(String resourceGroupName, String tapName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, tapName, tags).map((Func1)new Func1<ServiceResponse<VirtualNetworkTapInner>, VirtualNetworkTapInner>(){

            public VirtualNetworkTapInner call(ServiceResponse<VirtualNetworkTapInner> response) {
                return (VirtualNetworkTapInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualNetworkTapInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String tapName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (tapName == null) {
            throw new IllegalArgumentException("Parameter tapName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-06-01";
        TagsObject tapParameters = new TagsObject();
        tapParameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(resourceGroupName, tapName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), tapParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualNetworkTapInner>(){}.getType());
    }

    public VirtualNetworkTapInner beginUpdateTags(String resourceGroupName, String tapName) {
        return (VirtualNetworkTapInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, tapName).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualNetworkTapInner> beginUpdateTagsAsync(String resourceGroupName, String tapName, ServiceCallback<VirtualNetworkTapInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, tapName), serviceCallback);
    }

    public Observable<VirtualNetworkTapInner> beginUpdateTagsAsync(String resourceGroupName, String tapName) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, tapName).map((Func1)new Func1<ServiceResponse<VirtualNetworkTapInner>, VirtualNetworkTapInner>(){

            public VirtualNetworkTapInner call(ServiceResponse<VirtualNetworkTapInner> response) {
                return (VirtualNetworkTapInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualNetworkTapInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String tapName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (tapName == null) {
            throw new IllegalArgumentException("Parameter tapName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Object tags = null;
        TagsObject tapParameters = new TagsObject();
        tapParameters.withTags(null);
        return this.service.beginUpdateTags(resourceGroupName, tapName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), tapParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualNetworkTapInner>>>(){

            public Observable<ServiceResponse<VirtualNetworkTapInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkTapsInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public VirtualNetworkTapInner beginUpdateTags(String resourceGroupName, String tapName, Map<String, String> tags) {
        return (VirtualNetworkTapInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, tapName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualNetworkTapInner> beginUpdateTagsAsync(String resourceGroupName, String tapName, Map<String, String> tags, ServiceCallback<VirtualNetworkTapInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, tapName, tags), serviceCallback);
    }

    public Observable<VirtualNetworkTapInner> beginUpdateTagsAsync(String resourceGroupName, String tapName, Map<String, String> tags) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, tapName, tags).map((Func1)new Func1<ServiceResponse<VirtualNetworkTapInner>, VirtualNetworkTapInner>(){

            public VirtualNetworkTapInner call(ServiceResponse<VirtualNetworkTapInner> response) {
                return (VirtualNetworkTapInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualNetworkTapInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String tapName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (tapName == null) {
            throw new IllegalArgumentException("Parameter tapName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-06-01";
        TagsObject tapParameters = new TagsObject();
        tapParameters.withTags(tags);
        return this.service.beginUpdateTags(resourceGroupName, tapName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), tapParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualNetworkTapInner>>>(){

            public Observable<ServiceResponse<VirtualNetworkTapInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkTapsInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualNetworkTapInner> beginUpdateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualNetworkTapInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualNetworkTapInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<VirtualNetworkTapInner>((Page)response.body()){

            public Page<VirtualNetworkTapInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualNetworkTapsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualNetworkTapInner>> listAsync(ListOperationCallback<VirtualNetworkTapInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(String nextPageLink) {
                return VirtualNetworkTapsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualNetworkTapInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<VirtualNetworkTapInner>>, Page<VirtualNetworkTapInner>>(){

            public Page<VirtualNetworkTapInner> call(ServiceResponse<Page<VirtualNetworkTapInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<VirtualNetworkTapInner>>, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(ServiceResponse<Page<VirtualNetworkTapInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualNetworkTapsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.list(this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualNetworkTapsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualNetworkTapInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualNetworkTapInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualNetworkTapInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<VirtualNetworkTapInner>((Page)response.body()){

            public Page<VirtualNetworkTapInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualNetworkTapsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualNetworkTapInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<VirtualNetworkTapInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(String nextPageLink) {
                return VirtualNetworkTapsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualNetworkTapInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<VirtualNetworkTapInner>>, Page<VirtualNetworkTapInner>>(){

            public Page<VirtualNetworkTapInner> call(ServiceResponse<Page<VirtualNetworkTapInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualNetworkTapInner>>, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(ServiceResponse<Page<VirtualNetworkTapInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualNetworkTapsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualNetworkTapsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualNetworkTapInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualNetworkTapInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualNetworkTapInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualNetworkTapInner>((Page)response.body()){

            public Page<VirtualNetworkTapInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualNetworkTapsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualNetworkTapInner>> listNextAsync(String nextPageLink, ServiceFuture<List<VirtualNetworkTapInner>> serviceFuture, ListOperationCallback<VirtualNetworkTapInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(String nextPageLink) {
                return VirtualNetworkTapsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualNetworkTapInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VirtualNetworkTapInner>>, Page<VirtualNetworkTapInner>>(){

            public Page<VirtualNetworkTapInner> call(ServiceResponse<Page<VirtualNetworkTapInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualNetworkTapInner>>, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(ServiceResponse<Page<VirtualNetworkTapInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualNetworkTapsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualNetworkTapsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualNetworkTapInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualNetworkTapInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualNetworkTapInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualNetworkTapInner>((Page)response.body()){

            public Page<VirtualNetworkTapInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualNetworkTapsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualNetworkTapInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<VirtualNetworkTapInner>> serviceFuture, ListOperationCallback<VirtualNetworkTapInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(String nextPageLink) {
                return VirtualNetworkTapsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualNetworkTapInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VirtualNetworkTapInner>>, Page<VirtualNetworkTapInner>>(){

            public Page<VirtualNetworkTapInner> call(ServiceResponse<Page<VirtualNetworkTapInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualNetworkTapInner>>, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(ServiceResponse<Page<VirtualNetworkTapInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualNetworkTapsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualNetworkTapInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkTapInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualNetworkTapsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualNetworkTapInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualNetworkTapInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface VirtualNetworkTapsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkTaps delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkTaps/{tapName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="tapName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkTaps beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkTaps/{tapName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="tapName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkTaps getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkTaps/{tapName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="tapName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkTaps createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkTaps/{tapName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="tapName") String var2, @Path(value="subscriptionId") String var3, @Body VirtualNetworkTapInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkTaps beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkTaps/{tapName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="tapName") String var2, @Path(value="subscriptionId") String var3, @Body VirtualNetworkTapInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkTaps updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkTaps/{tapName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="resourceGroupName") String var1, @Path(value="tapName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkTaps beginUpdateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkTaps/{tapName}")
        public Observable<Response<ResponseBody>> beginUpdateTags(@Path(value="resourceGroupName") String var1, @Path(value="tapName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkTaps list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/virtualNetworkTaps")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkTaps listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkTaps")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkTaps listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkTaps listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

