/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.P2SVpnServerConfigurationInner;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class P2sVpnServerConfigurationsInner {
    private P2sVpnServerConfigurationsService service;
    private NetworkManagementClientImpl client;

    public P2sVpnServerConfigurationsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (P2sVpnServerConfigurationsService)retrofit.create(P2sVpnServerConfigurationsService.class);
        this.client = client;
    }

    public P2SVpnServerConfigurationInner get(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName) {
        return (P2SVpnServerConfigurationInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName).toBlocking().single()).body());
    }

    public ServiceFuture<P2SVpnServerConfigurationInner> getAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName, ServiceCallback<P2SVpnServerConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName), serviceCallback);
    }

    public Observable<P2SVpnServerConfigurationInner> getAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName) {
        return this.getWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName).map((Func1)new Func1<ServiceResponse<P2SVpnServerConfigurationInner>, P2SVpnServerConfigurationInner>(){

            public P2SVpnServerConfigurationInner call(ServiceResponse<P2SVpnServerConfigurationInner> response) {
                return (P2SVpnServerConfigurationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<P2SVpnServerConfigurationInner>> getWithServiceResponseAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWanName == null) {
            throw new IllegalArgumentException("Parameter virtualWanName is required and cannot be null.");
        }
        if (p2SVpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter p2SVpnServerConfigurationName is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, virtualWanName, p2SVpnServerConfigurationName, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<P2SVpnServerConfigurationInner>>>(){

            public Observable<ServiceResponse<P2SVpnServerConfigurationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = P2sVpnServerConfigurationsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<P2SVpnServerConfigurationInner> getDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<P2SVpnServerConfigurationInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public P2SVpnServerConfigurationInner createOrUpdate(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName, P2SVpnServerConfigurationInner p2SVpnServerConfigurationParameters) {
        return (P2SVpnServerConfigurationInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName, p2SVpnServerConfigurationParameters).toBlocking().last()).body());
    }

    public ServiceFuture<P2SVpnServerConfigurationInner> createOrUpdateAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName, P2SVpnServerConfigurationInner p2SVpnServerConfigurationParameters, ServiceCallback<P2SVpnServerConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName, p2SVpnServerConfigurationParameters), serviceCallback);
    }

    public Observable<P2SVpnServerConfigurationInner> createOrUpdateAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName, P2SVpnServerConfigurationInner p2SVpnServerConfigurationParameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName, p2SVpnServerConfigurationParameters).map((Func1)new Func1<ServiceResponse<P2SVpnServerConfigurationInner>, P2SVpnServerConfigurationInner>(){

            public P2SVpnServerConfigurationInner call(ServiceResponse<P2SVpnServerConfigurationInner> response) {
                return (P2SVpnServerConfigurationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<P2SVpnServerConfigurationInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName, P2SVpnServerConfigurationInner p2SVpnServerConfigurationParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWanName == null) {
            throw new IllegalArgumentException("Parameter virtualWanName is required and cannot be null.");
        }
        if (p2SVpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter p2SVpnServerConfigurationName is required and cannot be null.");
        }
        if (p2SVpnServerConfigurationParameters == null) {
            throw new IllegalArgumentException("Parameter p2SVpnServerConfigurationParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)p2SVpnServerConfigurationParameters));
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, virtualWanName, p2SVpnServerConfigurationName, "2019-06-01", p2SVpnServerConfigurationParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<P2SVpnServerConfigurationInner>(){}.getType());
    }

    public P2SVpnServerConfigurationInner beginCreateOrUpdate(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName, P2SVpnServerConfigurationInner p2SVpnServerConfigurationParameters) {
        return (P2SVpnServerConfigurationInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName, p2SVpnServerConfigurationParameters).toBlocking().single()).body());
    }

    public ServiceFuture<P2SVpnServerConfigurationInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName, P2SVpnServerConfigurationInner p2SVpnServerConfigurationParameters, ServiceCallback<P2SVpnServerConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName, p2SVpnServerConfigurationParameters), serviceCallback);
    }

    public Observable<P2SVpnServerConfigurationInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName, P2SVpnServerConfigurationInner p2SVpnServerConfigurationParameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName, p2SVpnServerConfigurationParameters).map((Func1)new Func1<ServiceResponse<P2SVpnServerConfigurationInner>, P2SVpnServerConfigurationInner>(){

            public P2SVpnServerConfigurationInner call(ServiceResponse<P2SVpnServerConfigurationInner> response) {
                return (P2SVpnServerConfigurationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<P2SVpnServerConfigurationInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName, P2SVpnServerConfigurationInner p2SVpnServerConfigurationParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWanName == null) {
            throw new IllegalArgumentException("Parameter virtualWanName is required and cannot be null.");
        }
        if (p2SVpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter p2SVpnServerConfigurationName is required and cannot be null.");
        }
        if (p2SVpnServerConfigurationParameters == null) {
            throw new IllegalArgumentException("Parameter p2SVpnServerConfigurationParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)p2SVpnServerConfigurationParameters));
        String apiVersion = "2019-06-01";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, virtualWanName, p2SVpnServerConfigurationName, "2019-06-01", p2SVpnServerConfigurationParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<P2SVpnServerConfigurationInner>>>(){

            public Observable<ServiceResponse<P2SVpnServerConfigurationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = P2sVpnServerConfigurationsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<P2SVpnServerConfigurationInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<P2SVpnServerConfigurationInner>(){}.getType()).register(201, new TypeToken<P2SVpnServerConfigurationInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public void delete(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWanName == null) {
            throw new IllegalArgumentException("Parameter virtualWanName is required and cannot be null.");
        }
        if (p2SVpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter p2SVpnServerConfigurationName is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, virtualWanName, p2SVpnServerConfigurationName, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualWanName, p2SVpnServerConfigurationName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String virtualWanName, String p2SVpnServerConfigurationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWanName == null) {
            throw new IllegalArgumentException("Parameter virtualWanName is required and cannot be null.");
        }
        if (p2SVpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter p2SVpnServerConfigurationName is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, virtualWanName, p2SVpnServerConfigurationName, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = P2sVpnServerConfigurationsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<P2SVpnServerConfigurationInner> listByVirtualWan(String resourceGroupName, String virtualWanName) {
        ServiceResponse response = (ServiceResponse)this.listByVirtualWanSinglePageAsync(resourceGroupName, virtualWanName).toBlocking().single();
        return new PagedList<P2SVpnServerConfigurationInner>((Page)response.body()){

            public Page<P2SVpnServerConfigurationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)P2sVpnServerConfigurationsInner.this.listByVirtualWanNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<P2SVpnServerConfigurationInner>> listByVirtualWanAsync(String resourceGroupName, String virtualWanName, ListOperationCallback<P2SVpnServerConfigurationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByVirtualWanSinglePageAsync(resourceGroupName, virtualWanName), (Func1)new Func1<String, Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>> call(String nextPageLink) {
                return P2sVpnServerConfigurationsInner.this.listByVirtualWanNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<P2SVpnServerConfigurationInner>> listByVirtualWanAsync(String resourceGroupName, String virtualWanName) {
        return this.listByVirtualWanWithServiceResponseAsync(resourceGroupName, virtualWanName).map((Func1)new Func1<ServiceResponse<Page<P2SVpnServerConfigurationInner>>, Page<P2SVpnServerConfigurationInner>>(){

            public Page<P2SVpnServerConfigurationInner> call(ServiceResponse<Page<P2SVpnServerConfigurationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>> listByVirtualWanWithServiceResponseAsync(String resourceGroupName, String virtualWanName) {
        return this.listByVirtualWanSinglePageAsync(resourceGroupName, virtualWanName).concatMap((Func1)new Func1<ServiceResponse<Page<P2SVpnServerConfigurationInner>>, Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>> call(ServiceResponse<Page<P2SVpnServerConfigurationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(P2sVpnServerConfigurationsInner.this.listByVirtualWanNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>> listByVirtualWanSinglePageAsync(String resourceGroupName, String virtualWanName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualWanName == null) {
            throw new IllegalArgumentException("Parameter virtualWanName is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.listByVirtualWan(this.client.subscriptionId(), resourceGroupName, virtualWanName, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = P2sVpnServerConfigurationsInner.this.listByVirtualWanDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<P2SVpnServerConfigurationInner>> listByVirtualWanDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<P2SVpnServerConfigurationInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<P2SVpnServerConfigurationInner> listByVirtualWanNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByVirtualWanNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<P2SVpnServerConfigurationInner>((Page)response.body()){

            public Page<P2SVpnServerConfigurationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)P2sVpnServerConfigurationsInner.this.listByVirtualWanNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<P2SVpnServerConfigurationInner>> listByVirtualWanNextAsync(String nextPageLink, ServiceFuture<List<P2SVpnServerConfigurationInner>> serviceFuture, ListOperationCallback<P2SVpnServerConfigurationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByVirtualWanNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>> call(String nextPageLink) {
                return P2sVpnServerConfigurationsInner.this.listByVirtualWanNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<P2SVpnServerConfigurationInner>> listByVirtualWanNextAsync(String nextPageLink) {
        return this.listByVirtualWanNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<P2SVpnServerConfigurationInner>>, Page<P2SVpnServerConfigurationInner>>(){

            public Page<P2SVpnServerConfigurationInner> call(ServiceResponse<Page<P2SVpnServerConfigurationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>> listByVirtualWanNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByVirtualWanNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<P2SVpnServerConfigurationInner>>, Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>> call(ServiceResponse<Page<P2SVpnServerConfigurationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(P2sVpnServerConfigurationsInner.this.listByVirtualWanNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>> listByVirtualWanNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByVirtualWanNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<P2SVpnServerConfigurationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = P2sVpnServerConfigurationsInner.this.listByVirtualWanNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<P2SVpnServerConfigurationInner>> listByVirtualWanNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<P2SVpnServerConfigurationInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    static interface P2sVpnServerConfigurationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnServerConfigurations get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWanName}/p2sVpnServerConfigurations/{p2SVpnServerConfigurationName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualWanName") String var3, @Path(value="p2SVpnServerConfigurationName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnServerConfigurations createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWanName}/p2sVpnServerConfigurations/{p2SVpnServerConfigurationName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualWanName") String var3, @Path(value="p2SVpnServerConfigurationName") String var4, @Query(value="api-version") String var5, @Body P2SVpnServerConfigurationInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnServerConfigurations beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWanName}/p2sVpnServerConfigurations/{p2SVpnServerConfigurationName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualWanName") String var3, @Path(value="p2SVpnServerConfigurationName") String var4, @Query(value="api-version") String var5, @Body P2SVpnServerConfigurationInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnServerConfigurations delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWanName}/p2sVpnServerConfigurations/{p2SVpnServerConfigurationName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualWanName") String var3, @Path(value="p2SVpnServerConfigurationName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnServerConfigurations beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWanName}/p2sVpnServerConfigurations/{p2SVpnServerConfigurationName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualWanName") String var3, @Path(value="p2SVpnServerConfigurationName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnServerConfigurations listByVirtualWan"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWanName}/p2sVpnServerConfigurations")
        public Observable<Response<ResponseBody>> listByVirtualWan(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="virtualWanName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.P2sVpnServerConfigurations listByVirtualWanNext"})
        @GET
        public Observable<Response<ResponseBody>> listByVirtualWanNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

