/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.network.implementation.ExpressRouteConnectionInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteConnectionListInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ExpressRouteConnectionsInner {
    private ExpressRouteConnectionsService service;
    private NetworkManagementClientImpl client;

    public ExpressRouteConnectionsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (ExpressRouteConnectionsService)retrofit.create(ExpressRouteConnectionsService.class);
        this.client = client;
    }

    public ExpressRouteConnectionInner createOrUpdate(String resourceGroupName, String expressRouteGatewayName, String connectionName, ExpressRouteConnectionInner putExpressRouteConnectionParameters) {
        return (ExpressRouteConnectionInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, connectionName, putExpressRouteConnectionParameters).toBlocking().last()).body());
    }

    public ServiceFuture<ExpressRouteConnectionInner> createOrUpdateAsync(String resourceGroupName, String expressRouteGatewayName, String connectionName, ExpressRouteConnectionInner putExpressRouteConnectionParameters, ServiceCallback<ExpressRouteConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, connectionName, putExpressRouteConnectionParameters), serviceCallback);
    }

    public Observable<ExpressRouteConnectionInner> createOrUpdateAsync(String resourceGroupName, String expressRouteGatewayName, String connectionName, ExpressRouteConnectionInner putExpressRouteConnectionParameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, connectionName, putExpressRouteConnectionParameters).map((Func1)new Func1<ServiceResponse<ExpressRouteConnectionInner>, ExpressRouteConnectionInner>(){

            public ExpressRouteConnectionInner call(ServiceResponse<ExpressRouteConnectionInner> response) {
                return (ExpressRouteConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteConnectionInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String expressRouteGatewayName, String connectionName, ExpressRouteConnectionInner putExpressRouteConnectionParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRouteGatewayName == null) {
            throw new IllegalArgumentException("Parameter expressRouteGatewayName is required and cannot be null.");
        }
        if (connectionName == null) {
            throw new IllegalArgumentException("Parameter connectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (putExpressRouteConnectionParameters == null) {
            throw new IllegalArgumentException("Parameter putExpressRouteConnectionParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)putExpressRouteConnectionParameters));
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, expressRouteGatewayName, connectionName, this.client.subscriptionId(), putExpressRouteConnectionParameters, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ExpressRouteConnectionInner>(){}.getType());
    }

    public ExpressRouteConnectionInner beginCreateOrUpdate(String resourceGroupName, String expressRouteGatewayName, String connectionName, ExpressRouteConnectionInner putExpressRouteConnectionParameters) {
        return (ExpressRouteConnectionInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, connectionName, putExpressRouteConnectionParameters).toBlocking().single()).body());
    }

    public ServiceFuture<ExpressRouteConnectionInner> beginCreateOrUpdateAsync(String resourceGroupName, String expressRouteGatewayName, String connectionName, ExpressRouteConnectionInner putExpressRouteConnectionParameters, ServiceCallback<ExpressRouteConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, connectionName, putExpressRouteConnectionParameters), serviceCallback);
    }

    public Observable<ExpressRouteConnectionInner> beginCreateOrUpdateAsync(String resourceGroupName, String expressRouteGatewayName, String connectionName, ExpressRouteConnectionInner putExpressRouteConnectionParameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, connectionName, putExpressRouteConnectionParameters).map((Func1)new Func1<ServiceResponse<ExpressRouteConnectionInner>, ExpressRouteConnectionInner>(){

            public ExpressRouteConnectionInner call(ServiceResponse<ExpressRouteConnectionInner> response) {
                return (ExpressRouteConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteConnectionInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String expressRouteGatewayName, String connectionName, ExpressRouteConnectionInner putExpressRouteConnectionParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRouteGatewayName == null) {
            throw new IllegalArgumentException("Parameter expressRouteGatewayName is required and cannot be null.");
        }
        if (connectionName == null) {
            throw new IllegalArgumentException("Parameter connectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (putExpressRouteConnectionParameters == null) {
            throw new IllegalArgumentException("Parameter putExpressRouteConnectionParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)putExpressRouteConnectionParameters));
        String apiVersion = "2019-06-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, expressRouteGatewayName, connectionName, this.client.subscriptionId(), putExpressRouteConnectionParameters, "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExpressRouteConnectionInner>>>(){

            public Observable<ServiceResponse<ExpressRouteConnectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRouteConnectionsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ExpressRouteConnectionInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ExpressRouteConnectionInner>(){}.getType()).register(201, new TypeToken<ExpressRouteConnectionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ExpressRouteConnectionInner get(String resourceGroupName, String expressRouteGatewayName, String connectionName) {
        return (ExpressRouteConnectionInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, connectionName).toBlocking().single()).body());
    }

    public ServiceFuture<ExpressRouteConnectionInner> getAsync(String resourceGroupName, String expressRouteGatewayName, String connectionName, ServiceCallback<ExpressRouteConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, connectionName), serviceCallback);
    }

    public Observable<ExpressRouteConnectionInner> getAsync(String resourceGroupName, String expressRouteGatewayName, String connectionName) {
        return this.getWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, connectionName).map((Func1)new Func1<ServiceResponse<ExpressRouteConnectionInner>, ExpressRouteConnectionInner>(){

            public ExpressRouteConnectionInner call(ServiceResponse<ExpressRouteConnectionInner> response) {
                return (ExpressRouteConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteConnectionInner>> getWithServiceResponseAsync(String resourceGroupName, String expressRouteGatewayName, String connectionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRouteGatewayName == null) {
            throw new IllegalArgumentException("Parameter expressRouteGatewayName is required and cannot be null.");
        }
        if (connectionName == null) {
            throw new IllegalArgumentException("Parameter connectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.get(resourceGroupName, expressRouteGatewayName, connectionName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExpressRouteConnectionInner>>>(){

            public Observable<ServiceResponse<ExpressRouteConnectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRouteConnectionsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ExpressRouteConnectionInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ExpressRouteConnectionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String expressRouteGatewayName, String connectionName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, connectionName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String expressRouteGatewayName, String connectionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, connectionName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String expressRouteGatewayName, String connectionName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, connectionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String expressRouteGatewayName, String connectionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRouteGatewayName == null) {
            throw new IllegalArgumentException("Parameter expressRouteGatewayName is required and cannot be null.");
        }
        if (connectionName == null) {
            throw new IllegalArgumentException("Parameter connectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, expressRouteGatewayName, connectionName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String expressRouteGatewayName, String connectionName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, connectionName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String expressRouteGatewayName, String connectionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, connectionName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String expressRouteGatewayName, String connectionName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, connectionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String expressRouteGatewayName, String connectionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRouteGatewayName == null) {
            throw new IllegalArgumentException("Parameter expressRouteGatewayName is required and cannot be null.");
        }
        if (connectionName == null) {
            throw new IllegalArgumentException("Parameter connectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.beginDelete(resourceGroupName, expressRouteGatewayName, connectionName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRouteConnectionsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ExpressRouteConnectionListInner list(String resourceGroupName, String expressRouteGatewayName) {
        return (ExpressRouteConnectionListInner)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName).toBlocking().single()).body();
    }

    public ServiceFuture<ExpressRouteConnectionListInner> listAsync(String resourceGroupName, String expressRouteGatewayName, ServiceCallback<ExpressRouteConnectionListInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName), serviceCallback);
    }

    public Observable<ExpressRouteConnectionListInner> listAsync(String resourceGroupName, String expressRouteGatewayName) {
        return this.listWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName).map((Func1)new Func1<ServiceResponse<ExpressRouteConnectionListInner>, ExpressRouteConnectionListInner>(){

            public ExpressRouteConnectionListInner call(ServiceResponse<ExpressRouteConnectionListInner> response) {
                return (ExpressRouteConnectionListInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteConnectionListInner>> listWithServiceResponseAsync(String resourceGroupName, String expressRouteGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRouteGatewayName == null) {
            throw new IllegalArgumentException("Parameter expressRouteGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-06-01";
        return this.service.list(resourceGroupName, expressRouteGatewayName, this.client.subscriptionId(), "2019-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExpressRouteConnectionListInner>>>(){

            public Observable<ServiceResponse<ExpressRouteConnectionListInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRouteConnectionsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ExpressRouteConnectionListInner> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ExpressRouteConnectionListInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ExpressRouteConnectionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteConnections createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways/{expressRouteGatewayName}/expressRouteConnections/{connectionName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="expressRouteGatewayName") String var2, @Path(value="connectionName") String var3, @Path(value="subscriptionId") String var4, @Body ExpressRouteConnectionInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteConnections beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways/{expressRouteGatewayName}/expressRouteConnections/{connectionName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="expressRouteGatewayName") String var2, @Path(value="connectionName") String var3, @Path(value="subscriptionId") String var4, @Body ExpressRouteConnectionInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteConnections get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways/{expressRouteGatewayName}/expressRouteConnections/{connectionName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="expressRouteGatewayName") String var2, @Path(value="connectionName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteConnections delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways/{expressRouteGatewayName}/expressRouteConnections/{connectionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="expressRouteGatewayName") String var2, @Path(value="connectionName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteConnections beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways/{expressRouteGatewayName}/expressRouteConnections/{connectionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="expressRouteGatewayName") String var2, @Path(value="connectionName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteConnections list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways/{expressRouteGatewayName}/expressRouteConnections")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="expressRouteGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);
    }
}

