/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.network.ConnectionMonitorDestination;
import com.microsoft.azure.management.network.ConnectionMonitorQueryResult;
import com.microsoft.azure.management.network.ConnectionMonitorSource;
import com.microsoft.azure.management.network.ProvisioningState;
import com.microsoft.azure.management.network.implementation.ConnectionMonitorResultInner;
import com.microsoft.azure.management.network.model.HasNetworkInterfaces;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasId;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasName;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import java.util.Map;
import org.joda.time.DateTime;
import rx.Completable;
import rx.Observable;

@Fluent
@Beta(value=Beta.SinceVersion.V1_10_0)
public interface ConnectionMonitor
extends HasInner<ConnectionMonitorResultInner>,
HasName,
HasId,
Indexable {
    public String location();

    public Map<String, String> tags();

    public ConnectionMonitorSource source();

    public ConnectionMonitorDestination destination();

    public boolean autoStart();

    public ProvisioningState provisioningState();

    public DateTime startTime();

    public String monitoringStatus();

    public int monitoringIntervalInSeconds();

    @Method
    public void stop();

    @Method
    public Completable stopAsync();

    @Method
    public void start();

    @Method
    public Completable startAsync();

    @Method
    public ConnectionMonitorQueryResult query();

    @Method
    public Observable<ConnectionMonitorQueryResult> queryAsync();

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<ConnectionMonitor>,
        WithSourcePort,
        WithAutoStart,
        WithMonitoringInterval,
        WithTags {
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);

            public WithCreate withTag(String var1, String var2);

            public WithCreate withoutTag(String var1);
        }

        public static interface WithMonitoringInterval {
            public WithCreate withMonitoringInterval(int var1);
        }

        public static interface WithAutoStart {
            @Method
            public WithCreate withoutAutoStart();
        }

        public static interface WithDestinationPort {
            public WithCreate withDestinationPort(int var1);
        }

        public static interface WithDestination {
            public WithDestinationPort withDestinationId(String var1);

            public WithDestinationPort withDestination(HasNetworkInterfaces var1);

            public WithDestinationPort withDestinationAddress(String var1);
        }

        public static interface WithSourcePort {
            public WithDestination withSourcePort(int var1);
        }

        public static interface WithSource {
            public WithDestination withSourceId(String var1);

            public WithDestination withSource(HasNetworkInterfaces var1);
        }
    }

    public static interface Definition
    extends DefinitionStages.WithSource,
    DefinitionStages.WithDestination,
    DefinitionStages.WithDestinationPort,
    DefinitionStages.WithCreate {
    }
}

