/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.PatchRouteFilterRuleInner;
import com.microsoft.azure.management.network.implementation.RouteFilterRuleInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class RouteFilterRulesInner {
    private RouteFilterRulesService service;
    private NetworkManagementClientImpl client;

    public RouteFilterRulesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (RouteFilterRulesService)retrofit.create(RouteFilterRulesService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String routeFilterName, String ruleName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, routeFilterName, ruleName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String routeFilterName, String ruleName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, routeFilterName, ruleName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String routeFilterName, String ruleName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, routeFilterName, ruleName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String routeFilterName, String ruleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (routeFilterName == null) {
            throw new IllegalArgumentException("Parameter routeFilterName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-12-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, routeFilterName, ruleName, this.client.subscriptionId(), "2016-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String routeFilterName, String ruleName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, routeFilterName, ruleName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String routeFilterName, String ruleName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, routeFilterName, ruleName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String routeFilterName, String ruleName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, routeFilterName, ruleName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String routeFilterName, String ruleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (routeFilterName == null) {
            throw new IllegalArgumentException("Parameter routeFilterName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-12-01";
        return this.service.beginDelete(resourceGroupName, routeFilterName, ruleName, this.client.subscriptionId(), "2016-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RouteFilterRulesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RouteFilterRuleInner get(String resourceGroupName, String routeFilterName, String ruleName) {
        return (RouteFilterRuleInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, routeFilterName, ruleName).toBlocking().single()).body());
    }

    public ServiceFuture<RouteFilterRuleInner> getAsync(String resourceGroupName, String routeFilterName, String ruleName, ServiceCallback<RouteFilterRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, routeFilterName, ruleName), serviceCallback);
    }

    public Observable<RouteFilterRuleInner> getAsync(String resourceGroupName, String routeFilterName, String ruleName) {
        return this.getWithServiceResponseAsync(resourceGroupName, routeFilterName, ruleName).map((Func1)new Func1<ServiceResponse<RouteFilterRuleInner>, RouteFilterRuleInner>(){

            public RouteFilterRuleInner call(ServiceResponse<RouteFilterRuleInner> response) {
                return (RouteFilterRuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RouteFilterRuleInner>> getWithServiceResponseAsync(String resourceGroupName, String routeFilterName, String ruleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (routeFilterName == null) {
            throw new IllegalArgumentException("Parameter routeFilterName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-12-01";
        return this.service.get(resourceGroupName, routeFilterName, ruleName, this.client.subscriptionId(), "2016-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RouteFilterRuleInner>>>(){

            public Observable<ServiceResponse<RouteFilterRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RouteFilterRulesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RouteFilterRuleInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RouteFilterRuleInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RouteFilterRuleInner createOrUpdate(String resourceGroupName, String routeFilterName, String ruleName, RouteFilterRuleInner routeFilterRuleParameters) {
        return (RouteFilterRuleInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, routeFilterName, ruleName, routeFilterRuleParameters).toBlocking().last()).body());
    }

    public ServiceFuture<RouteFilterRuleInner> createOrUpdateAsync(String resourceGroupName, String routeFilterName, String ruleName, RouteFilterRuleInner routeFilterRuleParameters, ServiceCallback<RouteFilterRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, routeFilterName, ruleName, routeFilterRuleParameters), serviceCallback);
    }

    public Observable<RouteFilterRuleInner> createOrUpdateAsync(String resourceGroupName, String routeFilterName, String ruleName, RouteFilterRuleInner routeFilterRuleParameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, routeFilterName, ruleName, routeFilterRuleParameters).map((Func1)new Func1<ServiceResponse<RouteFilterRuleInner>, RouteFilterRuleInner>(){

            public RouteFilterRuleInner call(ServiceResponse<RouteFilterRuleInner> response) {
                return (RouteFilterRuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RouteFilterRuleInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String routeFilterName, String ruleName, RouteFilterRuleInner routeFilterRuleParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (routeFilterName == null) {
            throw new IllegalArgumentException("Parameter routeFilterName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (routeFilterRuleParameters == null) {
            throw new IllegalArgumentException("Parameter routeFilterRuleParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)routeFilterRuleParameters));
        String apiVersion = "2016-12-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, routeFilterName, ruleName, this.client.subscriptionId(), routeFilterRuleParameters, "2016-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RouteFilterRuleInner>(){}.getType());
    }

    public RouteFilterRuleInner beginCreateOrUpdate(String resourceGroupName, String routeFilterName, String ruleName, RouteFilterRuleInner routeFilterRuleParameters) {
        return (RouteFilterRuleInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, routeFilterName, ruleName, routeFilterRuleParameters).toBlocking().single()).body());
    }

    public ServiceFuture<RouteFilterRuleInner> beginCreateOrUpdateAsync(String resourceGroupName, String routeFilterName, String ruleName, RouteFilterRuleInner routeFilterRuleParameters, ServiceCallback<RouteFilterRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, routeFilterName, ruleName, routeFilterRuleParameters), serviceCallback);
    }

    public Observable<RouteFilterRuleInner> beginCreateOrUpdateAsync(String resourceGroupName, String routeFilterName, String ruleName, RouteFilterRuleInner routeFilterRuleParameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, routeFilterName, ruleName, routeFilterRuleParameters).map((Func1)new Func1<ServiceResponse<RouteFilterRuleInner>, RouteFilterRuleInner>(){

            public RouteFilterRuleInner call(ServiceResponse<RouteFilterRuleInner> response) {
                return (RouteFilterRuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RouteFilterRuleInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String routeFilterName, String ruleName, RouteFilterRuleInner routeFilterRuleParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (routeFilterName == null) {
            throw new IllegalArgumentException("Parameter routeFilterName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (routeFilterRuleParameters == null) {
            throw new IllegalArgumentException("Parameter routeFilterRuleParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)routeFilterRuleParameters));
        String apiVersion = "2016-12-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, routeFilterName, ruleName, this.client.subscriptionId(), routeFilterRuleParameters, "2016-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RouteFilterRuleInner>>>(){

            public Observable<ServiceResponse<RouteFilterRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RouteFilterRulesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RouteFilterRuleInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RouteFilterRuleInner>(){}.getType()).register(201, new TypeToken<RouteFilterRuleInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RouteFilterRuleInner update(String resourceGroupName, String routeFilterName, String ruleName, PatchRouteFilterRuleInner routeFilterRuleParameters) {
        return (RouteFilterRuleInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, routeFilterName, ruleName, routeFilterRuleParameters).toBlocking().last()).body());
    }

    public ServiceFuture<RouteFilterRuleInner> updateAsync(String resourceGroupName, String routeFilterName, String ruleName, PatchRouteFilterRuleInner routeFilterRuleParameters, ServiceCallback<RouteFilterRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, routeFilterName, ruleName, routeFilterRuleParameters), serviceCallback);
    }

    public Observable<RouteFilterRuleInner> updateAsync(String resourceGroupName, String routeFilterName, String ruleName, PatchRouteFilterRuleInner routeFilterRuleParameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, routeFilterName, ruleName, routeFilterRuleParameters).map((Func1)new Func1<ServiceResponse<RouteFilterRuleInner>, RouteFilterRuleInner>(){

            public RouteFilterRuleInner call(ServiceResponse<RouteFilterRuleInner> response) {
                return (RouteFilterRuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RouteFilterRuleInner>> updateWithServiceResponseAsync(String resourceGroupName, String routeFilterName, String ruleName, PatchRouteFilterRuleInner routeFilterRuleParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (routeFilterName == null) {
            throw new IllegalArgumentException("Parameter routeFilterName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (routeFilterRuleParameters == null) {
            throw new IllegalArgumentException("Parameter routeFilterRuleParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)routeFilterRuleParameters));
        String apiVersion = "2016-12-01";
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, routeFilterName, ruleName, this.client.subscriptionId(), routeFilterRuleParameters, "2016-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RouteFilterRuleInner>(){}.getType());
    }

    public RouteFilterRuleInner beginUpdate(String resourceGroupName, String routeFilterName, String ruleName, PatchRouteFilterRuleInner routeFilterRuleParameters) {
        return (RouteFilterRuleInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, routeFilterName, ruleName, routeFilterRuleParameters).toBlocking().single()).body());
    }

    public ServiceFuture<RouteFilterRuleInner> beginUpdateAsync(String resourceGroupName, String routeFilterName, String ruleName, PatchRouteFilterRuleInner routeFilterRuleParameters, ServiceCallback<RouteFilterRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, routeFilterName, ruleName, routeFilterRuleParameters), serviceCallback);
    }

    public Observable<RouteFilterRuleInner> beginUpdateAsync(String resourceGroupName, String routeFilterName, String ruleName, PatchRouteFilterRuleInner routeFilterRuleParameters) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, routeFilterName, ruleName, routeFilterRuleParameters).map((Func1)new Func1<ServiceResponse<RouteFilterRuleInner>, RouteFilterRuleInner>(){

            public RouteFilterRuleInner call(ServiceResponse<RouteFilterRuleInner> response) {
                return (RouteFilterRuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RouteFilterRuleInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String routeFilterName, String ruleName, PatchRouteFilterRuleInner routeFilterRuleParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (routeFilterName == null) {
            throw new IllegalArgumentException("Parameter routeFilterName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (routeFilterRuleParameters == null) {
            throw new IllegalArgumentException("Parameter routeFilterRuleParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)routeFilterRuleParameters));
        String apiVersion = "2016-12-01";
        return this.service.beginUpdate(resourceGroupName, routeFilterName, ruleName, this.client.subscriptionId(), routeFilterRuleParameters, "2016-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RouteFilterRuleInner>>>(){

            public Observable<ServiceResponse<RouteFilterRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RouteFilterRulesInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RouteFilterRuleInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RouteFilterRuleInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RouteFilterRuleInner> listByRouteFilter(String resourceGroupName, String routeFilterName) {
        ServiceResponse response = (ServiceResponse)this.listByRouteFilterSinglePageAsync(resourceGroupName, routeFilterName).toBlocking().single();
        return new PagedList<RouteFilterRuleInner>((Page)response.body()){

            public Page<RouteFilterRuleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RouteFilterRulesInner.this.listByRouteFilterNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RouteFilterRuleInner>> listByRouteFilterAsync(String resourceGroupName, String routeFilterName, ListOperationCallback<RouteFilterRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByRouteFilterSinglePageAsync(resourceGroupName, routeFilterName), (Func1)new Func1<String, Observable<ServiceResponse<Page<RouteFilterRuleInner>>>>(){

            public Observable<ServiceResponse<Page<RouteFilterRuleInner>>> call(String nextPageLink) {
                return RouteFilterRulesInner.this.listByRouteFilterNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RouteFilterRuleInner>> listByRouteFilterAsync(String resourceGroupName, String routeFilterName) {
        return this.listByRouteFilterWithServiceResponseAsync(resourceGroupName, routeFilterName).map((Func1)new Func1<ServiceResponse<Page<RouteFilterRuleInner>>, Page<RouteFilterRuleInner>>(){

            public Page<RouteFilterRuleInner> call(ServiceResponse<Page<RouteFilterRuleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RouteFilterRuleInner>>> listByRouteFilterWithServiceResponseAsync(String resourceGroupName, String routeFilterName) {
        return this.listByRouteFilterSinglePageAsync(resourceGroupName, routeFilterName).concatMap((Func1)new Func1<ServiceResponse<Page<RouteFilterRuleInner>>, Observable<ServiceResponse<Page<RouteFilterRuleInner>>>>(){

            public Observable<ServiceResponse<Page<RouteFilterRuleInner>>> call(ServiceResponse<Page<RouteFilterRuleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RouteFilterRulesInner.this.listByRouteFilterNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RouteFilterRuleInner>>> listByRouteFilterSinglePageAsync(String resourceGroupName, String routeFilterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (routeFilterName == null) {
            throw new IllegalArgumentException("Parameter routeFilterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-12-01";
        return this.service.listByRouteFilter(resourceGroupName, routeFilterName, this.client.subscriptionId(), "2016-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RouteFilterRuleInner>>>>(){

            public Observable<ServiceResponse<Page<RouteFilterRuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RouteFilterRulesInner.this.listByRouteFilterDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RouteFilterRuleInner>> listByRouteFilterDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RouteFilterRuleInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RouteFilterRuleInner> listByRouteFilterNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByRouteFilterNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RouteFilterRuleInner>((Page)response.body()){

            public Page<RouteFilterRuleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RouteFilterRulesInner.this.listByRouteFilterNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RouteFilterRuleInner>> listByRouteFilterNextAsync(String nextPageLink, ServiceFuture<List<RouteFilterRuleInner>> serviceFuture, ListOperationCallback<RouteFilterRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByRouteFilterNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RouteFilterRuleInner>>>>(){

            public Observable<ServiceResponse<Page<RouteFilterRuleInner>>> call(String nextPageLink) {
                return RouteFilterRulesInner.this.listByRouteFilterNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RouteFilterRuleInner>> listByRouteFilterNextAsync(String nextPageLink) {
        return this.listByRouteFilterNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RouteFilterRuleInner>>, Page<RouteFilterRuleInner>>(){

            public Page<RouteFilterRuleInner> call(ServiceResponse<Page<RouteFilterRuleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RouteFilterRuleInner>>> listByRouteFilterNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByRouteFilterNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RouteFilterRuleInner>>, Observable<ServiceResponse<Page<RouteFilterRuleInner>>>>(){

            public Observable<ServiceResponse<Page<RouteFilterRuleInner>>> call(ServiceResponse<Page<RouteFilterRuleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RouteFilterRulesInner.this.listByRouteFilterNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RouteFilterRuleInner>>> listByRouteFilterNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByRouteFilterNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RouteFilterRuleInner>>>>(){

            public Observable<ServiceResponse<Page<RouteFilterRuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RouteFilterRulesInner.this.listByRouteFilterNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RouteFilterRuleInner>> listByRouteFilterNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RouteFilterRuleInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface RouteFilterRulesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.RouteFilterRules delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}/routeFilterRules/{ruleName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="routeFilterName") String var2, @Path(value="ruleName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.RouteFilterRules beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}/routeFilterRules/{ruleName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="routeFilterName") String var2, @Path(value="ruleName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.RouteFilterRules get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}/routeFilterRules/{ruleName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="routeFilterName") String var2, @Path(value="ruleName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.RouteFilterRules createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}/routeFilterRules/{ruleName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="routeFilterName") String var2, @Path(value="ruleName") String var3, @Path(value="subscriptionId") String var4, @Body RouteFilterRuleInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.RouteFilterRules beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}/routeFilterRules/{ruleName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="routeFilterName") String var2, @Path(value="ruleName") String var3, @Path(value="subscriptionId") String var4, @Body RouteFilterRuleInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.RouteFilterRules update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}/routeFilterRules/{ruleName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="routeFilterName") String var2, @Path(value="ruleName") String var3, @Path(value="subscriptionId") String var4, @Body PatchRouteFilterRuleInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.RouteFilterRules beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}/routeFilterRules/{ruleName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="routeFilterName") String var2, @Path(value="ruleName") String var3, @Path(value="subscriptionId") String var4, @Body PatchRouteFilterRuleInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.RouteFilterRules listByRouteFilter"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}/routeFilterRules")
        public Observable<Response<ResponseBody>> listByRouteFilter(@Path(value="resourceGroupName") String var1, @Path(value="routeFilterName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.RouteFilterRules listByRouteFilterNext"})
        @GET
        public Observable<Response<ResponseBody>> listByRouteFilterNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

