/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.network.LoadBalancerBackend;
import com.microsoft.azure.management.network.LoadBalancerFrontend;
import com.microsoft.azure.management.network.LoadBalancerHttpProbe;
import com.microsoft.azure.management.network.LoadBalancerInboundNatPool;
import com.microsoft.azure.management.network.LoadBalancerInboundNatRule;
import com.microsoft.azure.management.network.LoadBalancerPrivateFrontend;
import com.microsoft.azure.management.network.LoadBalancerPublicFrontend;
import com.microsoft.azure.management.network.LoadBalancerTcpProbe;
import com.microsoft.azure.management.network.LoadBalancingRule;
import com.microsoft.azure.management.network.PublicIPAddress;
import com.microsoft.azure.management.network.implementation.LoadBalancerInner;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.model.HasLoadBalancingRules;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.List;
import java.util.Map;

@Fluent
@Beta
public interface LoadBalancer
extends GroupableResource<NetworkManager, LoadBalancerInner>,
Refreshable<LoadBalancer>,
Updatable<Update>,
HasLoadBalancingRules {
    public List<String> publicIPAddressIds();

    public Map<String, LoadBalancerTcpProbe> tcpProbes();

    public Map<String, LoadBalancerHttpProbe> httpProbes();

    public Map<String, LoadBalancerBackend> backends();

    public Map<String, LoadBalancerInboundNatRule> inboundNatRules();

    public Map<String, LoadBalancerFrontend> frontends();

    @Beta(value=Beta.SinceVersion.V1_2_0)
    public Map<String, LoadBalancerPrivateFrontend> privateFrontends();

    @Beta(value=Beta.SinceVersion.V1_2_0)
    public LoadBalancerPublicFrontend findFrontendByPublicIPAddress(PublicIPAddress var1);

    @Beta(value=Beta.SinceVersion.V1_2_0)
    public LoadBalancerPublicFrontend findFrontendByPublicIPAddress(String var1);

    @Beta(value=Beta.SinceVersion.V1_2_0)
    public Map<String, LoadBalancerPublicFrontend> publicFrontends();

    public Map<String, LoadBalancerInboundNatPool> inboundNatPools();

    public static interface Update
    extends Appliable<LoadBalancer>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithProbe,
    UpdateStages.WithBackend,
    UpdateStages.WithLoadBalancingRule,
    UpdateStages.WithPublicFrontend,
    UpdateStages.WithPrivateFrontend,
    UpdateStages.WithInboundNatRule,
    UpdateStages.WithInboundNatPool {
    }

    public static interface UpdateStages {

        public static interface WithInboundNatPool {
            public Update withoutInboundNatPool(String var1);

            public LoadBalancerInboundNatPool.UpdateDefinitionStages.Blank<Update> defineInboundNatPool(String var1);

            public LoadBalancerInboundNatPool.Update updateInboundNatPool(String var1);
        }

        public static interface WithInboundNatRule {
            public Update withoutInboundNatRule(String var1);

            public LoadBalancerInboundNatRule.UpdateDefinitionStages.Blank<Update> defineInboundNatRule(String var1);

            public LoadBalancerInboundNatRule.Update updateInboundNatRule(String var1);
        }

        public static interface WithPrivateFrontend {
            public LoadBalancerPrivateFrontend.UpdateDefinitionStages.Blank<Update> definePrivateFrontend(String var1);

            public LoadBalancerPrivateFrontend.Update updatePrivateFrontend(String var1);
        }

        public static interface WithPublicFrontend {
            public LoadBalancerPublicFrontend.UpdateDefinitionStages.Blank<Update> definePublicFrontend(String var1);

            public Update withoutFrontend(String var1);

            public LoadBalancerPublicFrontend.Update updatePublicFrontend(String var1);
        }

        public static interface WithLoadBalancingRule {
            public LoadBalancingRule.UpdateDefinitionStages.Blank<Update> defineLoadBalancingRule(String var1);

            public Update withoutLoadBalancingRule(String var1);

            public LoadBalancingRule.Update updateLoadBalancingRule(String var1);
        }

        public static interface WithProbe {
            public LoadBalancerHttpProbe.UpdateDefinitionStages.Blank<Update> defineHttpProbe(String var1);

            public LoadBalancerTcpProbe.UpdateDefinitionStages.Blank<Update> defineTcpProbe(String var1);

            public Update withoutProbe(String var1);

            public LoadBalancerTcpProbe.Update updateTcpProbe(String var1);

            public LoadBalancerHttpProbe.Update updateHttpProbe(String var1);
        }

        public static interface WithBackend {
            public Update withoutBackend(String var1);

            public LoadBalancerBackend.UpdateDefinitionStages.Blank<Update> defineBackend(String var1);

            public LoadBalancerBackend.Update updateBackend(String var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithInboundNatPool {
            public LoadBalancerInboundNatPool.DefinitionStages.Blank<WithCreateAndInboundNatPool> defineInboundNatPool(String var1);
        }

        public static interface WithInboundNatRule {
            public LoadBalancerInboundNatRule.DefinitionStages.Blank<WithCreateAndInboundNatRule> defineInboundNatRule(String var1);
        }

        public static interface WithCreateAndInboundNatRule
        extends WithCreate,
        WithInboundNatRule {
        }

        public static interface WithCreateAndInboundNatPool
        extends WithCreate,
        WithInboundNatPool {
        }

        public static interface WithCreateAndNatChoice
        extends WithCreate,
        WithInboundNatRule,
        WithInboundNatPool {
        }

        public static interface WithCreate
        extends Creatable<LoadBalancer>,
        Resource.DefinitionWithTags<WithCreate>,
        WithBackend,
        WithFrontend,
        WithProbe {
        }

        public static interface WithLBRuleOrNatOrCreate
        extends WithLoadBalancingRule,
        WithCreateAndNatChoice {
        }

        public static interface WithLoadBalancingRule {
            public LoadBalancingRule.DefinitionStages.Blank<WithLBRuleOrNatOrCreate> defineLoadBalancingRule(String var1);
        }

        public static interface WithProbe {
            public LoadBalancerTcpProbe.DefinitionStages.Blank<WithCreate> defineTcpProbe(String var1);

            public LoadBalancerHttpProbe.DefinitionStages.Blank<WithCreate> defineHttpProbe(String var1);
        }

        public static interface WithLBRuleOrNat
        extends WithLoadBalancingRule,
        WithInboundNatRule,
        WithInboundNatPool {
        }

        public static interface WithBackend {
            public LoadBalancerBackend.DefinitionStages.Blank<WithCreate> defineBackend(String var1);
        }

        public static interface WithPublicFrontend {
            public LoadBalancerPublicFrontend.DefinitionStages.Blank<WithCreate> definePublicFrontend(String var1);
        }

        public static interface WithPrivateFrontend {
            public LoadBalancerPrivateFrontend.DefinitionStages.Blank<WithCreate> definePrivateFrontend(String var1);
        }

        public static interface WithFrontend
        extends WithPublicFrontend,
        WithPrivateFrontend {
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithLBRuleOrNat> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithCreate,
    DefinitionStages.WithBackend,
    DefinitionStages.WithLoadBalancingRule,
    DefinitionStages.WithLBRuleOrNat,
    DefinitionStages.WithLBRuleOrNatOrCreate,
    DefinitionStages.WithCreateAndInboundNatPool,
    DefinitionStages.WithCreateAndInboundNatRule,
    DefinitionStages.WithCreateAndNatChoice {
    }
}

