/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for PcError.
 */
public final class PcError {
    /** Static value InternalError for PcError. */
    public static final PcError INTERNAL_ERROR = new PcError("InternalError");

    /** Static value AgentStopped for PcError. */
    public static final PcError AGENT_STOPPED = new PcError("AgentStopped");

    /** Static value CaptureFailed for PcError. */
    public static final PcError CAPTURE_FAILED = new PcError("CaptureFailed");

    /** Static value LocalFileFailed for PcError. */
    public static final PcError LOCAL_FILE_FAILED = new PcError("LocalFileFailed");

    /** Static value StorageFailed for PcError. */
    public static final PcError STORAGE_FAILED = new PcError("StorageFailed");

    private String value;

    /**
     * Creates a custom value for PcError.
     * @param value the custom value
     */
    public PcError(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PcError)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PcError rhs = (PcError) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
