/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.analytics.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.datalake.analytics.ComputePolicies;
import com.microsoft.azure.management.datalake.analytics.implementation.DataLakeAnalyticsAccountManagementClientImpl;
import com.microsoft.azure.management.datalake.analytics.models.ComputePolicy;
import com.microsoft.azure.management.datalake.analytics.models.CreateOrUpdateComputePolicyParameters;
import com.microsoft.azure.management.datalake.analytics.models.PageImpl;
import com.microsoft.azure.management.datalake.analytics.models.UpdateComputePolicyParameters;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ComputePoliciesImpl
implements ComputePolicies {
    private ComputePoliciesService service;
    private DataLakeAnalyticsAccountManagementClientImpl client;

    public ComputePoliciesImpl(Retrofit retrofit, DataLakeAnalyticsAccountManagementClientImpl client) {
        this.service = (ComputePoliciesService)retrofit.create(ComputePoliciesService.class);
        this.client = client;
    }

    @Override
    public PagedList<ComputePolicy> listByAccount(String resourceGroupName, String accountName) {
        ServiceResponse response = (ServiceResponse)this.listByAccountSinglePageAsync(resourceGroupName, accountName).toBlocking().single();
        return new PagedList<ComputePolicy>((Page)response.body()){

            public Page<ComputePolicy> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ComputePoliciesImpl.this.listByAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<ComputePolicy>> listByAccountAsync(String resourceGroupName, String accountName, ListOperationCallback<ComputePolicy> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByAccountSinglePageAsync(resourceGroupName, accountName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ComputePolicy>>>>(){

            public Observable<ServiceResponse<Page<ComputePolicy>>> call(String nextPageLink) {
                return ComputePoliciesImpl.this.listByAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<ComputePolicy>> listByAccountAsync(String resourceGroupName, String accountName) {
        return this.listByAccountWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Page<ComputePolicy>>, Page<ComputePolicy>>(){

            public Page<ComputePolicy> call(ServiceResponse<Page<ComputePolicy>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<ComputePolicy>>> listByAccountWithServiceResponseAsync(String resourceGroupName, String accountName) {
        return this.listByAccountSinglePageAsync(resourceGroupName, accountName).concatMap((Func1)new Func1<ServiceResponse<Page<ComputePolicy>>, Observable<ServiceResponse<Page<ComputePolicy>>>>(){

            public Observable<ServiceResponse<Page<ComputePolicy>>> call(ServiceResponse<Page<ComputePolicy>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ComputePoliciesImpl.this.listByAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ComputePolicy>>> listByAccountSinglePageAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByAccount(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ComputePolicy>>>>(){

            public Observable<ServiceResponse<Page<ComputePolicy>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ComputePoliciesImpl.this.listByAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ComputePolicy>> listByAccountDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ComputePolicy>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public ComputePolicy createOrUpdate(String resourceGroupName, String accountName, String computePolicyName, CreateOrUpdateComputePolicyParameters parameters) {
        return (ComputePolicy)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, computePolicyName, parameters).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<ComputePolicy> createOrUpdateAsync(String resourceGroupName, String accountName, String computePolicyName, CreateOrUpdateComputePolicyParameters parameters, ServiceCallback<ComputePolicy> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, computePolicyName, parameters), serviceCallback);
    }

    @Override
    public Observable<ComputePolicy> createOrUpdateAsync(String resourceGroupName, String accountName, String computePolicyName, CreateOrUpdateComputePolicyParameters parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, computePolicyName, parameters).map((Func1)new Func1<ServiceResponse<ComputePolicy>, ComputePolicy>(){

            public ComputePolicy call(ServiceResponse<ComputePolicy> response) {
                return (ComputePolicy)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<ComputePolicy>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String accountName, String computePolicyName, CreateOrUpdateComputePolicyParameters parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (computePolicyName == null) {
            throw new IllegalArgumentException("Parameter computePolicyName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, accountName, computePolicyName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ComputePolicy>>>(){

            public Observable<ServiceResponse<ComputePolicy>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ComputePoliciesImpl.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ComputePolicy> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ComputePolicy>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public ComputePolicy get(String resourceGroupName, String accountName, String computePolicyName) {
        return (ComputePolicy)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, accountName, computePolicyName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<ComputePolicy> getAsync(String resourceGroupName, String accountName, String computePolicyName, ServiceCallback<ComputePolicy> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, accountName, computePolicyName), serviceCallback);
    }

    @Override
    public Observable<ComputePolicy> getAsync(String resourceGroupName, String accountName, String computePolicyName) {
        return this.getWithServiceResponseAsync(resourceGroupName, accountName, computePolicyName).map((Func1)new Func1<ServiceResponse<ComputePolicy>, ComputePolicy>(){

            public ComputePolicy call(ServiceResponse<ComputePolicy> response) {
                return (ComputePolicy)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<ComputePolicy>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String computePolicyName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (computePolicyName == null) {
            throw new IllegalArgumentException("Parameter computePolicyName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(this.client.subscriptionId(), resourceGroupName, accountName, computePolicyName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ComputePolicy>>>(){

            public Observable<ServiceResponse<ComputePolicy>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ComputePoliciesImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ComputePolicy> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ComputePolicy>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public ComputePolicy update(String resourceGroupName, String accountName, String computePolicyName) {
        return (ComputePolicy)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, accountName, computePolicyName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<ComputePolicy> updateAsync(String resourceGroupName, String accountName, String computePolicyName, ServiceCallback<ComputePolicy> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, computePolicyName), serviceCallback);
    }

    @Override
    public Observable<ComputePolicy> updateAsync(String resourceGroupName, String accountName, String computePolicyName) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, computePolicyName).map((Func1)new Func1<ServiceResponse<ComputePolicy>, ComputePolicy>(){

            public ComputePolicy call(ServiceResponse<ComputePolicy> response) {
                return (ComputePolicy)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<ComputePolicy>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String computePolicyName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (computePolicyName == null) {
            throw new IllegalArgumentException("Parameter computePolicyName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        UpdateComputePolicyParameters parameters = null;
        return this.service.update(this.client.subscriptionId(), resourceGroupName, accountName, computePolicyName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ComputePolicy>>>(){

            public Observable<ServiceResponse<ComputePolicy>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ComputePoliciesImpl.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public ComputePolicy update(String resourceGroupName, String accountName, String computePolicyName, UpdateComputePolicyParameters parameters) {
        return (ComputePolicy)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, accountName, computePolicyName, parameters).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<ComputePolicy> updateAsync(String resourceGroupName, String accountName, String computePolicyName, UpdateComputePolicyParameters parameters, ServiceCallback<ComputePolicy> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, computePolicyName, parameters), serviceCallback);
    }

    @Override
    public Observable<ComputePolicy> updateAsync(String resourceGroupName, String accountName, String computePolicyName, UpdateComputePolicyParameters parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, computePolicyName, parameters).map((Func1)new Func1<ServiceResponse<ComputePolicy>, ComputePolicy>(){

            public ComputePolicy call(ServiceResponse<ComputePolicy> response) {
                return (ComputePolicy)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<ComputePolicy>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String computePolicyName, UpdateComputePolicyParameters parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (computePolicyName == null) {
            throw new IllegalArgumentException("Parameter computePolicyName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.update(this.client.subscriptionId(), resourceGroupName, accountName, computePolicyName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ComputePolicy>>>(){

            public Observable<ServiceResponse<ComputePolicy>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ComputePoliciesImpl.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ComputePolicy> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ComputePolicy>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String computePolicyName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, accountName, computePolicyName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, String computePolicyName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, accountName, computePolicyName), serviceCallback);
    }

    @Override
    public Observable<Void> deleteAsync(String resourceGroupName, String accountName, String computePolicyName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, accountName, computePolicyName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName, String computePolicyName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (computePolicyName == null) {
            throw new IllegalArgumentException("Parameter computePolicyName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(this.client.subscriptionId(), resourceGroupName, accountName, computePolicyName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ComputePoliciesImpl.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    @Override
    public PagedList<ComputePolicy> listByAccountNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByAccountNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ComputePolicy>((Page)response.body()){

            public Page<ComputePolicy> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ComputePoliciesImpl.this.listByAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<ComputePolicy>> listByAccountNextAsync(String nextPageLink, ServiceFuture<List<ComputePolicy>> serviceFuture, ListOperationCallback<ComputePolicy> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByAccountNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ComputePolicy>>>>(){

            public Observable<ServiceResponse<Page<ComputePolicy>>> call(String nextPageLink) {
                return ComputePoliciesImpl.this.listByAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<ComputePolicy>> listByAccountNextAsync(String nextPageLink) {
        return this.listByAccountNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ComputePolicy>>, Page<ComputePolicy>>(){

            public Page<ComputePolicy> call(ServiceResponse<Page<ComputePolicy>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<ComputePolicy>>> listByAccountNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByAccountNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ComputePolicy>>, Observable<ServiceResponse<Page<ComputePolicy>>>>(){

            public Observable<ServiceResponse<Page<ComputePolicy>>> call(ServiceResponse<Page<ComputePolicy>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ComputePoliciesImpl.this.listByAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ComputePolicy>>> listByAccountNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByAccountNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ComputePolicy>>>>(){

            public Observable<ServiceResponse<Page<ComputePolicy>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ComputePoliciesImpl.this.listByAccountNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ComputePolicy>> listByAccountNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ComputePolicy>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ComputePoliciesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.ComputePolicies listByAccount"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/computePolicies")
        public Observable<Response<ResponseBody>> listByAccount(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.ComputePolicies createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/computePolicies/{computePolicyName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="computePolicyName") String var4, @Body CreateOrUpdateComputePolicyParameters var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.ComputePolicies get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/computePolicies/{computePolicyName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="computePolicyName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.ComputePolicies update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/computePolicies/{computePolicyName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="computePolicyName") String var4, @Body UpdateComputePolicyParameters var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.ComputePolicies delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/computePolicies/{computePolicyName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="computePolicyName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.datalake.analytics.ComputePolicies listByAccountNext"})
        @GET
        public Observable<Response<ResponseBody>> listByAccountNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

